/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.IPostureLossProjectile;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.items.abilities.ChainLightning;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SilverBulletEntity
extends NonArrowProjectile
implements GeoEntity,
IPostureLossProjectile {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int postureLoss;
    private boolean isEthereal;
    private float explosionPower;
    private float chainLightningDamage;
    private float chainLightningRange;
    private int blightCarrier;
    private int freezeAmplifier;
    private int tether;
    private int maxEchoDelay;
    private int maxAge = 60;
    private static final EntityDataAccessor<Boolean> ECHO_COPY = SynchedEntityData.m_135353_(SilverBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ECHO_TIMER = SynchedEntityData.m_135353_(SilverBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RICOCHET_BOUNCES = SynchedEntityData.m_135353_(SilverBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SilverBulletEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SILVER_BULLET_ENTITY_TYPE.get()), owner, world, stack);
    }

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world, LivingEntity owner, ItemStack stack) {
        super(entityType, owner, world, stack);
    }

    public void m_8119_() {
        if (this.isEchoCopy()) {
            this.reduceEchoCopyTimer();
            if (this.getEchoCopyTimer() > 0) {
                float spread = this.m_20205_() * 0.1f;
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f));
                }
                return;
            }
        }
        if (this.m_36797_()) {
            this.m_146926_(0.0f);
            this.m_146922_(0.0f);
            Vec3 currentPos = this.m_20182_();
            Vec3 velocity = this.m_20184_();
            Vec3 nextPos = currentPos.m_82549_(velocity);
            EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(velocity).m_82400_(1.0), e -> e instanceof LivingEntity && e != this.m_19749_(), (double)5.0);
            if (entityHit != null) {
                this.m_5790_(entityHit);
                return;
            }
        }
        super.m_8119_();
        if (this.m_36797_()) {
            this.m_146926_(0.0f);
            this.m_146922_(0.0f);
        }
        if (!this.f_36703_) {
            Vec3 vec3d = this.m_20184_();
            double e2 = vec3d.f_82479_;
            double f = vec3d.f_82480_;
            double g = vec3d.f_82481_;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)(this.isEchoCopy() ? (ParticleOptions)ParticleRegistry.ECHO_SMOKE.get() : ParticleTypes.f_123762_), this.m_20185_() + e2 * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0 + 0.25, this.m_20189_() + g * (double)i / 4.0, -e2 * 0.2, (-f + 0.2) * 0.2, -g * 0.2);
            }
        }
        if (this.f_19797_ > this.getMaxAge() || this.f_36704_ >= 10) {
            this.m_146870_();
        }
    }

    public void m_142036_() {
        super.m_142036_();
        for (int i = 0; i < 4; ++i) {
            float spread = this.m_20205_() * 0.3f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f), (double)(this.f_19796_.m_188501_() * spread - spread / 2.0f));
        }
    }

    protected void m_6532_(HitResult hitResult) {
        EntityHitResult entityHitResult;
        HitResult.Type type = hitResult.m_6662_();
        if (this.isEchoCopy() && type == HitResult.Type.ENTITY && (entityHitResult = (EntityHitResult)hitResult).m_82443_() == this.m_19749_()) {
            return;
        }
        super.m_6532_(hitResult);
    }

    public boolean m_20068_() {
        return true;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12442_;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.getRicochetBounces() > 0) {
            Vec3 newDir;
            LivingEntity owner;
            LivingEntity target;
            this.setRicochetBounces(this.getRicochetBounces() - 1);
            Predicate<LivingEntity> isPet = e -> {
                Entity patt0$temp = this.m_19749_();
                if (!(patt0$temp instanceof LivingEntity)) return false;
                LivingEntity owner = (LivingEntity)patt0$temp;
                if (!(e instanceof TamableAnimal)) return false;
                TamableAnimal tame = (TamableAnimal)e;
                if (tame.m_269323_() == null) return false;
                if (!tame.m_269323_().equals((Object)owner)) return false;
                return true;
            };
            LivingEntity newTarget = null;
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity && (target = (owner = (LivingEntity)entity).m_21214_()) != null && target.m_6084_() && !isPet.test(target) && this.canSee(target) && target != owner) {
                newTarget = target;
            }
            if (newTarget == null) {
                double searchRadius = 8.0;
                AABB box = this.m_20191_().m_82400_(searchRadius);
                List candidates = this.m_9236_().m_6443_(LivingEntity.class, box, e -> e.m_6084_() && e != this.m_19749_() && !isPet.test((LivingEntity)e));
                newTarget = candidates.stream().filter(this::canSee).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).orElse(null);
            }
            if (newTarget != null) {
                Vec3 from = this.m_20182_();
                Vec3 to = newTarget.m_20182_().m_82520_(0.0, (double)newTarget.m_20206_() * 0.5, 0.0);
                newDir = to.m_82546_(from).m_82541_();
            } else {
                Vec3i face = blockHitResult.m_82434_().m_122436_();
                Vec3 normal = new Vec3((double)face.m_123341_(), (double)face.m_123342_(), (double)face.m_123343_()).m_82541_();
                Vec3 incoming = this.m_20184_().m_82541_();
                Vec3 reflect = incoming.m_82546_(normal.m_82490_(2.0 * incoming.m_82526_(normal))).m_82541_();
                double jitterStrength = 0.2;
                Vec3 randVec = new Vec3(this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_()).m_82541_();
                Vec3 perp = randVec.m_82546_(reflect.m_82490_(randVec.m_82526_(reflect))).m_82541_();
                newDir = reflect.m_82549_(perp.m_82490_(jitterStrength)).m_82541_();
            }
            double oldSpeed = this.m_20184_().m_82553_();
            double newSpeed = Math.max(oldSpeed - 1.5, 1.5);
            Vec3 vel = newDir.m_82490_(newSpeed);
            this.m_20256_(vel);
            this.f_19812_ = true;
            return;
        }
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    private boolean canSee(LivingEntity e) {
        Vec3 start = this.m_20182_();
        Vec3 end = e.m_20182_().m_82520_(0.0, (double)e.m_20206_() * 0.5, 0.0);
        BlockHitResult ray = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return ray.m_6662_() == HitResult.Type.MISS;
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity posture2;
        LivingEntity target;
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            Entity entity2;
            target = (LivingEntity)entity;
            this.applyPostureLoss(target);
            int posture2 = PostureData.getPosture(target);
            if (!EntityPosture.isPostureDisabled(target) && posture2 >= EntityPosture.getMaxPostureLoss(target)) {
                this.onPostureBreak(target);
            }
            if (target.m_21222_()) {
                this.m_36781_(this.m_36789_() + (double)ConfigConstructor.silver_bullet_undead_bonus_damage / this.m_20184_().m_82553_());
            }
            if ((entity2 = this.m_19749_()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                if (this.chainLightningDamage > 0.0f) {
                    ChainLightning.trigger(this.m_9236_(), target, owner, false, this.getChainLightningDamage(), this.getChainLightningRange());
                }
            }
            if (this.getBlightCarrier() > 0) {
                MobEffectInstance instance = target.m_21124_((MobEffect)EffectRegistry.BLIGHT.get());
                if (instance != null) {
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), (int)ConfigConstructor.blight_carrier_enchant_blight_duration, instance.m_19564_() + this.getBlightCarrier() - 1));
                } else {
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLIGHT.get(), (int)ConfigConstructor.blight_carrier_enchant_blight_duration, this.getBlightCarrier() - 1));
                }
            }
        }
        super.m_5790_(entityHitResult);
        if (this.getTether() > 0 && (posture2 = entityHitResult.m_82443_()) instanceof LivingEntity) {
            target = (LivingEntity)posture2;
            Entity shooter = this.m_19749_();
            if (shooter instanceof LivingEntity) {
                double minRange;
                double resistanceFactor = Math.max(0.0, 1.0 - target.m_21133_(Attributes.f_22278_));
                Vec3 toShooter = new Vec3(shooter.m_20185_() - target.m_20185_(), 0.0, shooter.m_20189_() - target.m_20189_());
                double distance = toShooter.m_82553_();
                if (distance > (minRange = (double)(1.0f + (float)this.getTether() * ConfigConstructor.tether_enchant_min_activation_range_per_level))) {
                    double pullStrength = (double)((float)this.getTether() * ConfigConstructor.tether_enchant_drag_mod) * resistanceFactor;
                    Vec3 pullVel = toShooter.m_82541_().m_82490_(pullStrength);
                    double maxAllowedPull = distance - minRange;
                    if (pullVel.m_82553_() > maxAllowedPull) {
                        pullVel = pullVel.m_82541_().m_82490_(maxAllowedPull);
                    }
                    target.m_5997_(pullVel.f_82479_, 0.1, pullVel.f_82481_);
                }
            }
        }
        if (this.explosionPower > 0.0f && !this.m_9236_().f_46443_) {
            ParticleHandler.particleOutburst(this.m_9236_(), 30, this.m_20185_(), this.m_20186_(), this.m_20189_(), (ParticleOptions)ParticleTypes.f_123746_, new Vec3(1.0, 1.0, 1.0), 0.6f);
            this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, ConfigConstructor.explosive_rounds_enchant_destroys_blocks ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
        }
        this.m_146870_();
    }

    private void onPostureBreak(LivingEntity target) {
        if (this.getFreezeAmplifier() > 0) {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), (int)ConfigConstructor.frostsilver_enchant_permafrost_duration, this.getFreezeAmplifier() - 1));
            target.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_144211_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    @Override
    public int getMaxAge() {
        return this.maxAge + this.getMaxEchoDelay();
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("postureLoss")) {
            this.setPostureLoss(nbt.m_128451_("postureLoss"));
        }
        if (nbt.m_128441_("ethereal")) {
            this.isEthereal = nbt.m_128471_("ethereal");
        }
        if (nbt.m_128441_("explosionPower")) {
            this.explosionPower = nbt.m_128457_("explosionPower");
        }
        if (nbt.m_128441_("chainLightningDamage")) {
            this.chainLightningDamage = nbt.m_128457_("chainLightningDamage");
        }
        if (nbt.m_128441_("chainLightningRange")) {
            this.chainLightningRange = nbt.m_128457_("chainLightningRange");
        }
        if (nbt.m_128441_("blightCarrier")) {
            this.blightCarrier = nbt.m_128451_("blightCarrier");
        }
        if (nbt.m_128441_("freezeAmplifier")) {
            this.freezeAmplifier = nbt.m_128451_("freezeAmplifier");
        }
        if (nbt.m_128441_("echoCopy")) {
            this.setEchoCopy(nbt.m_128471_("echoCopy"));
        }
        if (nbt.m_128441_("echoCopyTimer")) {
            this.setEchoCopyTimer(nbt.m_128451_("echoCopyTimer"));
        }
        if (nbt.m_128441_("tether")) {
            this.tether = nbt.m_128451_("tether");
        }
        if (nbt.m_128441_("ricochetBounces")) {
            this.setRicochetBounces(nbt.m_128451_("ricochetBounces"));
        }
        if (nbt.m_128441_("maxEchoDelay")) {
            this.setMaxEchoDelay(nbt.m_128451_("maxEchoDelay"));
        }
        if (nbt.m_128441_("maxAge")) {
            this.maxAge = nbt.m_128451_("maxAge");
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("postureLoss", this.getPostureLoss());
        nbt.m_128379_("ethereal", this.isEthereal);
        nbt.m_128350_("explosionPower", this.explosionPower);
        nbt.m_128350_("chainLightningDamage", this.chainLightningDamage);
        nbt.m_128350_("chainLightningRange", this.chainLightningRange);
        nbt.m_128405_("blightCarrier", this.blightCarrier);
        nbt.m_128405_("freezeAmplifier", this.freezeAmplifier);
        nbt.m_128379_("echoCopy", this.isEchoCopy());
        nbt.m_128405_("echoCopyTimer", this.getEchoCopyTimer());
        nbt.m_128405_("tether", this.tether);
        nbt.m_128405_("ricochetBounces", this.getRicochetBounces());
        nbt.m_128405_("maxEchoDelay", this.getMaxEchoDelay());
        nbt.m_128405_("maxAge", this.maxAge);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ECHO_COPY, (Object)false);
        this.f_19804_.m_135372_(ECHO_TIMER, (Object)0);
        this.f_19804_.m_135372_(RICOCHET_BOUNCES, (Object)0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected ItemStack m_7941_() {
        return ((Item)ItemRegistry.SILVER_BULLET.get()).m_7968_();
    }

    public void setEthereal(boolean ethereal) {
        this.isEthereal = ethereal;
    }

    public boolean isEthereal() {
        return this.isEthereal;
    }

    @Override
    public void setPostureLoss(int postureLoss) {
        this.postureLoss = postureLoss;
    }

    @Override
    public int getPostureLoss() {
        return this.postureLoss;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public void setChainLightningDamage(float chainLightningDamage) {
        this.chainLightningDamage = chainLightningDamage;
    }

    public float getChainLightningDamage() {
        return this.chainLightningDamage;
    }

    public void setChainLightningRange(float chainLightningRange) {
        this.chainLightningRange = chainLightningRange;
    }

    public float getChainLightningRange() {
        return this.chainLightningRange;
    }

    public void setBlightCarrier(int blightCarrier) {
        this.blightCarrier = blightCarrier;
    }

    public int getBlightCarrier() {
        return this.blightCarrier;
    }

    public void setFreezeAmplifier(int freezeAmplifier) {
        this.freezeAmplifier = freezeAmplifier;
    }

    public int getFreezeAmplifier() {
        return this.freezeAmplifier;
    }

    public void setEchoCopy(boolean bl) {
        this.f_19804_.m_135381_(ECHO_COPY, (Object)bl);
    }

    public boolean isEchoCopy() {
        return (Boolean)this.f_19804_.m_135370_(ECHO_COPY);
    }

    public void setEchoCopyTimer(int amount) {
        this.f_19804_.m_135381_(ECHO_TIMER, (Object)amount);
    }

    private void reduceEchoCopyTimer() {
        this.setEchoCopyTimer(this.getEchoCopyTimer() - 1);
    }

    private int getEchoCopyTimer() {
        return (Integer)this.f_19804_.m_135370_(ECHO_TIMER);
    }

    public void setTether(int tether) {
        this.tether = tether;
    }

    public int getTether() {
        return this.tether;
    }

    public void setRicochetBounces(int ricochetBounces) {
        this.f_19804_.m_135381_(RICOCHET_BOUNCES, (Object)ricochetBounces);
    }

    public int getRicochetBounces() {
        return (Integer)this.f_19804_.m_135370_(RICOCHET_BOUNCES);
    }

    public int getMaxEchoDelay() {
        return this.maxEchoDelay;
    }

    public void setMaxEchoDelay(int maxEchoDelay) {
        this.maxEchoDelay = maxEchoDelay;
    }
}

