/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoonlightProjectile
extends NonArrowProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Integer> MODEL_ROTATION = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EFFECT_TICKS = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EFFECT_AMPLIFIER = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> APPLIED_EFFECT_ID = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public MoonlightProjectile(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.quickInit();
    }

    public MoonlightProjectile(EntityType<? extends AbstractArrow> type, Level world, LivingEntity owner, ItemStack stack) {
        super(type, owner, world, stack);
        this.quickInit();
    }

    public MoonlightProjectile(EntityType<? extends AbstractArrow> type, Level world, LivingEntity owner) {
        super(type, owner, world, ((TieredItem)WeaponRegistry.MOONLIGHT_GREATSWORD.get()).m_7968_());
        this.quickInit();
    }

    private void quickInit() {
        this.setMaxAge(30);
        this.setAreaParticle((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get());
        this.setDespawnParticle((ParticleOptions)ParticleTypes.f_123745_);
        this.setDespawnParticleCount(75);
        this.setTrailParticle((ParticleOptions)ParticleTypes.f_175827_);
        this.setDespawnParticleCount(4);
        this.setDespawnParticleExpansion(0.125f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL_ROTATION, (Object)0);
        this.f_19804_.m_135372_(EFFECT_TICKS, (Object)0);
        this.f_19804_.m_135372_(EFFECT_AMPLIFIER, (Object)0);
        this.f_19804_.m_135372_(APPLIED_EFFECT_ID, (Object)"");
    }

    public void setAgeAndPoints(int maxAge, int explosionPoints, int tickParticleAmount) {
        this.setMaxAge(maxAge);
        this.setDespawnParticleCount(explosionPoints);
        this.setTrailParticleCount(tickParticleAmount);
    }

    public void setModelRotation(int degrees) {
        this.f_19804_.m_135381_(MODEL_ROTATION, (Object)degrees);
    }

    public int getModelRotation() {
        return (Integer)this.f_19804_.m_135370_(MODEL_ROTATION);
    }

    public void m_8119_() {
        int i;
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        double e = vec3d.f_82479_;
        double f = vec3d.f_82480_;
        double g = vec3d.f_82481_;
        for (i = 0; i < this.getTrailParticleCount(); ++i) {
            this.m_9236_().m_7106_(this.getTrailParticle(), this.m_20185_() + e * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0, this.m_20189_() + g * (double)i / 4.0, -e, -f + 0.2, -g);
        }
        for (i = 0; i < this.getAreaParticleCount(); ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), this.m_20208_(0.5), this.m_20187_() - 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.f_19797_ > this.getMaxAge()) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    public int m_150123_() {
        if (this.m_7941_() != null) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)this.m_7941_());
        }
        return super.m_150123_();
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.m_7941_() != null) {
                float bonus = EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)living.m_6336_());
                this.m_36781_(this.m_36789_() + (double)(bonus >= 5.0f ? bonus * 0.7f : bonus));
            }
        }
        super.m_5790_(entityHitResult);
        if (this.getAppliedEffectTicks() > 0 && this.getAppliedEffectId().isEmpty() && entityHitResult.m_82443_() != null) {
            entityHitResult.m_82443_().m_7311_(this.getAppliedEffectTicks());
        }
        if (!this.getAppliedEffectId().isEmpty() && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.m_7292_(new MobEffectInstance(this.getAppliedEffect(), this.getAppliedEffectTicks(), this.getEffectAmplifier()));
        }
        this.m_146870_();
    }

    public void detonateEntity(Level world, double x, double y, double z, double points, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.m_6493_(this.getDespawnParticle(), true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    public void m_142036_() {
        super.m_142036_();
        this.detonateEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getDespawnParticleCount(), this.getDespawnParticleExpansion());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11913_;
    }

    protected float m_6882_() {
        return 1.01f;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setAppliedEffectDuration(int ticks) {
        this.f_19804_.m_135381_(EFFECT_TICKS, (Object)ticks);
    }

    public int getAppliedEffectTicks() {
        return (Integer)this.f_19804_.m_135370_(EFFECT_TICKS);
    }

    public String getAppliedEffectId() {
        return (String)this.f_19804_.m_135370_(APPLIED_EFFECT_ID);
    }

    public void setAppliedEffectId(String string) {
        this.f_19804_.m_135381_(APPLIED_EFFECT_ID, (Object)string);
    }

    public void setAppliedStatusEffect(MobEffect effect) {
        this.setAppliedEffectId(Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)));
    }

    public void setAppliedEffectId(ResourceLocation identifier) {
        this.setAppliedEffectId(identifier.toString());
    }

    public MobEffect getAppliedEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.getAppliedEffectId()));
    }

    public int getEffectAmplifier() {
        return (Integer)this.f_19804_.m_135370_(EFFECT_AMPLIFIER);
    }

    public void setEffectAmplifier(int amplifier) {
        this.f_19804_.m_135381_(EFFECT_AMPLIFIER, (Object)amplifier);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("ModelRotation", this.getModelRotation());
        nbt.m_128359_("AppliedEffectId", this.getAppliedEffectId());
        nbt.m_128405_("AppliedEffectAmplifier", this.getEffectAmplifier());
        nbt.m_128405_("AppliedEffectTicks", this.getAppliedEffectTicks());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("ModelRotation")) {
            this.setModelRotation(nbt.m_128451_("ModelRotation"));
        }
        if (nbt.m_128441_("AppliedEffectId")) {
            this.setAppliedEffectId(nbt.m_128461_("AppliedEffectId"));
        }
        if (nbt.m_128441_("AppliedEffectAmplifier")) {
            this.setEffectAmplifier(nbt.m_128451_("AppliedEffectAmplifier"));
        }
        if (nbt.m_128441_("AppliedEffectTicks")) {
            this.setAppliedEffectDuration(nbt.m_128451_("AppliedEffectTicks"));
        }
    }
}

