/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.soulsweaponry.registry.ParticleRegistry;
import org.slf4j.Logger;

public abstract class ModPersistentProjectile
extends AbstractArrow {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ItemStack stack;
    private int maxAge;
    private static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DESPAWN_PARTICLE_COUNT = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRAIL_PARTICLE_COUNT = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AREA_PARTICLE_COUNT = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DESPAWN_PARTICLE_EXPANSION = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ParticleOptions> DESPAWN_PARTICLE = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<ParticleOptions> TRAIL_PARTICLE = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<ParticleOptions> AREA_PARTICLE = SynchedEntityData.m_135353_(ModPersistentProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);

    public ModPersistentProjectile(EntityType<? extends AbstractArrow> type, LivingEntity owner, Level world) {
        super(type, owner, world);
        this.setBoundingBoxWidth(type.m_20680_().f_20377_);
        this.setBoundingBoxHeight(type.m_20680_().f_20378_);
    }

    public ModPersistentProjectile(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.setBoundingBoxWidth(entityType.m_20680_().f_20377_);
        this.setBoundingBoxHeight(entityType.m_20680_().f_20378_);
    }

    public ModPersistentProjectile(EntityType<? extends AbstractArrow> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.setBoundingBoxWidth(type.m_20680_().f_20377_);
        this.setBoundingBoxHeight(type.m_20680_().f_20378_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WIDTH, (Object)Float.valueOf(1.85f));
        this.f_19804_.m_135372_(HEIGHT, (Object)Float.valueOf(1.85f));
        this.f_19804_.m_135372_(DESPAWN_PARTICLE_COUNT, (Object)75);
        this.f_19804_.m_135372_(TRAIL_PARTICLE_COUNT, (Object)4);
        this.f_19804_.m_135372_(AREA_PARTICLE_COUNT, (Object)0);
        this.f_19804_.m_135372_(DESPAWN_PARTICLE_EXPANSION, (Object)Float.valueOf(0.125f));
        this.f_19804_.m_135372_(DESPAWN_PARTICLE, (Object)ParticleTypes.f_123745_);
        this.f_19804_.m_135372_(TRAIL_PARTICLE, (Object)ParticleTypes.f_175827_);
        this.f_19804_.m_135372_(AREA_PARTICLE, (Object)((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get()));
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (WIDTH.equals(data) || HEIGHT.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.getBoundingBoxWidth(), (float)this.getBoundingBoxHeight());
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Stack", 10)) {
            this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
        }
        if (nbt.m_128441_("BoundingBoxWidth")) {
            this.setBoundingBoxWidth(nbt.m_128457_("BoundingBoxWidth"));
        }
        if (nbt.m_128441_("BoundingBoxHeight")) {
            this.setBoundingBoxHeight(nbt.m_128457_("BoundingBoxHeight"));
        }
        if (nbt.m_128441_("MaxAge")) {
            this.maxAge = nbt.m_128451_("MaxAge");
        }
        if (nbt.m_128425_("AreaParticle", 8)) {
            try {
                this.setAreaParticle(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("AreaParticle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("AreaParticle"), (Object)var5);
            }
        }
        if (nbt.m_128425_("TrailParticle", 8)) {
            try {
                this.setTrailParticle(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("TrailParticle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("TrailParticle"), (Object)var5);
            }
        }
        if (nbt.m_128425_("DespawnParticle", 8)) {
            try {
                this.setDespawnParticle(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("DespawnParticle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("DespawnParticle"), (Object)var5);
            }
        }
        if (nbt.m_128441_("AreaParticleCount")) {
            this.setAreaParticleCount(nbt.m_128451_("AreaParticleCount"));
        }
        if (nbt.m_128441_("TrailParticleCount")) {
            this.setTrailParticleCount(nbt.m_128451_("TrailParticleCount"));
        }
        if (nbt.m_128441_("DespawnParticleCount")) {
            this.setDespawnParticleCount(nbt.m_128451_("DespawnParticleCount"));
        }
        if (nbt.m_128441_("DespawnParticleExpansion")) {
            this.setDespawnParticleExpansion(nbt.m_128457_("DespawnParticleExpansion"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.stack != null) {
            nbt.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        }
        nbt.m_128350_("BoundingBoxWidth", this.getBoundingBoxWidth());
        nbt.m_128350_("BoundingBoxHeight", this.getBoundingBoxHeight());
        nbt.m_128405_("MaxAge", this.maxAge);
        nbt.m_128359_("AreaParticle", this.getAreaParticle().m_5942_());
        nbt.m_128359_("TrailParticle", this.getTrailParticle().m_5942_());
        nbt.m_128359_("DespawnParticle", this.getDespawnParticle().m_5942_());
        nbt.m_128405_("AreaParticleCount", this.getAreaParticleCount());
        nbt.m_128405_("TrailParticleCount", this.getTrailParticleCount());
        nbt.m_128405_("DespawnParticleCount", this.getDespawnParticleCount());
        nbt.m_128350_("DespawnParticleExpansion", this.getDespawnParticleExpansion());
    }

    protected ItemStack m_7941_() {
        return this.stack;
    }

    public void setItemStack(ItemStack stackShotFrom) {
        this.stack = stackShotFrom;
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(WIDTH, (Object)Float.valueOf(radius));
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(radius));
    }

    public float getBoundingBoxWidth() {
        return ((Float)this.f_19804_.m_135370_(WIDTH)).floatValue();
    }

    public float getBoundingBoxHeight() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT)).floatValue();
    }

    public void setBoundingBoxWidth(float width) {
        this.f_19804_.m_135381_(WIDTH, (Object)Float.valueOf(width));
    }

    public void setBoundingBoxHeight(float height) {
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(height));
    }

    public float getRadius() {
        return Math.max(this.getBoundingBoxWidth(), this.getBoundingBoxHeight());
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getAreaParticleCount() {
        return (Integer)this.f_19804_.m_135370_(AREA_PARTICLE_COUNT);
    }

    public void setAreaParticleCount(int areaParticleCount) {
        this.f_19804_.m_135381_(AREA_PARTICLE_COUNT, (Object)areaParticleCount);
    }

    public ParticleOptions getAreaParticle() {
        return (ParticleOptions)this.f_19804_.m_135370_(AREA_PARTICLE);
    }

    public void setAreaParticle(ParticleOptions areaParticle) {
        this.f_19804_.m_135381_(AREA_PARTICLE, (Object)areaParticle);
    }

    public int getTrailParticleCount() {
        return (Integer)this.f_19804_.m_135370_(TRAIL_PARTICLE_COUNT);
    }

    public void setTrailParticleCount(int trailParticleCount) {
        this.f_19804_.m_135381_(TRAIL_PARTICLE_COUNT, (Object)trailParticleCount);
    }

    public ParticleOptions getTrailParticle() {
        return (ParticleOptions)this.f_19804_.m_135370_(TRAIL_PARTICLE);
    }

    public void setTrailParticle(ParticleOptions trailParticle) {
        this.f_19804_.m_135381_(TRAIL_PARTICLE, (Object)trailParticle);
    }

    public int getDespawnParticleCount() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_PARTICLE_COUNT);
    }

    public void setDespawnParticleCount(int despawnParticleCount) {
        this.f_19804_.m_135381_(DESPAWN_PARTICLE_COUNT, (Object)despawnParticleCount);
    }

    public ParticleOptions getDespawnParticle() {
        return (ParticleOptions)this.f_19804_.m_135370_(DESPAWN_PARTICLE);
    }

    public void setDespawnParticle(ParticleOptions despawnParticle) {
        this.f_19804_.m_135381_(DESPAWN_PARTICLE, (Object)despawnParticle);
    }

    public float getDespawnParticleExpansion() {
        return ((Float)this.f_19804_.m_135370_(DESPAWN_PARTICLE_EXPANSION)).floatValue();
    }

    public void setDespawnParticleExpansion(float despawnParticleExpansion) {
        this.f_19804_.m_135381_(DESPAWN_PARTICLE_EXPANSION, (Object)Float.valueOf(despawnParticleExpansion));
    }
}

