/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.NightProwlerGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightProwler
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int openPortalTicks;
    public int deathTicks;
    public int phaseTwoTicks;
    public int spawnTicks;
    public int phaseTwoMaxTransitionTicks = 120;
    public int maxSpawnTicks = 50;
    private int[] aliveSummons = new int[0];
    public static final int ATTACKS_LENGTH = Attacks.values().length;
    private static final EntityDataAccessor<Integer> ATTACKS = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> INITIATING_PHASE_2 = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PHASE_2 = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> PARTNER_UUID = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> REMAINING_ANI_TICKS = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> CHASE_TARGET = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAIT_ANIMATION = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPAWN_PARTICLES_STATE = SynchedEntityData.m_135353_(NightProwler.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public NightProwler(EntityType<? extends NightProwler> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.PURPLE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new NightProwlerGoal(this, 0.75, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.isPartner((LivingEntity)entity)));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void setAttackAnimation(Attacks attack) {
        for (int i = 0; i < ATTACKS_LENGTH; ++i) {
            if (!Attacks.values()[i].equals((Object)attack)) continue;
            this.f_19804_.m_135381_(ATTACKS, (Object)i);
        }
    }

    public Attacks getAttackAnimation() {
        return Attacks.values()[(Integer)this.f_19804_.m_135370_(ATTACKS)];
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(INITIATING_PHASE_2);
    }

    public void setInitiatePhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(INITIATING_PHASE_2, (Object)bl);
    }

    private PlayState attacks(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_phase_2", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.isSpawning()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn_1", Animation.LoopType.PLAY_ONCE));
        } else if (!this.isPhaseTwo()) {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("trinity_1", Animation.LoopType.LOOP));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().then("reaping_slash_1", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("nights_embrace_1", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("ripple_fang_1", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("blades_reach_1", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("soul_reaper_1", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("diminishing_light_1", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("darkness_rise_1", Animation.LoopType.LOOP));
                    break;
                }
                case 12: {
                    state.getController().setAnimation(RawAnimation.begin().then("engulf_1", Animation.LoopType.LOOP));
                    break;
                }
                case 13: {
                    state.getController().setAnimation(RawAnimation.begin().then("blackflame_snake_1", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("deaths_grasp_1", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_1", Animation.LoopType.LOOP));
                    break;
                }
            }
        } else {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("trinity_2", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("nights_embrace_2", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("ripple_fang_2", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("blades_reach_2", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("soul_reaper_2", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("diminishing_light_2", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("darkness_rise_2", Animation.LoopType.LOOP));
                    break;
                }
                case 11: {
                    state.getController().setAnimation(RawAnimation.begin().then("eclipse_2", Animation.LoopType.LOOP));
                    break;
                }
                case 12: {
                    state.getController().setAnimation(RawAnimation.begin().then("engulf_2", Animation.LoopType.LOOP));
                    break;
                }
                case 13: {
                    state.getController().setAnimation(RawAnimation.begin().then("blackflame_snake_2", Animation.LoopType.LOOP));
                    break;
                }
                case 14: {
                    state.getController().setAnimation(RawAnimation.begin().then("lunar_displacement_2", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("deaths_grasp_2", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_2", Animation.LoopType.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState idle(AnimationState<?> state) {
        if (this.m_21224_() || this.getAttackAnimation().equals((Object)Attacks.DEATH) || this.getDeathTicks() > 0) {
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("death_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("death_1", Animation.LoopType.LOOP));
            }
        } else {
            if (this.isInitiatingPhaseTwo()) {
                return PlayState.STOP;
            }
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("wings_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("wings_1", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState cape(AnimationState<?> state) {
        if (!this.isInitiatingPhaseTwo() && this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("cape_2", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState flying(AnimationState<?> state) {
        if (!this.isFlying()) {
            return PlayState.STOP;
        }
        if (this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("flying_2", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("flying_1", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKS, (Object)0);
        this.f_19804_.m_135372_(INITIATING_PHASE_2, (Object)false);
        this.f_19804_.m_135372_(IS_PHASE_2, (Object)false);
        this.f_19804_.m_135372_(PARTNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(REMAINING_ANI_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(CHASE_TARGET, (Object)true);
        this.f_19804_.m_135372_(WAIT_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(SPAWN_PARTICLES_STATE, (Object)0);
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks == this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123745_});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public DayStalker getPartner(ServerLevel world) {
        return (DayStalker)world.m_8791_(this.getPartnerUuid());
    }

    public UUID getPartnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(PARTNER_UUID)).orElse(null);
    }

    public void setPartnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(PARTNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean isPartner(LivingEntity living) {
        return this.getPartnerUuid() != null && living.m_20148_() != null && this.getPartnerUuid().equals(living.m_20148_());
    }

    public int[] getAliveSummonsList() {
        return this.aliveSummons;
    }

    public void setAliveSummons(int[] aliveSummonsList) {
        this.aliveSummons = aliveSummonsList;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getPartnerUuid() != null) {
            nbt.m_128362_("partner_uuid", this.getPartnerUuid());
        }
        nbt.m_128379_("phase_two", this.isPhaseTwo());
        nbt.m_128405_("remaining_ani_ticks", this.getRemainingAniTicks());
        nbt.m_128379_("is_flying", this.isFlying());
        nbt.m_128379_("chase_target", this.shouldChaseTarget());
        nbt.m_128385_("summons", this.getAliveSummonsList());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        UUID uUID = null;
        if (nbt.m_128403_("partner_uuid")) {
            uUID = nbt.m_128342_("partner_uuid");
        }
        if (uUID != null) {
            try {
                this.setPartnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.m_128441_("phase_two")) {
            this.setPhaseTwo(nbt.m_128471_("phase_two"));
        }
        if (nbt.m_128441_("remaining_ani_ticks")) {
            this.setRemainingAniTicks(nbt.m_128451_("remaining_ani_ticks"));
        }
        if (nbt.m_128441_("is_flying")) {
            this.setFlying(nbt.m_128471_("is_flying"));
        }
        if (nbt.m_128441_("chase_target")) {
            this.setChaseTarget(nbt.m_128471_("chase_target"));
        }
        if (nbt.m_128441_("summons")) {
            this.setAliveSummons(nbt.m_128465_("summons"));
        }
    }

    public boolean isEmpowered() {
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46462_() || this.isPhaseTwo();
    }

    protected SoundEvent m_5592_() {
        return this.isPhaseTwo() ? (SoundEvent)SoundRegistry.HARD_BOSS_DEATH_LONG.get() : (SoundEvent)SoundRegistry.HARD_BOSS_DEATH_SHORT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12231_;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.isPhaseTwo() ? 140 : 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(Attacks.DEATH);
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.night_prowler_is_fire_immune;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.night_prowler_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.night_prowler_group_type;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.night_prowler_disables_shields;
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 120.0).m_22268_(Attributes.f_22276_, ConfigConstructor.night_prowler_health).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, ConfigConstructor.night_prowler_armor).m_22268_(Attributes.f_22280_, 0.8);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flying", 0, this::flying)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cape", 0, this::cape)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.night_prowler_xp;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().f_46443_) {
            DayStalker partner = this.getPartner((ServerLevel)this.m_9236_());
            if (!this.isPhaseTwo() && (partner == null || partner.m_21224_())) {
                this.m_21219_();
                this.setInitiatePhaseTwo(true);
                this.setFlying(false);
            }
        }
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTwoTicks;
            this.setFlying(false);
            int maxHealTicks = this.phaseTwoMaxTransitionTicks - 40;
            float healPerTick = this.m_21233_() / (float)maxHealTicks;
            this.m_5634_(healPerTick);
            if (this.phaseTwoTicks == 78) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.PARTNER_DIES.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.phaseTwoTicks == 81) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                if (!this.m_9236_().f_46443_) {
                    ParticleHandler.particleSphereList(this.m_9236_(), 1000, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123745_, ParticleTypes.f_123755_});
                }
                NightProwlerGoal placeHolder = new NightProwlerGoal(this, 1.0, true);
                placeHolder.aoe(this.m_20191_().m_82400_(4.0), 50.0f, 4.0f, true);
            }
            if (this.phaseTwoTicks >= this.phaseTwoMaxTransitionTicks) {
                this.setPhaseTwo(true);
                this.setInitiatePhaseTwo(false);
            }
        }
        if (this.isSpawning()) {
            ++this.spawnTicks;
            if (this.spawnTicks >= this.maxSpawnTicks) {
                this.setAttackAnimation(Attacks.IDLE);
            }
        }
        this.setRemainingAniTicks(Math.max(this.getRemainingAniTicks() - 1, 0));
        if (this.getRemainingAniTicks() <= 0 && this.shouldWaitAnimation()) {
            this.setWaitAnimation(false);
            this.setAttackAnimation(Attacks.IDLE);
            this.m_21573_().m_26573_();
        }
    }

    @Override
    public boolean isSpawning() {
        return this.getAttackAnimation().equals((Object)Attacks.SPAWN);
    }

    @Override
    public SoundEvent getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.isEmpowered() && this.getAttackAnimation().equals((Object)Attacks.IDLE) && !this.isFlying()) {
            double z;
            double y;
            double x;
            LivingEntity attacker;
            Entity entity;
            double d = this.f_19796_.m_188500_();
            float f = source.m_269533_(DamageTypeTags.f_268524_) ? 1.5f : 1.0f;
            if (d < ConfigConstructor.night_prowler_teleport_chance * (double)f && (entity = source.m_7639_()) instanceof LivingEntity && (this.m_20280_((Entity)(attacker = (LivingEntity)entity)) > 250.0 ? this.teleportTo(x = attacker.m_20185_() + (double)this.f_19796_.m_188503_(12) - 6.0, y = attacker.m_20186_(), z = attacker.m_20189_() + (double)this.f_19796_.m_188503_(12) - 6.0) : this.teleportAway())) {
                return false;
            }
        }
        if (this.isEmpowered() && source.m_269533_(DamageTypeTags.f_268524_) && !this.isProjectileWhitelisted(source) && (double)this.m_21223_() < (double)this.m_21233_() * ConfigConstructor.night_prowler_projectile_heal_below_percent_health) {
            this.m_5496_(SoundEvents.f_11739_, 1.0f, 1.0f);
            this.m_5634_(ConfigConstructor.night_prowler_projectile_heal_amount);
            return false;
        }
        if (this.getAttackAnimation().equals((Object)Attacks.ECLIPSE)) {
            amount *= 0.75f;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            amount *= 0.25f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean teleportTo(double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        while (mutable.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutable).m_280555_()) {
            mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutable);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!bl || bl2) {
            return false;
        }
        Vec3 vec3d = this.m_20182_();
        boolean bl3 = this.m_20984_(x, y, z, true);
        if (bl3) {
            this.m_9236_().m_214171_(GameEvent.f_238175_, vec3d, GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    public boolean teleportAway() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double d = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * 32.0;
        double e = this.m_20186_() + (double)(this.m_217043_().m_188503_(16) - 4);
        double f = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * 32.0;
        return this.teleportTo(d, e, f);
    }

    public void setRemainingAniTicks(int ticks) {
        this.f_19804_.m_135381_(REMAINING_ANI_TICKS, (Object)ticks);
    }

    public int getRemainingAniTicks() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANI_TICKS);
    }

    public void setPhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(IS_PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(IS_PHASE_2);
    }

    public void setFlying(boolean bl) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)bl);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setTargetPos(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(TARGET_POS);
    }

    public void setChaseTarget(boolean bl) {
        this.f_19804_.m_135381_(CHASE_TARGET, (Object)bl);
    }

    public boolean shouldChaseTarget() {
        return (Boolean)this.f_19804_.m_135370_(CHASE_TARGET);
    }

    public void setWaitAnimation(boolean bl) {
        this.f_19804_.m_135381_(WAIT_ANIMATION, (Object)bl);
    }

    public boolean shouldWaitAnimation() {
        return (Boolean)this.f_19804_.m_135370_(WAIT_ANIMATION);
    }

    public void setParticleState(int type) {
        this.f_19804_.m_135381_(SPAWN_PARTICLES_STATE, (Object)type);
    }

    public int getParticleState() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_PARTICLES_STATE);
    }

    public int getOpenPortalTicks() {
        return this.openPortalTicks;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            int i;
            if ((double)this.m_21223_() < (double)this.m_21233_() * ConfigConstructor.night_prowler_projectile_heal_below_percent_health) {
                for (i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.DAZZLING_PARTICLE.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
            }
            switch (this.getParticleState()) {
                case 1: {
                    if (this.getTargetPos() == null) break;
                    for (i = 0; i < 500; ++i) {
                        RandomSource random = this.m_217043_();
                        Vec3 pos = this.getTargetPos().m_252807_();
                        double d = random.m_188583_() * 0.05;
                        double e = random.m_188583_() * 0.05;
                        double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
                        double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
                        double newY = (random.m_188500_() - 0.5 + random.m_188500_() * 0.5) / 2.0;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                    }
                    break;
                }
                case 2: {
                    if (this.getTargetPos() == null) break;
                    for (i = 0; i < 250; ++i) {
                        RandomSource random = this.m_217043_();
                        Vec3 pos = this.getTargetPos().m_252807_();
                        double d = random.m_188583_() * 0.05;
                        double e = random.m_188583_() * 0.05;
                        double newX = (random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d) / 2.0;
                        double newZ = (random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e) / 2.0;
                        double newY = (random.m_188500_() - 0.5 + random.m_188500_() * 0.5) / 4.0;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.DARK_STAR.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), newX, newY, newZ);
                    }
                    break;
                }
                case 3: {
                    for (int t = -90; t < 90; ++t) {
                        double rad = Math.toRadians(t);
                        int out = 4;
                        float yaw = (float)Math.toRadians(this.m_146908_() + 90.0f);
                        double x1 = (double)out * Math.cos(rad);
                        double y1 = (double)out * Math.sin(rad);
                        double z1 = (double)out * Math.sin(rad);
                        Vec3 vec1 = new Vec3(x1, y1, z1).m_82524_(-yaw).m_82549_(this.m_146892_().m_82520_(0.0, -1.0, 0.0));
                        double x2 = (double)out * Math.cos(rad);
                        double y2 = (double)out * Math.sin(rad);
                        double z2 = (double)(-out) * Math.sin(rad);
                        Vec3 vec2 = new Vec3(x2, y2, z2).m_82524_(-yaw).m_82549_(this.m_146892_().m_82520_(0.0, -1.0, 0.0));
                        int div = 75;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.DARK_STAR.get(), vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, this.f_19796_.m_188583_() / (double)div, this.f_19796_.m_188583_() / (double)div, this.f_19796_.m_188583_() / (double)div);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.DAZZLING_PARTICLE.get(), vec2.f_82479_, vec2.f_82480_, vec2.f_82481_, this.f_19796_.m_188583_() / (double)div, this.f_19796_.m_188583_() / (double)div, this.f_19796_.m_188583_() / (double)div);
                    }
                    break;
                }
                case 4: {
                    float radius;
                    ++this.openPortalTicks;
                    float f = radius = this.getOpenPortalTicks() >= 30 && this.getOpenPortalTicks() <= 190 ? 16.0f : 0.0f;
                    if (radius == 0.0f || this.f_19797_ % 8 != 0) break;
                    for (int i2 = 0; i2 < 360; ++i2) {
                        float offsetX = (float)((double)radius * Math.cos(i2));
                        float offsetZ = (float)((double)radius * Math.sin(i2));
                        double particleX = this.m_20185_() + (double)offsetX;
                        double particleY = this.m_20186_() + 8.0;
                        double particleZ = this.m_20189_() + (double)offsetZ;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                default: {
                    this.openPortalTicks = 0;
                }
            }
        }
    }

    public boolean m_20068_() {
        return this.isFlying();
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        if (!this.isFlying()) {
            super.m_7840_(heightDifference, onGround, state, landedPosition);
        }
    }

    public boolean m_6147_() {
        return !this.isFlying() && super.m_6147_();
    }

    protected boolean m_6125_() {
        return this.isPhaseTwo();
    }

    @Override
    public String[] getWhitelistedProjectiles() {
        return ConfigConstructor.night_prowler_projectile_immunity_whitelist;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.night_prowler_status_effect_blacklist;
    }

    public static enum Attacks {
        IDLE,
        DEATH,
        SPAWN,
        TRINITY,
        REAPING_SLASH,
        NIGHTS_EMBRACE,
        RIPPLE_FANG,
        BLADES_REACH,
        SOUL_REAPER,
        DIMINISHING_LIGHT,
        DARKNESS_RISE,
        ECLIPSE,
        ENGULF,
        BLACKFLAME_SNAKE,
        LUNAR_DISPLACEMENT,
        DEATHBRINGERS_GRASP;

    }
}

