/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.MoonknightGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.StopBossMusicS2C;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Moonknight
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private int phaseTransitionTicks;
    private final int phaseTransitionMaxTicks = 120;
    private int blockBreakingCooldown;
    private final List<EntityType<?>> absorbedProjectileTypes = new ArrayList();
    private final List<Float> absorbedProjectileDamage = new ArrayList<Float>();
    public float prevBeamHeight;
    public float renderBeamHeight;
    private static final EntityDataAccessor<Boolean> SPAWNING = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INITIATE_PHASE_2 = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PHASE_2 = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BEAM = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SWORD_CHARGING = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> BEAM_LOCATION = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> BEAM_HEIGHT = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> INITIATED_PHASE_2 = SynchedEntityData.m_135353_(Moonknight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Moonknight(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.WHITE);
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22276_, ConfigConstructor.fallen_icon_health).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, ConfigConstructor.fallen_icon_armor);
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return fallDistance > 6.0f ? super.m_5639_(fallDistance, damageMultiplier) : 0;
    }

    public void setSpawning(boolean bl) {
        this.f_19804_.m_135381_(SPAWNING, (Object)bl);
    }

    @Override
    public boolean isSpawning() {
        return (Boolean)this.f_19804_.m_135370_(SPAWNING);
    }

    public void initiatePhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(INITIATE_PHASE_2, (Object)bl);
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(INITIATE_PHASE_2);
    }

    public void setPhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(PHASE_2);
    }

    public void setCanBeam(boolean bl) {
        this.f_19804_.m_135381_(CAN_BEAM, (Object)bl);
    }

    public boolean getCanBeam() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BEAM);
    }

    public void setBeamLocation(BlockPos pos) {
        this.f_19804_.m_135381_(BEAM_LOCATION, (Object)pos);
    }

    public BlockPos getBeamLocation() {
        return (BlockPos)this.f_19804_.m_135370_(BEAM_LOCATION);
    }

    public void setBeamHeight(float fl) {
        this.f_19804_.m_135381_(BEAM_HEIGHT, (Object)Float.valueOf(fl));
    }

    public float getBeamHeight() {
        return ((Float)this.f_19804_.m_135370_(BEAM_HEIGHT)).floatValue();
    }

    public void setChargingSword(boolean bl) {
        this.f_19804_.m_135381_(IS_SWORD_CHARGING, (Object)bl);
    }

    public boolean isSwordCharging() {
        return (Boolean)this.f_19804_.m_135370_(IS_SWORD_CHARGING);
    }

    public void setInitiatedPhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(INITIATED_PHASE_2, (Object)bl);
    }

    public boolean initiatedPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(INITIATED_PHASE_2);
    }

    public List<EntityType<?>> getAbsorbedProjectileTypes() {
        return this.absorbedProjectileTypes;
    }

    public List<Float> getAbsorbedProjectileDamage() {
        return this.absorbedProjectileDamage;
    }

    public void clearAbsorbedProjectiles() {
        this.absorbedProjectileTypes.clear();
        this.absorbedProjectileDamage.clear();
    }

    public void setPhaseOneAttack(MoonknightPhaseOne phaseOneAttack) {
        for (int i = 0; i < MoonknightPhaseOne.values().length; ++i) {
            if (!MoonknightPhaseOne.values()[i].equals((Object)phaseOneAttack)) continue;
            this.f_19804_.m_135381_(ATTACK, (Object)i);
            return;
        }
    }

    public MoonknightPhaseOne getPhaseOneAttack() {
        return MoonknightPhaseOne.values()[(Integer)this.f_19804_.m_135370_(ATTACK)];
    }

    public void setPhaseTwoAttack(MoonknightPhaseTwo phaseTwoAttack) {
        for (int i = 0; i < MoonknightPhaseTwo.values().length; ++i) {
            if (!MoonknightPhaseTwo.values()[i].equals((Object)phaseTwoAttack)) continue;
            this.f_19804_.m_135381_(ATTACK, (Object)i);
            return;
        }
    }

    public MoonknightPhaseTwo getPhaseTwoAttack() {
        return MoonknightPhaseTwo.values()[(Integer)this.f_19804_.m_135370_(ATTACK)];
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Projectile projectile;
        if (this.blockBreakingCooldown <= 0) {
            this.blockBreakingCooldown = 20;
        }
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (!this.isPhaseTwo() && this.m_21223_() - amount < 1.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                ModMessages.sendToAllPlayers(new StopBossMusicS2C(this.getBossMusic().m_11660_()));
                this.setPlayingMusic(false);
            }
            this.m_21219_();
            this.initiatePhaseTwo(true);
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_DEATH_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof Projectile && !this.isProjectileWhitelisted((Entity)(projectile = (Projectile)entity)) && entity.m_20183_() != null) {
            ParticleHandler.particleSphereList(this.m_9236_(), 10, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            if (projectile.m_19749_() != null && projectile.m_19749_().equals((Object)this)) {
                projectile.m_146870_();
                return false;
            }
            for (int i = 0; i < 3; ++i) {
                this.absorbedProjectileTypes.add(projectile.m_6095_());
                this.absorbedProjectileDamage.add(Float.valueOf(amount));
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public String[] getWhitelistedProjectiles() {
        return ConfigConstructor.fallen_icon_projectile_immunity_whitelist;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.fallen_icon_status_effect_blacklist;
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.fallen_icon_xp;
    }

    @Override
    public void m_8119_() {
        this.prevBeamHeight = this.getBeamHeight();
        super.m_8119_();
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTransitionTicks;
            this.tryToPlayBossMusic();
            if (this.phaseTransitionTicks >= 40) {
                int maxHealTicks = this.phaseTransitionMaxTicks - 40;
                float healPerTick = this.m_21233_() / (float)maxHealTicks;
                this.m_5634_(healPerTick);
                if (this.phaseTransitionTicks <= 92 && !this.m_9236_().f_46443_) {
                    ParticleHandler.particleOutburstMap(this.m_9236_(), 30, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
            if (this.phaseTransitionTicks == 89) {
                CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{(ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), ParticleTypes.f_123745_, ParticleTypes.f_123755_});
            }
            if (this.phaseTransitionTicks == 96) {
                this.setInitiatedPhaseTwo(true);
            }
            if (this.phaseTransitionTicks >= this.phaseTransitionMaxTicks) {
                this.setPhaseTwo(true);
                this.initiatePhaseTwo(false);
                this.setPhaseTwoAttack(MoonknightPhaseTwo.IDLE);
                this.m_6593_((Component)Component.m_237115_((String)"entity.soulsweapons.moonknight_phase_2"));
                this.bossBar.m_6451_(BossEvent.BossBarColor.BLUE);
            }
        }
        if (ConfigConstructor.can_bosses_break_blocks && this.blockBreakingCooldown > 0) {
            --this.blockBreakingCooldown;
            if (this.blockBreakingCooldown == 0 && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                int i = Mth.m_14107_((double)this.m_20186_());
                int j = Mth.m_14107_((double)this.m_20185_());
                int k = Mth.m_14107_((double)this.m_20189_());
                for (int l = -3; l <= 3; ++l) {
                    for (int m = -3; m <= 3; ++m) {
                        for (int n = 0; n <= 8; ++n) {
                            if (this.m_9236_().m_8055_(new BlockPos(j + l, i + n, k + m)).m_60734_() instanceof BaseEntityBlock) continue;
                            this.m_9236_().m_46961_(new BlockPos(j + l, i + n, k + m), true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundRegistry.FALLEN_ICON_SONG.get();
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            this.summonParticles();
            if (this.spawnTicks % 10 == 0) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.spawnTicks >= 80) {
                this.setSpawning(false);
                this.setPhaseOneAttack(MoonknightPhaseOne.IDLE);
            }
        }
        if (this.m_9236_().f_46443_ && !this.m_21224_() && this.isPhaseTwo() && this.getPhaseTwoAttack().equals((Object)MoonknightPhaseTwo.CORE_BEAM) && this.getCanBeam() && !this.isPosNullish(this.getBeamLocation())) {
            Vec3 start = this.m_20182_().m_82520_(0.0, 6.0, 0.0);
            Vec3 end = this.getBeamLocation().m_252807_().m_82520_(0.0, (double)this.renderBeamHeight, 0.0);
            Vec3 between = new Vec3(end.m_7096_() - start.m_7096_(), end.m_7098_() - start.m_7098_(), end.m_7094_() - start.m_7094_());
            int numberOfParticles = 20;
            double stepSize = 1.0 / (double)numberOfParticles;
            for (double progress = 0.0; progress < 1.0; progress += stepSize) {
                Vec3 particlePos = start.m_82549_(between.m_82490_(progress));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), this.f_19796_.m_188500_() - (double)0.05f, this.f_19796_.m_188500_() - (double)0.05f, this.f_19796_.m_188500_() - (double)0.05f);
            }
            double d = this.f_19796_.m_188583_() * 0.05;
            double q = this.f_19796_.m_188583_() * 0.05;
            for (int i = 0; i < 2; ++i) {
                double newX = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + d;
                double newZ = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188583_() * 0.15 + q;
                double newY = this.f_19796_.m_188500_() - 0.5 + this.f_19796_.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20185_(), this.m_20186_() + 5.5, this.m_20189_(), newX * 25.0, newY * 18.0, newZ * 25.0);
            }
        }
        if (this.isPhaseTwo() && !this.m_21224_() && this.isSwordCharging() && this.getPhaseTwoAttack().equals((Object)MoonknightPhaseTwo.IDLE)) {
            this.setChargingSword(false);
        }
    }

    private boolean isPosNullish(BlockPos pos) {
        return pos.m_123341_() == 0 && pos.m_123342_() == 0 && pos.m_123343_() == 0;
    }

    private void summonParticles() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 50; ++i) {
                RandomSource random = this.m_217043_();
                double d = random.m_188583_() * 0.05;
                double e = random.m_188583_() * 0.05;
                double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
                double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
                double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_(), this.m_20189_(), newX / 2.0, newY / 2.0, newZ / 2.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), newX / 2.0, newY / 2.0, newZ / 2.0);
            }
        }
    }

    @Override
    public int getTicksUntilDeath() {
        return 100;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks == 40 && this.m_20183_() != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.KNIGHT_DEATH_LAUGH_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{(ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), ParticleTypes.f_123745_, ParticleTypes.f_123755_});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.fallen_icon_is_fire_immune;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.fallen_icon_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.fallen_icon_group_type;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.fallen_icon_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 0, this::mainAnimations);
        AnimationController cape = new AnimationController((GeoAnimatable)this, "cape", 0, this::cape);
        AnimationController phase = new AnimationController((GeoAnimatable)this, "phase", 0, this::phase);
        AnimationController heart = new AnimationController((GeoAnimatable)this, "heart", 0, this::heart);
        controllers.add(new AnimationController[]{main});
        controllers.add(new AnimationController[]{cape});
        controllers.add(new AnimationController[]{phase});
        controllers.add(new AnimationController[]{heart});
        main.setParticleKeyframeHandler(this::particleListener);
    }

    private void particleListener(ParticleKeyframeEvent<Moonknight> moonknightParticleKeyframeEvent) {
        this.setChargingSword(!this.isSwordCharging());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MoonknightGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.DEATH_SCREAMS_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.KNIGHT_HIT_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.KNIGHT_DEATH_EVENT.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWNING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(PHASE_2, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(INITIATE_PHASE_2, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CAN_BEAM, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_SWORD_CHARGING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ATTACK, (Object)0);
        this.f_19804_.m_135372_(BEAM_LOCATION, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(BEAM_HEIGHT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(INITIATED_PHASE_2, (Object)false);
    }

    private PlayState heart(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().thenPlay("idle_heart"));
        return PlayState.CONTINUE;
    }

    private PlayState phase(AnimationState<?> state) {
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        } else if (this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("phase_2"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("phase_1"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState cape(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().thenPlay("idle_cape"));
        return PlayState.CONTINUE;
    }

    private PlayState mainAnimations(AnimationState<?> state) {
        if (this.m_21224_()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("death_phase_2"));
        } else if (this.isSpawning()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("spawn_phase_1"));
        } else if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("initiate_phase_2"));
        } else if (this.isPhaseTwo()) {
            switch (this.getPhaseTwoAttack().ordinal()) {
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("blinding_light"));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("core_beam_phase_2"));
                    break;
                }
                case 0: {
                    if (this.m_5912_()) {
                        state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
                        break;
                    }
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                    break;
                }
                case 2: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("obliterate_phase_2"));
                    break;
                }
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("moon_explosion_phase_2"));
                    break;
                }
                case 1: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("sword_of_light_phase_2"));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("thrust_phase_2"));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("rupture_phase_2"));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("heavy_swing_phase_2"));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("unbreakable"));
                }
            }
        } else {
            switch (this.getPhaseOneAttack().ordinal()) {
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("blinding_light"));
                    break;
                }
                case 0: {
                    if (this.m_5912_()) {
                        state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
                        break;
                    }
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
                    break;
                }
                case 1: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("mace_of_spades_phase_1"));
                    break;
                }
                case 2: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("obliterate_phase_1"));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("rupture_phase_1"));
                    break;
                }
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("summon_warriors_phase_1"));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().thenPlay("unbreakable"));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public static enum MoonknightPhaseOne {
        IDLE,
        MACE_OF_SPADES,
        OBLITERATE,
        SUMMON,
        RUPTURE,
        BLINDING_LIGHT,
        UNBREAKABLE;

    }

    public static enum MoonknightPhaseTwo {
        IDLE,
        SWORD_OF_LIGHT,
        MOONFALL,
        MOONVEIL,
        THRUST,
        BLINDING_LIGHT,
        CORE_BEAM,
        RUPTURE,
        HEAVY_SWING,
        UNBREAKABLE;

    }
}

