/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.items.axe.LeviathanAxe;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IAnimatedDeath;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FrostGiant
extends Remnant
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private static final EntityDataAccessor<Boolean> SMASH = SynchedEntityData.m_135353_(FrostGiant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FrostGiant(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.m_7105_(false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FrostGiantGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.m_21824_() || !(this.m_269323_() instanceof Player)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> this.m_21824_() && entity instanceof Enemy && !(entity instanceof Creeper) && !this.m_7307_((Entity)entity)));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
        } else if (this.isSmashing()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("attack"));
        } else if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
        } else if (this.m_21827_()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("sitting_idle"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        float x = amount;
        if (source.m_276093_(DamageTypes.f_268444_)) {
            return false;
        }
        if (this.isFireDamage(source)) {
            x *= 2.0f;
        }
        return super.m_6469_(source, x);
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        LeviathanAxe.iceExplosion(this.m_9236_(), this.m_20183_(), null, 1);
        super.m_6667_(damageSource);
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            if (!this.m_9236_().f_46443_) {
                ParticleHandler.particleSphere(this.m_9236_(), 600, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), ParticleEvents.ICE_PARTICLE, 1.0f);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 0.5f);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public int getTicksUntilDeath() {
        return 30;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
    }

    private boolean isFireDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268684_);
    }

    public boolean isSmashing() {
        return (Boolean)this.f_19804_.m_135370_(SMASH);
    }

    public void setSmash(boolean bl) {
        this.f_19804_.m_135381_(SMASH, (Object)bl);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SMASH, (Object)false);
        super.m_8097_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder createGiantAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, ConfigConstructor.frost_giant_health).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22278_, 3.0).m_22268_(Attributes.f_22284_, ConfigConstructor.frost_giant_armor).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21023_((MobEffect)EffectRegistry.FREEZING.get())) {
            this.m_21195_((MobEffect)EffectRegistry.FREEZING.get());
        }
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity source) {
        if (effect.m_19544_().equals(EffectRegistry.FREEZING.get())) {
            return false;
        }
        return super.m_147207_(effect, source);
    }

    @Override
    public int getSoulAmount() {
        return 5;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12043_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11817_;
    }

    @Override
    public void initEquip() {
    }

    static class FrostGiantGoal
    extends MeleeAttackGoal {
        private final FrostGiant mob;
        private int attackStatus;

        public FrostGiantGoal(FrostGiant mob) {
            super((PathfinderMob)mob, 1.0, false);
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.m_21824_() && this.mob.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.mob.m_21824_() && this.mob.m_21827_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8041_() {
            this.mob.setSmash(false);
            this.attackStatus = 0;
            super.m_8041_();
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                double d;
                double distanceToEntity = this.mob.m_20280_((Entity)target);
                if (distanceToEntity <= (d = this.m_6639_(target)) && this.m_25565_() <= 0 && !this.mob.isSmashing()) {
                    this.mob.setSmash(true);
                }
                if (this.mob.isSmashing()) {
                    ++this.attackStatus;
                    this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 2, 20));
                    if (this.attackStatus == 32) {
                        for (Entity entity : this.mob.m_9236_().m_45933_((Entity)this.mob, this.mob.m_20191_().m_82400_(3.5))) {
                            LivingEntity living;
                            if (!(entity instanceof LivingEntity) || this.isOwner(living = (LivingEntity)entity) || !this.mob.m_7327_((Entity)living)) continue;
                            living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 60, 0));
                        }
                        if (!this.mob.m_9236_().f_46443_) {
                            ParticleHandler.particleOutburstMap(this.mob.m_9236_(), 150, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), ParticleEvents.ICE_SMASH_MAP, 1.0f);
                        }
                        this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 0.5f);
                        this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                    if (this.attackStatus >= 51) {
                        this.mob.setSmash(false);
                        this.attackStatus = 0;
                        this.m_25563_();
                    }
                }
            }
        }

        private boolean isOwner(LivingEntity entity) {
            return this.mob.m_269323_() != null && this.mob.m_21830_(entity);
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
        }
    }
}

