/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DraugrBossGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.entity.projectile.ReturningProjectile;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DraugrBoss
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private boolean shouldDisableShield = false;
    private String weaponDamagedById = "none";
    private static final String LAST_WEAPON_DAMAGED_BY = "last_weapon_damaged_by";
    private int projectileCount;
    private static final EntityDataAccessor<Boolean> IS_SHIELDING = SynchedEntityData.m_135353_(DraugrBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> POSTURE_BROKEN = SynchedEntityData.m_135353_(DraugrBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> STATES = SynchedEntityData.m_135353_(DraugrBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> POS = SynchedEntityData.m_135353_(DraugrBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> SAME_WEAPON_COUNT = SynchedEntityData.m_135353_(DraugrBoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DraugrBoss(EntityType<? extends DraugrBoss> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.WHITE);
    }

    private PlayState attackAnimations(AnimationState<?> event) {
        if (this.isPostureBroken()) {
            event.getController().setAnimation(RawAnimation.begin().then("posture_break", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            switch (this.getState().ordinal()) {
                case 0: {
                    if (this.isShielding()) {
                        if (event.isMoving()) {
                            event.getController().setAnimation(RawAnimation.begin().then("block_stance", Animation.LoopType.LOOP));
                            break;
                        }
                        event.getController().setAnimation(RawAnimation.begin().then("idle_block", Animation.LoopType.LOOP));
                        break;
                    }
                    if (event.isMoving()) {
                        event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        break;
                    }
                    event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                    break;
                }
                case 1: {
                    event.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(RawAnimation.begin().then("counter", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(RawAnimation.begin().then("shield_bash", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 5: {
                    event.getController().setAnimation(RawAnimation.begin().then("shield_vault", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 6: {
                    event.getController().setAnimation(RawAnimation.begin().then("swipes", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 7: {
                    event.getController().setAnimation(RawAnimation.begin().then("backstep_block", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 8: {
                    event.getController().setAnimation(RawAnimation.begin().then("charged_attack", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 9: {
                    event.getController().setAnimation(RawAnimation.begin().then("ground_slam", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 10: {
                    event.getController().setAnimation(RawAnimation.begin().then("parry", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 11: {
                    event.getController().setAnimation(RawAnimation.begin().then("battle_cry", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 12: {
                    event.getController().setAnimation(RawAnimation.begin().then("sword_leap", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 13: {
                    event.getController().setAnimation(RawAnimation.begin().then("thrust_run", Animation.LoopType.HOLD_ON_LAST_FRAME));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22276_, ConfigConstructor.old_champions_remains_health).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, ConfigConstructor.old_champions_remains_armor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SHIELDING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(POSTURE_BROKEN, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(STATES, (Object)0);
        this.f_19804_.m_135372_(SAME_WEAPON_COUNT, (Object)0);
        this.f_19804_.m_135372_(POS, (Object)new BlockPos(0, 0, 0));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DraugrBossGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    public void setShielding(boolean bl) {
        this.f_19804_.m_135381_(IS_SHIELDING, (Object)bl);
    }

    public boolean isShielding() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHIELDING);
    }

    public void setPostureBroken(boolean bl) {
        this.f_19804_.m_135381_(POSTURE_BROKEN, (Object)bl);
    }

    public boolean isPostureBroken() {
        return (Boolean)this.f_19804_.m_135370_(POSTURE_BROKEN);
    }

    private void setSameWeaponCount(int amount) {
        this.f_19804_.m_135381_(SAME_WEAPON_COUNT, (Object)amount);
    }

    private void addSameWeaponCount() {
        this.setSameWeaponCount(this.getSameWeaponCount() + 1);
    }

    private int getSameWeaponCount() {
        return (Integer)this.f_19804_.m_135370_(SAME_WEAPON_COUNT);
    }

    public void setTargetPos(BlockPos pos) {
        this.f_19804_.m_135381_(POS, (Object)pos);
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(POS);
    }

    public void setState(States attack) {
        for (int i = 0; i < States.values().length; ++i) {
            if (!States.values()[i].equals((Object)attack)) continue;
            this.f_19804_.m_135381_(STATES, (Object)i);
        }
    }

    public States getState() {
        return States.values()[(Integer)this.f_19804_.m_135370_(STATES)];
    }

    public void setSpawning() {
        this.setState(States.SPAWN);
    }

    @Override
    public boolean isSpawning() {
        return this.getState().equals((Object)States.SPAWN);
    }

    public void m_8107_() {
        int i;
        super.m_8107_();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 50));
            for (i = 0; i < 30; ++i) {
                RandomSource random = this.m_217043_();
                BlockPos pos = this.m_20183_();
                double d = random.m_188583_() * 0.05;
                double e = random.m_188583_() * 0.05;
                double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
                double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
                double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 8.0, newZ / 2.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), newX / 2.0, newY / 8.0, newZ / 2.0);
            }
            if (this.spawnTicks % 10 == 0 && this.spawnTicks < 40) {
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.spawnTicks == 48 || this.spawnTicks == 55) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.SWORD_HIT_SHIELD_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(10.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                }
            }
            if (this.spawnTicks >= 70) {
                this.setState(States.IDLE);
            }
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 10, 1));
            for (i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else if (this.m_9236_().m_45527_(this.m_20183_())) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 10, 1));
            for (i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.isShielding()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 1));
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Object item;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            item = attacker.m_21205_().m_41778_();
            if (Objects.equals(this.weaponDamagedById, item)) {
                this.addSameWeaponCount();
            } else {
                this.setSameWeaponCount(0);
            }
            if ((float)this.getSameWeaponCount() >= ConfigConstructor.old_champions_remains_hits_before_growing_resistant) {
                double x = this.getSameWeaponCount() - (ConfigConstructor.old_champions_remains_hits_before_growing_resistant - (float)this.getSameWeaponCount() > 0.0f ? 1 : 0);
                amount = (float)((double)amount * Math.pow(0.9345793724060059, x));
            }
            this.weaponDamagedById = item;
        }
        if ((item = source.m_7640_()) instanceof Projectile) {
            Projectile projectile = (Projectile)item;
            if (this.projectileCount <= 0) {
                if (!this.m_9236_().f_46443_) {
                    ParticleHandler.particleSphereList(this.m_9236_(), 30, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.3f, (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), (ParticleOptions)ParticleRegistry.BLUE_FLAME.get());
                }
                if (projectile instanceof ReturningProjectile) {
                    return false;
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12227_, SoundSource.HOSTILE, 1.0f, 1.0f);
                Entity x = source.m_7639_();
                if (x instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)x;
                    double speed = projectile.m_20184_().m_82553_();
                    Vec3 newDir = this.m_20182_().m_82546_(attacker.m_20182_());
                    projectile.m_20334_(newDir.f_82479_ * speed, newDir.f_82480_ * speed, newDir.f_82481_ * speed);
                }
                return false;
            }
            --this.projectileCount;
        } else {
            this.projectileCount = (int)ConfigConstructor.old_champions_remains_max_projectile_hits_before_immune;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_(LAST_WEAPON_DAMAGED_BY, this.weaponDamagedById);
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.old_champions_remains_xp;
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundRegistry.DRAUGR_BOSS_SONG.get();
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_(LAST_WEAPON_DAMAGED_BY)) {
            this.weaponDamagedById = nbt.m_128461_(LAST_WEAPON_DAMAGED_BY);
        }
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.old_champions_remains_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.old_champions_remains_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.old_champions_remains_status_effect_blacklist;
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.old_champions_remains_is_fire_immune;
    }

    @Override
    public int getTicksUntilDeath() {
        return 20;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setState(States.DEATH);
        CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123745_, (ParticleOptions)ParticleRegistry.BLACK_FLAME.get()});
        NightShade entity = new NightShade((EntityType<? extends NightShade>)((EntityType)EntityRegistry.NIGHT_SHADE.get()), this.m_9236_());
        entity.m_20343_(this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_());
        entity.m_20334_(0.0, 0.1f, 0.0);
        entity.setSpawn();
        this.m_9236_().m_7967_((Entity)entity);
    }

    @Override
    public void setDeath() {
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.old_champions_remains_disables_shields && this.shouldDisableShield || ConfigConstructor.old_champions_remains_disables_shields_all_attacks;
    }

    public void updateDisableShield(boolean bl) {
        this.shouldDisableShield = bl;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::attackAnimations)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if ((float)this.getSameWeaponCount() >= ConfigConstructor.old_champions_remains_hits_before_growing_resistant) {
            return SoundEvents.f_12600_;
        }
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    public static enum States {
        IDLE,
        SPAWN,
        DEATH,
        COUNTER,
        SHIELD_BASH,
        SHIELD_VAULT,
        SWIPES,
        BACKSTEP,
        HEAVY,
        GROUND_SLAM,
        PARRY,
        BATTLE_CRY,
        LEAP,
        RUN_THRUST;

    }
}

