/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DayStalkerGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.projectile.noclip.AirCombustion;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DayStalker
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    public int phaseTwoTicks;
    public int spawnTicks;
    public int phaseTwoMaxTransitionTicks = 120;
    public int maxSpawnTicks = 50;
    public int flightTimer = 0;
    public static final int ATTACKS_LENGTH = Attacks.values().length;
    private static final EntityDataAccessor<Integer> ATTACKS = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> INITIATING_PHASE_2 = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PHASE_2 = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> PARTNER_UUID = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> REMAINING_ANI_TICKS = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> CHASE_TARGET = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAIT_ANIMATION = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPAWN_PARTICLES_STATE = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> FLAMETHROWER_TARGET = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> FLAMES_EDGE_RADIUS = SynchedEntityData.m_135353_(DayStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public DayStalker(EntityType<? extends DayStalker> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.YELLOW);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new DayStalkerGoal(this, 0.75, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.isPartner((LivingEntity)entity)));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void setAttackAnimation(Attacks attack) {
        for (int i = 0; i < ATTACKS_LENGTH; ++i) {
            if (!Attacks.values()[i].equals((Object)attack)) continue;
            this.f_19804_.m_135381_(ATTACKS, (Object)i);
        }
    }

    public Attacks getAttackAnimation() {
        return Attacks.values()[(Integer)this.f_19804_.m_135370_(ATTACKS)];
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(INITIATING_PHASE_2);
    }

    public void setInitiatePhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(INITIATING_PHASE_2, (Object)bl);
    }

    private PlayState chains(AnimationState<?> state) {
        if (!this.isInitiatingPhaseTwo() && this.isPhaseTwo()) {
            if (this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(RawAnimation.begin().then("idle_chains_2", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState idles(AnimationState<?> state) {
        if (this.m_21224_() || this.getAttackAnimation().equals((Object)Attacks.DEATH) || this.getDeathTicks() > 0) {
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("death_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("death_1", Animation.LoopType.LOOP));
            }
        } else if (!this.isInitiatingPhaseTwo()) {
            if (this.isPhaseTwo()) {
                if (!this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_2", Animation.LoopType.LOOP));
                } else {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_flames_reach_2", Animation.LoopType.LOOP));
                }
            } else if (!this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                if (this.isFlying()) {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_flying_1", Animation.LoopType.LOOP));
                } else {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_1", Animation.LoopType.LOOP));
                }
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("idle_flames_reach_1", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState attacks(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_phase_2", Animation.LoopType.PLAY_ONCE));
        } else if (this.isSpawning()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn_1", Animation.LoopType.PLAY_ONCE));
        } else if (!this.isPhaseTwo()) {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("air_combustion_1", Animation.LoopType.LOOP));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().then("decimate_1", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("dawnbreaker_1", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("chaos_storm_1", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("flamethrower_1", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("sunfire_rush_1", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("conflagration_1", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_edge_1", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_reach_1", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_1", Animation.LoopType.LOOP));
                    break;
                }
            }
        } else {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("air_combustion_2", Animation.LoopType.LOOP));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().then("decimate_2", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("dawnbreaker_2", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("chaos_storm_2", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("flamethrower_2", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("sunfire_rush_2", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("conflagration_2", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_edge_2", Animation.LoopType.LOOP));
                    break;
                }
                case 11: {
                    state.getController().setAnimation(RawAnimation.begin().then("radiance_2", Animation.LoopType.LOOP));
                    break;
                }
                case 12: {
                    state.getController().setAnimation(RawAnimation.begin().then("warmth_2", Animation.LoopType.LOOP));
                    break;
                }
                case 13: {
                    state.getController().setAnimation(RawAnimation.begin().then("overheat_2", Animation.LoopType.LOOP));
                    break;
                }
                case 14: {
                    state.getController().setAnimation(RawAnimation.begin().then("inferno_2", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_reach_2", Animation.LoopType.LOOP));
                    break;
                }
                case 17: {
                    state.getController().setAnimation(RawAnimation.begin().then("sky_high_2", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_2", Animation.LoopType.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks == this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123744_, ParticleTypes.f_123755_});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected SoundEvent m_5592_() {
        return this.isPhaseTwo() ? (SoundEvent)SoundRegistry.HARD_BOSS_DEATH_LONG.get() : (SoundEvent)SoundRegistry.HARD_BOSS_DEATH_SHORT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12231_;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.isPhaseTwo() ? 140 : 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(Attacks.DEATH);
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.day_stalker_is_fire_immune;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.day_stalker_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.day_stalker_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.day_stalker_status_effect_blacklist;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.day_stalker_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idles", 0, this::idles)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "chains", 0, this::chains)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKS, (Object)0);
        this.f_19804_.m_135372_(INITIATING_PHASE_2, (Object)false);
        this.f_19804_.m_135372_(IS_PHASE_2, (Object)false);
        this.f_19804_.m_135372_(PARTNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(REMAINING_ANI_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(CHASE_TARGET, (Object)true);
        this.f_19804_.m_135372_(WAIT_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(SPAWN_PARTICLES_STATE, (Object)0);
        this.f_19804_.m_135372_(FLAMETHROWER_TARGET, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(FLAMES_EDGE_RADIUS, (Object)Float.valueOf(2.0f));
    }

    @Nullable
    public NightProwler getPartner(ServerLevel world) {
        return (NightProwler)world.m_8791_(this.getPartnerUuid());
    }

    public UUID getPartnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(PARTNER_UUID)).orElse(null);
    }

    public void setPartnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(PARTNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean isPartner(LivingEntity living) {
        return this.getPartnerUuid() != null && living.m_20148_() != null && this.getPartnerUuid().equals(living.m_20148_());
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 120.0).m_22268_(Attributes.f_22276_, ConfigConstructor.day_stalker_health).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, ConfigConstructor.day_stalker_armor).m_22268_(Attributes.f_22280_, 0.8);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getPartnerUuid() != null) {
            nbt.m_128362_("partner_uuid", this.getPartnerUuid());
        }
        nbt.m_128379_("phase_two", this.isPhaseTwo());
        nbt.m_128405_("remaining_ani_ticks", this.getRemainingAniTicks());
        nbt.m_128379_("is_flying", this.isFlying());
        nbt.m_128379_("chase_target", this.shouldChaseTarget());
        nbt.m_128405_("flight_timer", this.flightTimer);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        UUID uUID = null;
        if (nbt.m_128403_("partner_uuid")) {
            uUID = nbt.m_128342_("partner_uuid");
        }
        if (uUID != null) {
            try {
                this.setPartnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.m_128441_("phase_two")) {
            this.setPhaseTwo(nbt.m_128471_("phase_two"));
        }
        if (nbt.m_128441_("remaining_ani_ticks")) {
            this.setRemainingAniTicks(nbt.m_128451_("remaining_ani_ticks"));
        }
        if (nbt.m_128441_("is_flying")) {
            this.setFlying(nbt.m_128471_("is_flying"));
        }
        if (nbt.m_128441_("chase_target")) {
            this.setChaseTarget(nbt.m_128471_("chase_target"));
        }
        if (nbt.m_128441_("flight_timer")) {
            this.flightTimer = nbt.m_128451_("flight_timer");
        }
    }

    public boolean isEmpowered() {
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46461_() || this.isPhaseTwo();
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.day_stalker_xp;
    }

    @Override
    protected void m_8024_() {
        NightProwler partner;
        super.m_8024_();
        if (!this.m_9236_().f_46443_) {
            partner = this.getPartner((ServerLevel)this.m_9236_());
            if (!this.isPhaseTwo() && (partner == null || partner.m_21224_())) {
                this.m_21219_();
                this.setInitiatePhaseTwo(true);
                this.setFlying(false);
            }
        }
        if (this.isEmpowered()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 1, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 1, false, false));
        }
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTwoTicks;
            this.setFlying(false);
            int maxHealTicks = this.phaseTwoMaxTransitionTicks - 40;
            float healPerTick = this.m_21233_() / (float)maxHealTicks;
            this.m_5634_(healPerTick);
            if (this.phaseTwoTicks == 76) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.DAY_STALKER_RADIANCE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.phaseTwoTicks == 81) {
                if (!this.m_9236_().f_46443_) {
                    ParticleHandler.particleSphereList(this.m_9236_(), 1000, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123744_, ParticleTypes.f_123755_});
                }
                DayStalkerGoal placeHolder = new DayStalkerGoal(this, 1.0, true);
                placeHolder.aoe(4.0, 50.0f, 4.0f);
            }
            if (this.phaseTwoTicks >= this.phaseTwoMaxTransitionTicks) {
                this.setPhaseTwo(true);
                this.setInitiatePhaseTwo(false);
            }
        }
        if (this.isSpawning()) {
            ++this.spawnTicks;
            if (this.spawnTicks >= this.maxSpawnTicks) {
                this.setAttackAnimation(Attacks.IDLE);
                if (!this.m_9236_().f_46443_ && (partner = this.getPartner((ServerLevel)this.m_9236_())) != null) {
                    boolean bl = this.m_217043_().m_188499_();
                    this.setFlying(bl);
                    partner.setFlying(!bl);
                }
            }
        }
        this.setRemainingAniTicks(Math.max(this.getRemainingAniTicks() - 1, 0));
        if (this.getRemainingAniTicks() <= 0 && this.shouldWaitAnimation()) {
            this.setWaitAnimation(false);
            this.setAttackAnimation(Attacks.IDLE);
        }
    }

    @Override
    public boolean isSpawning() {
        return this.getAttackAnimation().equals((Object)Attacks.SPAWN);
    }

    @Override
    public SoundEvent getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getParticleState() == 1 && this.m_9236_().f_46443_) {
            Vec3 pos = this.getFlamethrowerTarget().m_252807_();
            double e = pos.m_7096_() - this.m_20185_();
            double f = pos.m_7098_() + 1.0 - this.m_20227_(1.0);
            double g = pos.m_7094_() - this.m_20189_();
            double distance = this.m_20238_(pos);
            double h = Math.sqrt(Math.sqrt(distance)) * 0.5;
            for (int i = 0; i < 50; ++i) {
                double velX = e + this.m_217043_().m_188583_() / 2.0 * h;
                double velY = f + this.m_217043_().m_188583_() / 2.0 * h;
                double velZ = g + this.m_217043_().m_188583_() / 2.0 * h;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20188_(), this.m_20189_(), velX / 10.0, velY / 10.0, velZ / 10.0);
            }
        }
        if (this.getAttackAnimation().equals((Object)Attacks.FLAMES_EDGE)) {
            float r = this.getFlamesEdgeRadius();
            for (int theta = 0; theta < 360; theta += this.isPhaseTwo() ? 4 : 8) {
                double x0 = this.m_20185_();
                double z0 = this.m_20189_();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                if (this.getParticleState() == 2 && this.f_19797_ % 8 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, this.m_20227_(0.5), z, 0.0, 0.0, 0.0);
                    continue;
                }
                if (this.getParticleState() != 3) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, this.m_20227_(0.5), z, this.f_19796_.m_188583_() / 8.0, this.f_19796_.m_188583_() / 8.0, this.f_19796_.m_188583_() / 8.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, this.m_20227_(0.5), z, 0.0, (double)0.2f, 0.0);
            }
        }
    }

    public void setParticleState(int type) {
        this.f_19804_.m_135381_(SPAWN_PARTICLES_STATE, (Object)type);
    }

    public int getParticleState() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_PARTICLES_STATE);
    }

    public void setFlamethrowerTarget(BlockPos pos) {
        this.f_19804_.m_135381_(FLAMETHROWER_TARGET, (Object)pos);
    }

    public BlockPos getFlamethrowerTarget() {
        return (BlockPos)this.f_19804_.m_135370_(FLAMETHROWER_TARGET);
    }

    public void setRemainingAniTicks(int ticks) {
        this.f_19804_.m_135381_(REMAINING_ANI_TICKS, (Object)ticks);
    }

    public int getRemainingAniTicks() {
        return (Integer)this.f_19804_.m_135370_(REMAINING_ANI_TICKS);
    }

    public void setPhaseTwo(boolean bl) {
        this.f_19804_.m_135381_(IS_PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.f_19804_.m_135370_(IS_PHASE_2);
    }

    public void setFlying(boolean bl) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)bl);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setTargetPos(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(TARGET_POS);
    }

    public void setChaseTarget(boolean bl) {
        this.f_19804_.m_135381_(CHASE_TARGET, (Object)bl);
    }

    public boolean shouldChaseTarget() {
        return (Boolean)this.f_19804_.m_135370_(CHASE_TARGET);
    }

    public void setWaitAnimation(boolean bl) {
        this.f_19804_.m_135381_(WAIT_ANIMATION, (Object)bl);
    }

    public boolean shouldWaitAnimation() {
        return (Boolean)this.f_19804_.m_135370_(WAIT_ANIMATION);
    }

    public void setFlamesEdgeRadius(float radius) {
        this.f_19804_.m_135381_(FLAMES_EDGE_RADIUS, (Object)Float.valueOf(radius));
    }

    public float getFlamesEdgeRadius() {
        return ((Float)this.f_19804_.m_135370_(FLAMES_EDGE_RADIUS)).floatValue();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.getAttackAnimation().equals((Object)Attacks.OVERHEAT)) {
            amount *= 0.6f;
        }
        if (this.isEmpowered() && source.m_269533_(DamageTypeTags.f_268524_) && !this.isFlying()) {
            amount *= this.isPhaseTwo() ? ConfigConstructor.day_stalker_empowered_projectile_damage_taken_modifier_phase_2 : ConfigConstructor.day_stalker_empowered_projectile_damage_taken_modifier_phase_1;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if ((double)this.m_21223_() < (double)this.m_21233_() * ConfigConstructor.day_stalker_projectile_cause_air_combustion_below_percent_health) {
                    AirCombustion airCombustion = new AirCombustion(this.m_9236_(), (LivingEntity)this, 35.0f * ConfigConstructor.day_stalker_damage_modifier, this.isPhaseTwo() ? 5.0f : 3.0f, 12);
                    airCombustion.m_20343_(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_());
                    airCombustion.setEmpowered(this.isEmpowered());
                    this.m_9236_().m_7967_((Entity)airCombustion);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_20068_() {
        return this.isFlying();
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        if (!this.isFlying()) {
            super.m_7840_(heightDifference, onGround, state, landedPosition);
        }
    }

    public boolean m_6147_() {
        return !this.isFlying() && super.m_6147_();
    }

    protected boolean m_6125_() {
        return this.isPhaseTwo();
    }

    public static enum Attacks {
        IDLE,
        DEATH,
        SPAWN,
        AIR_COMBUSTION,
        DECIMATE,
        DAWNBREAKER,
        CHAOS_STORM,
        FLAMETHROWER,
        SUNFIRE_RUSH,
        CONFLAGRATION,
        FLAMES_EDGE,
        RADIANCE,
        WARMTH,
        OVERHEAT,
        INFERNO,
        FLAMES_REACH,
        BLAZE_BARRAGE,
        SKY_HIGH;

    }
}

