/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.ChaosMonarchGoal;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.items.armor.ChaosRobes;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChaosMonarch
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private static final EntityDataAccessor<Integer> ATTACK = SynchedEntityData.m_135353_(ChaosMonarch.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ChaosMonarch(EntityType<? extends BossEntity> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.PURPLE);
    }

    private PlayState predicate(AnimationState<?> state) {
        switch (this.getAttack().ordinal()) {
            case 1: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("teleport"));
                break;
            }
            case 3: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("swing_staff"));
                break;
            }
            case 4: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("lightning_call"));
                break;
            }
            case 5: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("shoot"));
                break;
            }
            case 6: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("barrage"));
                break;
            }
            case 7: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ChaosMonarchGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AccursedLordBoss.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22276_, ConfigConstructor.chaos_monarch_health).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, ConfigConstructor.chaos_monarch_armor).m_22268_(Attributes.f_22282_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK, (Object)0);
    }

    @Override
    public int getTicksUntilDeath() {
        return 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttack(7);
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123799_, (ParticleOptions)ParticleRegistry.PURPLE_FLAME.get()});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            SimpleParticleType[] dragonParticles = new SimpleParticleType[]{ParticleTypes.f_123799_, ParticleTypes.f_123799_};
            SimpleParticleType[] portalParticles = new SimpleParticleType[]{ParticleTypes.f_123760_};
            if (this.spawnTicks % 2 == 0 && this.spawnTicks < 20) {
                this.particleExplosion(portalParticles, 4.0f);
            }
            if (this.spawnTicks == 40) {
                this.particleExplosion(dragonParticles, 0.5f);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12556_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.spawnTicks >= 60) {
                this.setAttack(0);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.m_9236_().m_269111_().m_269548_()) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public int getXp() {
        return (int)ConfigConstructor.chaos_monarch_xp;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21023_((MobEffect)EffectRegistry.DECAY.get()) && this.f_19797_ % 10 == 0) {
            this.m_5634_(this.m_21124_((MobEffect)EffectRegistry.DECAY.get()).m_19564_() + 1 + this.getAttackingPlayers().size());
            for (LivingEntity target : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(3.0))) {
                if (target instanceof Player || target == this) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 3));
            }
        }
        if (ConfigConstructor.chaos_monarch_wither_ground) {
            this.turnBlocks(this.m_9236_(), this.m_20183_());
        }
    }

    @Override
    public boolean isSpawning() {
        return this.getAttack() == Attack.SPAWN;
    }

    @Override
    public SoundEvent getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    private void turnBlocks(Level world, BlockPos blockPos) {
        ChaosRobes cape = (ChaosRobes)ArmorRegistry.CHAOS_ROBES.get();
        cape.turnBlocks((LivingEntity)this, world, blockPos, 3);
    }

    private void particleExplosion(SimpleParticleType[] particles, float sizeModifier) {
        this.roundParticleOutburst(this.m_9236_(), 1000.0, particles, this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), sizeModifier);
    }

    public void roundParticleOutburst(Level world, double points, SimpleParticleType[] particles, double x, double y, double z, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            for (SimpleParticleType particle : particles) {
                world.m_6493_((ParticleOptions)particle, true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            }
            ++i;
        }
    }

    public void setAttack(int attackId) {
        this.f_19804_.m_135381_(ATTACK, (Object)attackId);
    }

    public Attack getAttack() {
        return Attack.values()[(Integer)this.f_19804_.m_135370_(ATTACK)];
    }

    public Vec3 getRotationVec(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.chaos_monarch_disables_shields;
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.chaos_monarch_is_fire_immune;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.chaos_monarch_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.chaos_monarch_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.chaos_monarch_status_effect_blacklist;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12557_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12556_;
    }

    public static enum Attack {
        IDLE,
        SPAWN,
        TELEPORT,
        MELEE,
        LIGHTNING,
        SHOOT,
        BARRAGE,
        DEATH;

    }
}

