/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.StopBossMusicS2C;
import net.soulsweaponry.util.IAnimatedDeath;
import org.jetbrains.annotations.Nullable;

public abstract class BossEntity
extends Monster
implements IAnimatedDeath {
    protected final ServerBossEvent bossBar;
    private boolean hasUpdatedHealth = false;
    private boolean playingMusic = false;

    protected BossEntity(EntityType<? extends Monster> entityType, Level world, BossEvent.BossBarColor barColor) {
        super(entityType, world);
        this.bossBar = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), barColor, BossEvent.BossBarOverlay.NOTCHED_10).m_7003_(true);
        this.f_21364_ = this.getXp();
    }

    public abstract int getXp();

    protected void m_8024_() {
        if (!this.hasUpdatedHealth) {
            this.m_21153_(this.m_21233_());
            this.hasUpdatedHealth = true;
        }
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void tryToPlayBossMusic() {
        if (this.hasBossMusic() && !this.m_9236_().f_46443_ && !this.playingMusic) {
            this.m_9236_().m_5594_(null, this.m_20183_(), this.getBossMusic(), SoundSource.MUSIC, 1.0f, 1.0f);
            this.playingMusic = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isSpawning()) {
            this.tryToPlayBossMusic();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_21223_() - amount > 0.0f) {
            this.tryToPlayBossMusic();
        }
        return super.m_6469_(source, amount);
    }

    public abstract boolean isSpawning();

    public abstract SoundEvent getBossMusic();

    public abstract boolean hasBossMusic();

    public boolean isPlayingMusic() {
        return this.playingMusic;
    }

    public void setPlayingMusic(boolean playingMusic) {
        this.playingMusic = playingMusic;
    }

    public int getReducedCooldownAttackers() {
        List<LivingEntity> attackers = this.getAttackers();
        int reduced = 0;
        for (LivingEntity entity : attackers) {
            reduced += entity instanceof Player ? 5 : 2;
        }
        return reduced;
    }

    public List<LivingEntity> getAttackers() {
        AABB box = this.m_20191_().m_82400_(10.0);
        List entities = this.m_9236_().m_45933_((Entity)this, box);
        ArrayList<LivingEntity> attackers = new ArrayList<LivingEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).m_21214_() != this) continue;
            attackers.add((LivingEntity)entity);
        }
        return attackers;
    }

    public List<Player> getAttackingPlayers() {
        List<LivingEntity> entities = this.getAttackers();
        ArrayList<Player> players = new ArrayList<Player>();
        for (LivingEntity entity : entities) {
            if (!(entity instanceof Player)) continue;
            players.add((Player)entity);
        }
        return players;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("HasUpdatedHealth", this.hasUpdatedHealth);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
        if (nbt.m_128441_("HasUpdatedHealth")) {
            this.hasUpdatedHealth = nbt.m_128471_("HasUpdatedHealth");
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setDeath();
        if (this.getBossMusic() != null && this.hasBossMusic() && this.m_9236_() instanceof ServerLevel) {
            ModMessages.sendToAllPlayers(new StopBossMusicS2C(this.getBossMusic().m_11660_()));
        }
    }

    protected boolean m_6124_() {
        return true;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    @Override
    public abstract void m_6153_();

    @Override
    public abstract int getTicksUntilDeath();

    @Override
    public abstract int getDeathTicks();

    @Override
    public abstract void setDeath();

    public abstract boolean m_5825_();

    public abstract boolean m_21222_();

    public MobType m_6336_() {
        String id = this.getGroupId();
        if (id == null) {
            return MobType.f_21640_;
        }
        return switch (id.toUpperCase()) {
            case "UNDEAD" -> MobType.f_21641_;
            case "ARTHROPOD" -> MobType.f_21642_;
            case "ILLAGER" -> MobType.f_21643_;
            case "AQUATIC" -> MobType.f_21644_;
            default -> MobType.f_21640_;
        };
    }

    public abstract boolean m_213824_();

    public abstract String getGroupId();

    public boolean isProjectileWhitelisted(DamageSource source) {
        if (source.m_7640_() != null) {
            return this.isProjectileWhitelisted(source.m_7640_());
        }
        return false;
    }

    public boolean isProjectileWhitelisted(Entity entity) {
        ResourceLocation attackerId = EntityType.m_20613_((EntityType)entity.m_6095_());
        return List.of(this.getWhitelistedProjectiles()).contains(attackerId.m_135815_());
    }

    public String[] getWhitelistedProjectiles() {
        return new String[0];
    }

    public abstract String[] getBlacklistedStatusEffects();

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity source) {
        String effectId = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_())).toString();
        for (String blacklisted : this.getBlacklistedStatusEffects()) {
            if (!blacklisted.equals(effectId)) continue;
            return false;
        }
        return super.m_147207_(effect, source);
    }
}

