/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;

public class BigChungus
extends TamableAnimal
implements InventoryCarrier {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(BigChungus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> AGGRESSIVE = SynchedEntityData.m_135353_(BigChungus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TRADE_TICKS = SynchedEntityData.m_135353_(BigChungus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean healthUpdated = false;
    private final SimpleContainer inventory = new SimpleContainer(1);
    private int maxTradeCount = 16;
    private float turnChance = 1.0f / (float)this.maxTradeCount;

    public BigChungus(EntityType<? extends BigChungus> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 50;
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, p -> (!p.m_21023_((MobEffect)EffectRegistry.CHUNGUS_TONIC_EFFECT.get()) || this.isAggressive()) && !this.m_21824_()));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> entity instanceof Enemy && !(entity instanceof Creeper) && this.m_21824_() && !this.m_7307_((Entity)entity)));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createChungusAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, ConfigConstructor.moderatly_sized_chungus_heath).m_22268_(Attributes.f_22284_, ConfigConstructor.moderatly_sized_chungus_armor).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_6914_(LevelReader view) {
        BlockPos blockUnderEntity = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        BlockPos positionEntity = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        BlockState state = this.m_9236_().m_8055_(positionEntity);
        return view.m_45784_((Entity)this) && this.m_9236_().m_46462_() && !this.m_9236_().m_46855_(this.m_20191_()) && state.m_60734_().m_48673_(state) && this.m_9236_().m_8055_(blockUnderEntity).m_60643_((BlockGetter)view, blockUnderEntity, (EntityType)EntityRegistry.BIG_CHUNGUS.get()) && this.isSpawnable() && this.checkForMonolith();
    }

    public boolean checkForMonolith() {
        BlockPos entityPos = this.m_20183_();
        int radius = (int)ConfigConstructor.chungus_monolith_radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos checkPos = entityPos.m_7918_(x, 0, z);
                Block block = this.m_9236_().m_8055_(checkPos).m_60734_();
                if (block != BlockRegistry.CHUNGUS_MONOLITH.get()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpawnable() {
        return ConfigConstructor.can_moderatly_sized_chungus_spawn;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.BIG_CHUNGUS_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.FART_EVENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12237_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.healthUpdated) {
            int rand = this.m_217043_().m_188503_(100);
            switch (rand) {
                case 1: {
                    this.setState(ChungusStates.BOSNIAN);
                    this.updateStats(50.0f, 200);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setState(ChungusStates.DREAM);
                    break;
                }
                default: {
                    this.setState(ChungusStates.NORMAL);
                }
            }
            this.healthUpdated = true;
        }
        if (!this.m_35311_().m_7983_() && !this.isAggressive()) {
            this.increaseTradeTicks(1);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 250, true, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 30, 250, true, false));
            if (this.getTradeTicks() >= 60 && !this.m_9236_().f_46443_) {
                this.inventory.m_19195_();
                switch (this.getState().ordinal()) {
                    case 1: {
                        ParticleHandler.particleSphereList(this.m_9236_(), 10, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.2f);
                        break;
                    }
                    case 2: {
                        Item item = this.m_217043_().m_188499_() ? Items.f_42584_ : Items.f_42585_;
                        for (int i = 0; i < this.m_217043_().m_216332_(1, 9); ++i) {
                            this.trade(item.m_7968_());
                        }
                        break;
                    }
                    default: {
                        this.trade(this.getBarterItem());
                    }
                }
                this.setTradeTicks(0);
            }
        }
    }

    private void trade(ItemStack stack) {
        ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        entity.m_20334_(0.0, 0.5, 0.0);
        this.m_9236_().m_7967_((Entity)entity);
        this.maxTradeCount = Math.max(this.maxTradeCount - 1, 1);
        this.turnChance = 1.0f / (float)this.maxTradeCount;
        if (this.m_217043_().m_188501_() < this.turnChance) {
            this.setState(ChungusStates.BOSNIAN);
            this.updateStats(50.0f, 200);
            ParticleHandler.particleSphereList(this.m_9236_(), 10, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.2f);
        }
    }

    private void updateStats(float health, int exp) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)health);
        this.m_21153_(health);
        this.f_21364_ = exp;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getTradeTicks() > 0 && this.getTradeTicks() % 4 == 0) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123749_, this.m_20208_(0.8f), this.m_20187_() + (double)0.2f, this.m_20262_(0.8f), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getTradeTicks() {
        return (Integer)this.f_19804_.m_135370_(TRADE_TICKS);
    }

    public void increaseTradeTicks(int i) {
        this.setTradeTicks(this.getTradeTicks() + i);
    }

    public void setTradeTicks(int i) {
        this.f_19804_.m_135381_(TRADE_TICKS, (Object)i);
    }

    public ChungusStates getState() {
        return ChungusStates.values()[(Integer)this.f_19804_.m_135370_(STATE)];
    }

    public void setState(ChungusStates state) {
        for (int i = 0; i < ChungusStates.values().length; ++i) {
            if (!ChungusStates.values()[i].equals((Object)state)) continue;
            this.f_19804_.m_135381_(STATE, (Object)i);
        }
    }

    public void setStateId(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public int getStateId() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public boolean isAggressive() {
        return (Boolean)this.f_19804_.m_135370_(AGGRESSIVE);
    }

    public void setAggressive(boolean bl) {
        this.f_19804_.m_135381_(AGGRESSIVE, (Object)bl);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(TRADE_TICKS, (Object)0);
        this.f_19804_.m_135372_(AGGRESSIVE, (Object)false);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("healthUpdated")) {
            this.healthUpdated = nbt.m_128471_("healthUpdated");
        }
        if (nbt.m_128441_("state")) {
            this.setStateId(nbt.m_128451_("state"));
        }
        if (nbt.m_128441_("tradeCounter")) {
            this.maxTradeCount = nbt.m_128451_("tradeCounter");
        }
        if (nbt.m_128441_("turnChance")) {
            this.turnChance = nbt.m_128457_("turnChance");
        }
        if (nbt.m_128441_("aggressive")) {
            this.setAggressive(nbt.m_128471_("aggressive"));
        }
        this.m_253224_(nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("healthUpdated", this.healthUpdated);
        nbt.m_128405_("state", this.getStateId());
        nbt.m_128405_("tradeCounter", this.maxTradeCount);
        nbt.m_128350_("turnChance", this.turnChance);
        nbt.m_128379_("aggressive", this.isAggressive());
        this.m_252802_(nbt);
    }

    protected ItemStack addItem(ItemStack stack) {
        return this.inventory.m_19173_(stack);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.m_7472_(source, lootingMultiplier, allowDrops);
        this.inventory.m_19195_().forEach(arg_0 -> ((BigChungus)this).m_19983_(arg_0));
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ConfigConstructor.can_chungus_barter && stack.m_150930_((Item)ItemRegistry.CHUNGUS_EMERALD.get()) && this.m_35311_().m_7983_() && !this.isAggressive()) {
            this.addItem(stack);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)WeaponRegistry.CHUNGUS_STAFF.get()) && !((IConfigDisable)stack.m_41720_()).isDisabled(stack) && !this.isAggressive() && !this.m_21824_()) {
            this.m_7105_(true);
            this.m_21828_(player);
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            this.f_21344_.m_26573_();
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && this.getTradeTicks() == 0) {
            this.m_21839_(!this.m_21827_());
            if (this.m_21827_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private ItemStack getBarterItem() {
        LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation("soulsweapons", "gameplay/chungus_bartering"));
        ObjectArrayList list = lootTable.m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81417_));
        return list.isEmpty() ? Items.f_42329_.m_7968_() : (ItemStack)list.get(0);
    }

    public boolean m_21531_() {
        return this.inventory.m_7983_() && ConfigConstructor.can_chungus_barter;
    }

    protected void m_7581_(ItemEntity item) {
        if (item.m_32055_().m_150930_((Item)ItemRegistry.CHUNGUS_EMERALD.get())) {
            this.m_35311_().m_19173_(item.m_32055_());
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, this.m_5720_(), 1.0f, 1.0f);
            item.m_32055_().m_41774_(1);
        }
    }

    public boolean m_7307_(Entity other) {
        if (other instanceof OwnableEntity && ((OwnableEntity)other).m_269323_() != null && this.m_269323_() != null && ((OwnableEntity)other).m_269323_() == this.m_269323_()) {
            return true;
        }
        return super.m_7307_(other);
    }

    public EntityGetter m_9236_() {
        return super.m_9236_();
    }

    public static boolean canSpawnInDark(EntityType<? extends Mob> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && BigChungus.isSpawnDark(world, pos, random) && BigChungus.m_217057_(type, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isSpawnDark(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        if (world.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensionType = world.m_6042_();
        int i = dimensionType.m_223570_();
        if (i < 15 && world.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = world.m_6018_().m_46470_() ? world.m_46849_(pos, 10) : world.m_46803_(pos);
        return j <= dimensionType.m_223569_().m_214085_(random);
    }

    public static enum ChungusStates {
        NORMAL,
        BOSNIAN,
        DREAM;

    }
}

