/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;

public class DraugrBossGoal
extends MeleeAttackGoal {
    private final DraugrBoss boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int postureBreakTimer;
    private boolean hasPostureBroken;

    public DraugrBossGoal(DraugrBoss boss) {
        super((PathfinderMob)boss, 1.0, false);
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void reset(float cooldownModifier, boolean shieldUp) {
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor(ConfigConstructor.old_champions_remains_attack_cooldown_ticks * cooldownModifier / this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f ? 2.0 : 1.0);
        this.boss.setState(DraugrBoss.States.IDLE);
        this.boss.updateDisableShield(false);
        this.boss.setShielding(shieldUp);
    }

    public boolean applyDamage(LivingEntity target, float baseDamage) {
        float modified = baseDamage * ConfigConstructor.old_champions_remains_damage_modifier;
        if (this.boss.m_21023_(MobEffects.f_19600_)) {
            modified += (float)(4 + Objects.requireNonNull(this.boss.m_21124_(MobEffects.f_19600_)).m_19564_() * 4);
        }
        return target.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), modified);
    }

    public void m_8041_() {
        super.m_8041_();
        this.boss.m_21561_(false);
        this.boss.updateDisableShield(false);
        this.reset(0.0f, false);
    }

    protected boolean isInMeleeRange(LivingEntity target) {
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        return distanceToEntity <= this.m_6639_(target) * 2.0;
    }

    protected boolean isTargetRanged(LivingEntity target) {
        return ((ItemStack)target.m_6167_().iterator().next()).m_41720_() instanceof ProjectileWeaponItem;
    }

    protected boolean isTargetHealing(LivingEntity target) {
        ItemStack stack = (ItemStack)target.m_6167_().iterator().next();
        if (target.m_6117_()) {
            switch (stack.m_41780_()) {
                case EAT: 
                case DRINK: {
                    return true;
                }
            }
        }
        return false;
    }

    private void randomAttack(@Nullable DraugrBoss.States specificAttack, LivingEntity target, boolean ignoreChecks) {
        block15: {
            double distanceToEntity;
            DraugrBoss.States attack;
            block14: {
                if (target == null || specificAttack == DraugrBoss.States.IDLE) {
                    this.boss.setState(DraugrBoss.States.IDLE);
                    return;
                }
                int rand = this.boss.m_217043_().m_188503_(DraugrBoss.States.values().length);
                attack = DraugrBoss.States.values()[rand];
                if (specificAttack != null) {
                    attack = specificAttack;
                }
                distanceToEntity = this.boss.m_20280_((Entity)target);
                if (!this.boss.isShielding()) break block14;
                switch (attack) {
                    case COUNTER: 
                    case SHIELD_BASH: 
                    case GROUND_SLAM: 
                    case PARRY: {
                        if (this.isInMeleeRange(target)) {
                            this.boss.setState(attack);
                            break;
                        }
                        break block15;
                    }
                    case SHIELD_VAULT: 
                    case LEAP: {
                        if (distanceToEntity < 100.0 && !this.isInMeleeRange(target) || ignoreChecks) {
                            this.boss.setState(attack);
                            break;
                        }
                        break block15;
                    }
                    default: {
                        this.boss.setState(DraugrBoss.States.IDLE);
                        break;
                    }
                }
                break block15;
            }
            switch (attack) {
                case SWIPES: 
                case HEAVY: {
                    if (!this.isInMeleeRange(target)) break;
                    this.boss.setState(attack);
                    break;
                }
                case BACKSTEP: {
                    if (!this.isTargetRanged(target) && !this.isInMeleeRange(target)) break;
                    this.boss.setState(attack);
                    break;
                }
                case BATTLE_CRY: {
                    if (!(distanceToEntity < 240.0) || this.specialCooldown >= 0) break;
                    this.boss.setState(attack);
                    break;
                }
                case RUN_THRUST: {
                    if (!(distanceToEntity < 100.0 && !this.isInMeleeRange(target)) && !ignoreChecks) break;
                    this.boss.setState(attack);
                    break;
                }
                default: {
                    this.boss.setState(DraugrBoss.States.IDLE);
                }
            }
        }
    }

    public void m_8037_() {
        if (this.boss.isSpawning() || this.boss.m_21224_()) {
            return;
        }
        --this.attackCooldown;
        --this.specialCooldown;
        --this.postureBreakTimer;
        if (this.postureBreakTimer < -25) {
            this.postureBreakTimer = -5;
        }
        super.m_8037_();
        LivingEntity target = this.boss.m_5448_();
        if (target != null) {
            this.boss.m_21561_(true);
            if (this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f && !this.hasPostureBroken) {
                this.hasPostureBroken = true;
                this.postureBreakTimer = 50;
                this.boss.setPostureBroken(true);
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, 20));
            }
            if (this.postureBreakTimer < 0) {
                this.boss.setPostureBroken(false);
            }
            if (this.boss.isPostureBroken()) {
                return;
            }
            if (this.isTargetHealing(target) && this.boss.getState().equals((Object)DraugrBoss.States.IDLE) && !this.boss.isPostureBroken()) {
                if (this.boss.isShielding()) {
                    DraugrBoss.States[] leaps = new DraugrBoss.States[]{DraugrBoss.States.LEAP, DraugrBoss.States.SHIELD_VAULT};
                    this.randomAttack(leaps[this.boss.m_217043_().m_188503_(leaps.length)], target, true);
                } else {
                    this.randomAttack(DraugrBoss.States.RUN_THRUST, target, true);
                }
            }
            if (this.attackCooldown > 0 && !this.boss.isPostureBroken()) {
                this.boss.setState(DraugrBoss.States.IDLE);
            }
            if (this.attackCooldown < 0 && this.boss.getState().equals((Object)DraugrBoss.States.IDLE) && !this.boss.isPostureBroken()) {
                this.randomAttack(null, target, false);
            }
            switch (this.boss.getState()) {
                case COUNTER: {
                    this.singleTarget(target, 30, new int[]{18}, 20.0f, 0.0f, true, true, true);
                    break;
                }
                case SHIELD_BASH: {
                    this.singleTarget(target, 30, new int[]{18}, 10.0f, 4.0f, false, false, true);
                    break;
                }
                case SHIELD_VAULT: {
                    this.leapAttack(target, 10.0f, true);
                    break;
                }
                case SWIPES: {
                    int[] frames = new int[]{10, 18, 26};
                    this.singleTarget(target, 33, frames, 16.0f, 0.0f, false, false, false);
                    break;
                }
                case BACKSTEP: {
                    this.backstep(target);
                    break;
                }
                case HEAVY: {
                    this.heavyBlow(target);
                    break;
                }
                case GROUND_SLAM: {
                    this.aoe(30, 14, 8.0f, 3.0f, new MobEffect[0], 4.0, false);
                    break;
                }
                case PARRY: {
                    this.parry(target);
                    break;
                }
                case BATTLE_CRY: {
                    MobEffect[] effects = new MobEffect[]{MobEffects.f_19597_, MobEffects.f_19613_};
                    this.aoe(50, 30, 0.0f, 0.0f, effects, 10.0, true);
                    break;
                }
                case LEAP: {
                    this.leapAttack(target, 18.0f, false);
                    break;
                }
                case RUN_THRUST: {
                    this.runThrust(target);
                    break;
                }
                default: {
                    this.boss.setState(DraugrBoss.States.IDLE);
                }
            }
        }
    }

    private void singleTarget(LivingEntity target, int maxTicks, int[] frames, float damage, float knockback, boolean applyBleed, boolean disableShield, boolean shieldUpWhenDone) {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        if (disableShield) {
            this.boss.updateDisableShield(true);
        }
        for (int frame : frames) {
            if (this.attackStatus != frame || !this.isInMeleeRange(target) || !this.applyDamage(target, damage)) continue;
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!this.boss.m_9236_().f_46443_) {
                ((ServerLevel)this.boss.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (applyBleed) {
                BleedData.addBleed(target, (int)ConfigConstructor.old_champions_remains_bleed_applied);
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEED.get(), 200, 0));
            }
            if (!(knockback > 0.0f)) continue;
            double x = target.m_20185_() - this.boss.m_20185_();
            double z = target.m_20189_() - this.boss.m_20189_();
            target.m_147240_((double)knockback, -x, -z);
        }
        if (this.attackStatus >= maxTicks) {
            this.reset(1.0f, shieldUpWhenDone);
        }
    }

    private void leapAttack(LivingEntity target, float damage, boolean stunTarget) {
        ++this.attackStatus;
        this.boss.updateDisableShield(true);
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        if (this.attackStatus == 18) {
            double e = target.m_20185_() - this.boss.m_20185_();
            double g = target.m_20189_() - this.boss.m_20189_();
            this.boss.m_5997_(e / 4.0, 0.35, g / 4.0);
        }
        if (this.attackStatus == 26) {
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (this.isInMeleeRange(target) && this.applyDamage(target, damage)) {
                if (stunTarget) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 10));
                }
                if (!this.boss.m_9236_().f_46443_) {
                    ParticleHandler.particleSphereList(this.boss.m_9236_(), 10, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
                }
            }
        }
        if (this.attackStatus >= 35) {
            this.reset(0.0f, false);
        }
    }

    private void parry(LivingEntity target) {
        int[] frame = new int[]{26};
        this.singleTarget(target, 40, frame, 18.0f, 0.0f, false, true, false);
        if (this.attackStatus == 8 && this.isInMeleeRange(target)) {
            if (!target.m_21023_((MobEffect)EffectRegistry.POSTURE_BREAK.get())) {
                this.boss.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.POSTURE_BREAK_EVENT.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
            }
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.POSTURE_BREAK.get(), 40, 0));
        }
    }

    private void aoe(int maxTicks, int frame, float damage, float knockback, MobEffect[] effects, double boxSize, boolean shieldUpWhenDone) {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        if (effects.length > 0 && (this.attackStatus == 12 || this.attackStatus == 20)) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.SWORD_HIT_SHIELD_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus == frame) {
            if (damage > 0.0f) {
                if (!this.boss.m_9236_().f_46443_) {
                    ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
                this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12601_, SoundSource.HOSTILE, 0.8f, 1.0f);
            }
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(boxSize))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                for (MobEffect effect : effects) {
                    living.m_7292_(new MobEffectInstance(effect, 200, 0));
                }
                if (!(damage > 0.0f)) continue;
                this.applyDamage(living, damage);
                double x = living.m_20185_() - this.boss.m_20185_();
                double z = living.m_20189_() - this.boss.m_20189_();
                living.m_147240_((double)knockback, -x, -z);
            }
        }
        if (this.attackStatus >= maxTicks) {
            this.reset(2.0f, shieldUpWhenDone);
            if (effects.length > 0) {
                this.specialCooldown = (int)ConfigConstructor.old_champions_remains_special_cooldown_ticks;
            }
        }
    }

    private void backstep(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        if (this.attackStatus == 6) {
            double e = target.m_20185_() - this.boss.m_20185_();
            double g = target.m_20189_() - this.boss.m_20189_();
            this.boss.m_5997_(-e / 4.0, 0.35, -g / 4.0);
        }
        if (this.attackStatus >= 30) {
            this.reset(0.0f, true);
        }
    }

    private void runThrust(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus <= 10) {
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 3));
        } else {
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        }
        if (this.attackStatus == 13 && this.isInMeleeRange(target) && this.applyDamage(target, 16.0f)) {
            BleedData.addBleed(target, (int)ConfigConstructor.old_champions_remains_bleed_applied);
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEED.get(), 100, 0));
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!this.boss.m_9236_().f_46443_) {
                ((ServerLevel)this.boss.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.attackStatus >= 23) {
            this.reset(1.0f, false);
        }
    }

    private void heavyBlow(LivingEntity target) {
        BlockPos pos;
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20, false, true));
        if (this.attackStatus == 1 && target.m_20183_() != null) {
            this.boss.setTargetPos(target.m_20183_());
        }
        if ((pos = this.boss.getTargetPos()) != null && DraugrBossGoal.isPosNotNullish(pos)) {
            this.boss.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        if (this.attackStatus == 24 && pos != null && DraugrBossGoal.isPosNotNullish(pos)) {
            this.boss.m_9236_().m_5594_(null, pos, SoundEvents.f_12555_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleSphereList(this.boss.m_9236_(), 100, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            }
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(pos).m_82400_(1.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.applyDamage(living, 25.0f);
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
            }
        }
        if (this.attackStatus >= 40) {
            this.reset(1.0f, false);
        }
    }

    public static boolean isPosNotNullish(BlockPos pos) {
        return pos.m_123341_() != 0 || pos.m_123342_() != 0 || pos.m_123343_() != 0;
    }

    protected void m_6739_(LivingEntity target, double squaredDistance) {
    }
}

