/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.projectile.ShadowOrb;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import org.jetbrains.annotations.Nullable;

public class AccursedLordGoal
extends Goal {
    private final AccursedLordBoss boss;
    private int attackCooldown;
    private int attackStatus;
    private BlockPos attackPos;
    private boolean cordsRegistered;
    private int targetNotVisibleTicks;
    private int specialCooldown;
    private int lavaRadius = 4;
    private int lavaTimer;

    public AccursedLordGoal(AccursedLordBoss boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.boss.m_5448_();
        return target != null && target.m_6084_() && this.boss.m_6779_(target);
    }

    public void resetAttackCooldown(float cooldownModifier) {
        this.attackStatus = 0;
        this.cordsRegistered = false;
        this.attackCooldown = (int)Math.floor(ConfigConstructor.decaying_king_attack_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers();
    }

    public void resetSpecialCooldown(float cooldownModifier) {
        this.specialCooldown = (int)(Math.floor(ConfigConstructor.decaying_king_special_cooldown_ticks * cooldownModifier) - (double)this.boss.getReducedCooldownAttackers());
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.decaying_king_damage_modifier;
    }

    private void damageTarget(LivingEntity target, DamageSource source, float amount) {
        if (target.m_6469_(source, this.getModifiedDamage(amount))) {
            this.boss.m_5634_(this.getModifiedDamage(amount) / 5.0f + (float)(this.boss.getAttackers().size() * 2));
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
        this.attackCooldown = 10;
        this.attackStatus = 0;
        this.cordsRegistered = false;
        this.boss.removePlacedLava();
        this.lavaRadius = 4;
        this.lavaTimer = 0;
    }

    public void checkAndSetAttack(@Nullable AccursedLordBoss.AccursedLordAnimations specificAttack, LivingEntity target) {
        if (target == null || specificAttack != null && specificAttack.equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
            this.boss.setAttackAnimation(specificAttack);
            return;
        }
        int rand = this.boss.m_217043_().m_188503_(AccursedLordBoss.AccursedLordAnimations.values().length);
        AccursedLordBoss.AccursedLordAnimations attack = AccursedLordBoss.AccursedLordAnimations.values()[rand];
        if (specificAttack != null) {
            attack = specificAttack;
        } else if (attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.DEATH) || attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.SPAWN) || attack.equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
            attack = AccursedLordBoss.AccursedLordAnimations.SWORDSLAM;
        }
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        switch (attack) {
            case FIREBALLS: 
            case WITHERBALLS: {
                if (!(distanceToEntity < this.getFollowRange() * this.getFollowRange())) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case HAND_SLAM: 
            case HEATWAVE: 
            case SPIN: {
                if (distanceToEntity < 30.0 && this.specialCooldown < 0) {
                    this.boss.setAttackAnimation(attack);
                    break;
                }
                if (this.attackCooldown >= -30 && this.specialCooldown <= 10) break;
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                break;
            }
            case PULL: {
                if (!(distanceToEntity < this.getFollowRange() * this.getFollowRange() * 2.0) || !(distanceToEntity > 60.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case SWORDSLAM: {
                if (distanceToEntity < 40.0 && !this.cordsRegistered && target.m_20183_() != null) {
                    this.attackPos = target.m_20183_();
                    this.cordsRegistered = true;
                    this.boss.setAttackAnimation(attack);
                    break;
                }
                if (this.attackCooldown >= -30) break;
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                break;
            }
            default: {
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
            }
        }
    }

    private double getFollowRange() {
        return this.boss.m_21133_(Attributes.f_22277_);
    }

    public void m_8037_() {
        LivingEntity target;
        --this.attackCooldown;
        --this.specialCooldown;
        if (this.lavaTimer > 0) {
            --this.lavaTimer;
            if (this.lavaTimer <= 0) {
                this.boss.removePlacedLava();
            }
        }
        if ((target = this.boss.m_5448_()) != null && !this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.SPAWN) && !this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.DEATH)) {
            this.boss.m_21561_(true);
            this.boss.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            boolean entityInSight = this.boss.m_21574_().m_148306_((Entity)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            double distanceToEntity = this.boss.m_20280_((Entity)target);
            if (this.attackCooldown > 0) {
                this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
            }
            if (this.attackCooldown < 0 && this.boss.getAttackAnimation().equals((Object)AccursedLordBoss.AccursedLordAnimations.IDLE)) {
                this.checkAndSetAttack(null, target);
            }
            switch (this.boss.getAttackAnimation()) {
                case FIREBALLS: {
                    this.projectileBarrage(target, distanceToEntity, BarrageProjectiles.FIREBALLS);
                    break;
                }
                case WITHERBALLS: {
                    this.projectileBarrage(target, distanceToEntity, BarrageProjectiles.WITHERBALLS);
                    break;
                }
                case HEATWAVE: {
                    this.heatWaveAttack();
                    break;
                }
                case PULL: {
                    this.pullAttack(target);
                    break;
                }
                case SPIN: {
                    this.spinAttack();
                    break;
                }
                case SWORDSLAM: {
                    this.swordSlam();
                    break;
                }
                case HAND_SLAM: {
                    this.handSlamLava();
                    break;
                }
                default: {
                    this.boss.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.IDLE);
                }
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
            super.m_8037_();
        }
    }

    private void handSlamLava() {
        ++this.attackStatus;
        if (this.attackStatus == 13 || this.attackStatus == 18 || this.attackStatus == 24) {
            this.summonLava(this.lavaRadius);
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 200, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            ++this.lavaRadius;
        }
        if (this.attackStatus >= 25) {
            this.resetAttackCooldown(0.5f);
            this.resetSpecialCooldown(1.2f);
            this.checkAndSetAttack(null, this.boss.m_5448_());
            this.lavaRadius = 4;
        }
    }

    private void summonLava(int r) {
        for (int theta = 0; theta < 360; theta += 15) {
            double x0 = this.boss.m_20185_();
            double z0 = this.boss.m_20189_();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            BlockPos pos = BlockPos.m_274561_((double)x, (double)this.boss.m_20186_(), (double)z);
            if (!this.boss.m_9236_().m_8055_(pos).m_60795_()) continue;
            this.boss.m_9236_().m_46597_(pos, Blocks.f_49991_.m_49966_());
            this.boss.lavaPos.add(pos);
        }
        this.lavaTimer = 30;
    }

    private void spinAttack() {
        ++this.attackStatus;
        if (this.attackStatus >= 7 && this.attackStatus <= 40) {
            AABB chunkBox = new AABB(this.boss.m_20183_()).m_82400_(6.0);
            List nearbyEntities = this.boss.m_9236_().m_45933_((Entity)this.boss, chunkBox);
            for (Entity nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof LivingEntity)) continue;
                LivingEntity closestTarget = (LivingEntity)nearbyEntity;
                double x = closestTarget.m_20185_() - this.boss.m_20185_();
                double z = closestTarget.m_20189_() - this.boss.m_20189_();
                this.damageTarget(closestTarget, this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), 10.0f);
                closestTarget.m_147240_(4.0, -x, -z);
            }
        }
        if (this.attackStatus >= 45) {
            this.resetAttackCooldown(0.5f);
            this.resetSpecialCooldown(1.2f);
            this.checkAndSetAttack(null, this.boss.m_5448_());
        }
    }

    private void heatWaveAttack() {
        ++this.attackStatus;
        if (this.attackStatus >= 16 && this.attackStatus <= 18) {
            if (this.attackStatus == 17) {
                this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 5.0f, 1.0f);
            }
            AABB chunkBox = new AABB(this.boss.m_20183_()).m_82400_(5.0);
            List nearbyEntities = this.boss.m_9236_().m_45933_((Entity)this.boss, chunkBox);
            for (Entity nearbyEntity : nearbyEntities) {
                if (!(nearbyEntity instanceof LivingEntity)) continue;
                LivingEntity closestTarget = (LivingEntity)nearbyEntity;
                double x = closestTarget.m_20185_() - this.boss.m_20185_();
                double z = closestTarget.m_20189_() - this.boss.m_20189_();
                closestTarget.m_147240_(10.0, -x, -z);
                this.damageTarget(closestTarget, this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), 50.0f);
            }
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleSphere(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_() + (double)0.4f, this.boss.m_20189_(), (ParticleOptions)ParticleTypes.f_123744_, 1.0f);
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 200, this.boss.m_20185_(), this.boss.m_20186_() + (double)0.1f, this.boss.m_20189_(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
            }
        }
        if (this.attackStatus >= 30) {
            this.resetAttackCooldown(1.5f);
            this.checkAndSetAttack(null, this.boss.m_5448_());
            this.resetSpecialCooldown(1.0f);
        }
    }

    private void pullAttack(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 20) {
            double x = target.m_20185_() - this.boss.m_20185_();
            double z = target.m_20189_() - this.boss.m_20189_();
            this.damageTarget(target, this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), 5.0f);
            target.m_147240_(5.0, x, z);
        }
        if (this.attackStatus >= 25) {
            this.attackStatus = 0;
            this.resetAttackCooldown(0.25f);
            this.checkAndSetAttack(null, this.boss.m_5448_());
        }
    }

    private void swordSlam() {
        ++this.attackStatus;
        this.boss.m_21563_().m_24946_((double)this.attackPos.m_123341_(), (double)this.attackPos.m_123342_(), (double)this.attackPos.m_123343_());
        this.boss.m_21573_().m_26519_((double)this.attackPos.m_123341_(), (double)this.attackPos.m_123342_(), (double)this.attackPos.m_123343_(), 0.0);
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
        AABB aoe = new AABB(this.attackPos).m_82400_(3.0);
        List entities = this.boss.m_9236_().m_45933_((Entity)this.boss, aoe);
        if (this.attackStatus == 17) {
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 200, this.attackPos.m_123341_(), this.attackPos.m_123342_(), this.attackPos.m_123343_(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                this.damageTarget((LivingEntity)entity, CustomDamageSource.create(this.boss.m_9236_(), CustomDamageSource.OBLITERATED, (Entity)this.boss), 30.0f);
                entity.m_20334_(entity.m_20184_().f_82479_, (double)0.3f, entity.m_20184_().f_82481_);
            }
            this.boss.m_9236_().m_5594_(null, this.attackPos, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus >= 20) {
            this.resetAttackCooldown(0.5f);
            this.cordsRegistered = false;
            this.boss.m_21573_().m_26573_();
            this.checkAndSetAttack(null, this.boss.m_5448_());
        }
    }

    private void projectileBarrage(LivingEntity target, double distanceToEntity, BarrageProjectiles entity) {
        int fireSprayCount = 8;
        ++this.attackStatus;
        double e = target.m_20185_() - this.boss.m_20185_();
        double f = target.m_20227_(0.5) - this.boss.m_20227_(1.0);
        double g = target.m_20189_() - this.boss.m_20189_();
        if (this.attackStatus % 2 == 0 && this.attackStatus > 8) {
            double h = Math.sqrt(Math.sqrt(distanceToEntity)) * 0.5;
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 2.0f, 1.0f);
            for (int i = 0; i < fireSprayCount; ++i) {
                new SmallFireball(this.boss.m_9236_(), (LivingEntity)this.boss, e + this.boss.m_217043_().m_188583_() * h, f, g + this.boss.m_217043_().m_188583_() * h);
                Object projectile = switch (entity.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> new SmallFireball(this.boss.m_9236_(), (LivingEntity)this.boss, e + this.boss.m_217043_().m_188583_() * h, f, g + this.boss.m_217043_().m_188583_() * h);
                    case 1 -> new ShadowOrb(this.boss.m_9236_(), (LivingEntity)this.boss, e + this.boss.m_217043_().m_188583_() * h, f, g + this.boss.m_217043_().m_188583_() * h, MobEffects.f_19615_, (MobEffect)EffectRegistry.DECAY.get());
                };
                projectile.m_6034_(projectile.m_20185_(), this.boss.m_20227_(1.0) - 1.5, projectile.m_20189_());
                this.boss.m_9236_().m_7967_((Entity)projectile);
            }
        }
        if (this.attackStatus >= 30) {
            this.resetAttackCooldown(1.0f);
            this.checkAndSetAttack(null, this.boss.m_5448_());
        }
    }

    static enum BarrageProjectiles {
        FIREBALLS,
        WITHERBALLS;

    }
}

