/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.soulsweaponry.registry.EntityRegistry;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AreaEffectSphere
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(AreaEffectSphere.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PARTICLE_COUNT_MODIFIER = SynchedEntityData.m_135353_(AreaEffectSphere.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> WAITING = SynchedEntityData.m_135353_(AreaEffectSphere.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> PARTICLE_ID = SynchedEntityData.m_135353_(AreaEffectSphere.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private final List<MobEffectInstance> effects = Lists.newArrayList();
    private final Map<Entity, Integer> affectedEntities = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusGrowth;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;

    public AreaEffectSphere(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    public AreaEffectSphere(Level world, double x, double y, double z) {
        this((EntityType)EntityRegistry.AREA_EFFECT_SPHERE.get(), world);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(3.0f));
        this.m_20088_().m_135372_(PARTICLE_COUNT_MODIFIER, (Object)Float.valueOf(6.7f));
        this.m_20088_().m_135372_(WAITING, (Object)false);
        this.m_20088_().m_135372_(PARTICLE_ID, (Object)ParticleTypes.f_123811_);
    }

    public void setRadius(float radius) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void addEffect(MobEffectInstance effect) {
        this.effects.add(effect);
    }

    public ParticleOptions getParticleType() {
        return (ParticleOptions)this.m_20088_().m_135370_(PARTICLE_ID);
    }

    public void setParticleType(ParticleOptions particle) {
        this.m_20088_().m_135381_(PARTICLE_ID, (Object)particle);
    }

    protected void setWaiting(boolean waiting) {
        this.m_20088_().m_135381_(WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public float getParticleAmountModifier() {
        return ((Float)this.m_20088_().m_135370_(PARTICLE_COUNT_MODIFIER)).floatValue();
    }

    public void setParticleAmountModifier(float modifier) {
        this.m_20088_().m_135381_(PARTICLE_COUNT_MODIFIER, (Object)Float.valueOf(modifier));
    }

    public void m_8119_() {
        super.m_8119_();
        boolean bl = this.isWaiting();
        float f = this.getRadius();
        if (this.m_9236_().f_46443_) {
            if (bl && this.f_19796_.m_188499_()) {
                return;
            }
            int points = Mth.m_14143_((float)(this.getRadius() * this.getParticleAmountModifier()));
            AreaEffectSphere.randomParticleBox(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), points, this.getRadius() * 1.25f, this.getParticleType(), this.f_19796_);
        } else {
            boolean bl2;
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_146870_();
                return;
            }
            boolean bl3 = bl2 = this.f_19797_ < this.waitTime;
            if (bl != bl2) {
                this.setWaiting(bl2);
            }
            if (bl2) {
                return;
            }
            if (this.radiusGrowth != 0.0f) {
                if ((f += this.radiusGrowth) < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.setRadius(f);
            }
            if (this.f_19797_ % 5 == 0) {
                this.affectedEntities.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
                ArrayList list = Lists.newArrayList();
                list.addAll(this.effects);
                if (list.isEmpty()) {
                    this.affectedEntities.clear();
                } else {
                    List list2 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
                    if (!list2.isEmpty()) {
                        Iterator var27 = list2.iterator();
                        while (true) {
                            double r;
                            double q;
                            double s;
                            if (!var27.hasNext()) {
                                return;
                            }
                            LivingEntity livingEntity = (LivingEntity)var27.next();
                            if (this.affectedEntities.containsKey(livingEntity) || !livingEntity.m_5801_() || !((s = (q = livingEntity.m_20185_() - this.m_20185_()) * q + (r = livingEntity.m_20189_() - this.m_20189_()) * r) <= (double)(f * f))) continue;
                            this.affectedEntities.put((Entity)livingEntity, this.f_19797_ + this.reapplicationDelay);
                            for (MobEffectInstance statusEffectInstance2 : list) {
                                if (statusEffectInstance2.m_19544_().m_8093_()) {
                                    statusEffectInstance2.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), livingEntity, statusEffectInstance2.m_19564_(), 0.5);
                                    continue;
                                }
                                livingEntity.m_147207_(new MobEffectInstance(statusEffectInstance2), (Entity)this);
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.m_146870_();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration <= 0) break;
                        }
                        this.m_146870_();
                        return;
                    }
                }
            }
        }
    }

    public static void randomParticleBox(Level world, double x, double y, double z, double points, float sizeModifier, ParticleOptions particle, RandomSource random) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.m_6493_(particle, true, x + velocityX * (double)sizeModifier + random.m_188583_(), y + velocityY * (double)sizeModifier + random.m_188583_(), z + velocityZ * (double)sizeModifier + random.m_188583_(), 0.0, 0.0, 0.0);
            ++i;
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusGrowth() {
        return this.radiusGrowth;
    }

    public void setRadiusGrowth(float radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19797_ = nbt.m_128451_("Age");
        this.duration = nbt.m_128451_("Duration");
        this.waitTime = nbt.m_128451_("WaitTime");
        this.reapplicationDelay = nbt.m_128451_("ReapplicationDelay");
        this.durationOnUse = nbt.m_128451_("DurationOnUse");
        this.radiusOnUse = nbt.m_128457_("RadiusOnUse");
        this.radiusGrowth = nbt.m_128457_("RadiusPerTick");
        this.setRadius(nbt.m_128457_("Radius"));
        this.setParticleAmountModifier(nbt.m_128457_("ParticleAmountMod"));
        if (nbt.m_128403_("Owner")) {
            this.ownerUuid = nbt.m_128342_("Owner");
        }
        if (nbt.m_128425_("Particle", 8)) {
            try {
                this.setParticleType(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("Particle"), (Object)var5);
            }
        }
        if (nbt.m_128425_("Effects", 9)) {
            ListTag nbtList = nbt.m_128437_("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbtList.size(); ++i) {
                MobEffectInstance statusEffectInstance = MobEffectInstance.m_19560_((CompoundTag)nbtList.m_128728_(i));
                if (statusEffectInstance == null) continue;
                this.addEffect(statusEffectInstance);
            }
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Age", this.f_19797_);
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("WaitTime", this.waitTime);
        nbt.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        nbt.m_128405_("DurationOnUse", this.durationOnUse);
        nbt.m_128350_("RadiusOnUse", this.radiusOnUse);
        nbt.m_128350_("RadiusPerTick", this.radiusGrowth);
        nbt.m_128350_("Radius", this.getRadius());
        nbt.m_128350_("ParticleAmountMod", this.getParticleAmountModifier());
        nbt.m_128359_("Particle", this.getParticleType().m_5942_());
        if (this.ownerUuid != null) {
            nbt.m_128362_("Owner", this.ownerUuid);
        }
        if (!this.effects.isEmpty()) {
            ListTag nbtList = new ListTag();
            for (MobEffectInstance statusEffectInstance : this.effects) {
                nbtList.add((Object)statusEffectInstance.m_19555_(new CompoundTag()));
            }
            nbt.m_128365_("Effects", (Tag)nbtList);
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (RADIUS.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }
}

