/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.datagen.advancements;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.DistanceTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModTags;

public class AdvancementsProvider
implements ForgeAdvancementProvider.AdvancementGenerator {
    public static final List<RegistryObject<? extends Item>> ALL_WEAPONS = new ArrayList<RegistryObject<? extends Item>>();
    public static final List<RegistryObject<? extends Item>> ALL_GUNS = new ArrayList<RegistryObject<? extends Item>>();

    public void generate(HolderLookup.Provider arg, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)ItemRegistry.LOST_SOUL.get(), (Component)Component.m_237115_((String)"advancements.soulsweapons.root.title"), (Component)Component.m_237115_((String)"advancements.soulsweapons.root.description"), new ResourceLocation("textures/gui/advancements/backgrounds/obsidian.png"), FrameType.TASK, false, false, false).m_138386_("crafting_table", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_41960_})).m_138389_(consumer, "soulsweapons:root");
        Advancement lordSoul = this.generateAdvancement(consumer, "lord_soul", root, (Item)ItemRegistry.LORD_SOUL_ROSE.get(), FrameType.CHALLENGE, true, true, false, ModTags.Items.LORD_SOUL);
        Advancement moonstone = this.generateAdvancement(consumer, "moonstone", root, (Item)ItemRegistry.MOONSTONE.get(), FrameType.TASK, true, true, false, (Item)ItemRegistry.MOONSTONE.get());
        Advancement verglas = this.generateAdvancement(consumer, "verglas", root, (Item)ItemRegistry.VERGLAS.get(), FrameType.TASK, true, true, false, (Item)ItemRegistry.VERGLAS.get());
        Advancement uncertainty = this.generateAdvancement(consumer, "uncertainty", root, (Item)ItemRegistry.SHARD_OF_UNCERTAINTY.get(), FrameType.TASK, true, true, false, (Item)ItemRegistry.SHARD_OF_UNCERTAINTY.get());
        Advancement demonHeart = this.generateAdvancement(consumer, "demon_heart", root, (Item)ItemRegistry.DEMON_HEART.get(), FrameType.TASK, true, true, false, (Item)ItemRegistry.DEMON_HEART.get());
        Advancement bloodthirsty = this.generateAdvancement(consumer, "bloodthirsty", demonHeart, (Item)WeaponRegistry.BLOODTHIRSTER.get(), FrameType.TASK, true, true, false, new AbstractCriterionTriggerInstance[]{InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WeaponRegistry.BLOODTHIRSTER.get()}), EffectsChangedTrigger.TriggerInstance.m_26780_((MobEffectsPredicate)MobEffectsPredicate.m_56552_().m_56553_((MobEffect)EffectRegistry.BLOODTHIRSTY.get()))});
        Advancement returningKnight = this.generateAdvancement(consumer, "returning_knight", root, (Item)ItemRegistry.ARKENSTONE.get(), FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityRegistry.RETURNING_KNIGHT.get()))});
        Advancement draugrBoss = this.generateAdvancement(consumer, "draugr_boss", root, (Item)ItemRegistry.ESSENCE_OF_EVENTIDE.get(), FrameType.GOAL, true, true, false, new AbstractCriterionTriggerInstance[]{KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityRegistry.DRAUGR_BOSS.get())), InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ESSENCE_OF_EVENTIDE.get()})});
        Advancement moonknight = this.generateAdvancement(consumer, "moonknight", draugrBoss, (Item)ItemRegistry.ESSENCE_OF_LUMINESCENCE.get(), FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityRegistry.MOONKNIGHT.get()))});
        Advancement decayingKing = this.generateAdvancement(consumer, "end_of_reigns", bloodthirsty, (Item)ItemRegistry.WITHERED_DEMON_HEART.get(), FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityRegistry.ACCURSED_LORD_BOSS.get()))});
        Advancement chaosMonarch = this.generateAdvancement(consumer, "ender_of_world_ender", uncertainty, (Item)ArmorRegistry.CHAOS_CROWN.get(), FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityRegistry.CHAOS_MONARCH.get()))});
        Advancement arkenplate = this.generateAdvancement(consumer, "arkenplate", returningKnight, (Item)ArmorRegistry.ARKENPLATE.get(), FrameType.TASK, true, true, false, (Item)ArmorRegistry.ARKENPLATE.get());
        Advancement infusedArkenplate = this.generateAdvancement(consumer, "infused_arkenplate", arkenplate, (Item)ArmorRegistry.ENHANCED_ARKENPLATE.get(), FrameType.CHALLENGE, true, true, false, (Item)ArmorRegistry.ENHANCED_ARKENPLATE.get());
        Advancement hallowheart = this.generateAdvancement(consumer, "hallowheart", decayingKing, (Item)ArmorRegistry.WITHERED_CHEST.get(), FrameType.TASK, true, true, false, (Item)ArmorRegistry.WITHERED_CHEST.get());
        Advancement infusedHallowheart = this.generateAdvancement(consumer, "infused_hallowheart", hallowheart, (Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get(), FrameType.CHALLENGE, true, true, false, (Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get());
        Advancement pistol = this.generateAdvancement(consumer, "hunter_pistol", root, (Item)GunRegistry.HUNTER_PISTOL.get(), FrameType.GOAL, true, true, false, (Item)GunRegistry.HUNTER_PISTOL.get());
        Advancement blunderbuss = this.generateAdvancement(consumer, "blunderbuss", pistol, (Item)GunRegistry.BLUNDERBUSS.get(), FrameType.GOAL, true, true, false, (Item)GunRegistry.BLUNDERBUSS.get());
        Advancement gatlingGun = this.generateAdvancement(consumer, "gatling_gun", blunderbuss, (Item)GunRegistry.GATLING_GUN.get(), FrameType.GOAL, true, true, false, (Item)GunRegistry.GATLING_GUN.get());
        Advancement cannon = this.generateAdvancement(consumer, "cannon", gatlingGun, (Item)GunRegistry.HUNTER_CANNON.get(), FrameType.GOAL, true, true, false, (Item)GunRegistry.HUNTER_CANNON.get());
        Advancement bluemoonSwords = this.generateAdvancementAcceptEither(consumer, "bluemoon_tools", moonstone, (Item)WeaponRegistry.BLUEMOON_GREATSWORD.get(), FrameType.TASK, true, true, false, (Item)WeaponRegistry.BLUEMOON_GREATSWORD.get(), (Item)WeaponRegistry.BLUEMOON_SHORTSWORD.get());
        Advancement moonlightSwords = this.generateAdvancementAcceptEither(consumer, "moonlight_tools", bluemoonSwords, (Item)WeaponRegistry.MOONLIGHT_GREATSWORD.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.MOONLIGHT_GREATSWORD.get(), (Item)WeaponRegistry.MOONLIGHT_SHORTSWORD.get());
        Advancement allMoonlight = this.generateAdvancement(consumer, "all_moonlight_weapons", moonlightSwords, (Item)WeaponRegistry.DARK_MOON_GREATSWORD.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.MOONLIGHT_GREATSWORD.get(), (Item)WeaponRegistry.MOONLIGHT_SHORTSWORD.get(), (Item)WeaponRegistry.BLUEMOON_GREATSWORD.get(), (Item)WeaponRegistry.BLUEMOON_SHORTSWORD.get(), (Item)WeaponRegistry.MOONVEIL.get(), (Item)WeaponRegistry.DARK_MOON_GREATSWORD.get(), (Item)WeaponRegistry.PURE_MOONLIGHT_GREATSWORD.get(), (Item)WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.get(), (Item)WeaponRegistry.HOLY_MOONLIGHT_SWORD.get());
        Advancement transformScythe = this.generateAdvancementAcceptEither(consumer, "transform_scythe", lordSoul, (Item)WeaponRegistry.DARKIN_SCYTHE_PRE.get(), FrameType.CHALLENGE, true, true, false, (Item)WeaponRegistry.DARKIN_SCYTHE_PRIME.get(), (Item)WeaponRegistry.SHADOW_ASSASSIN_SCYTHE.get());
        Advancement rageblade = this.generateAdvancement(consumer, "rageblade", lordSoul, (Item)WeaponRegistry.GUINSOOS_RAGEBLADE.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.GUINSOOS_RAGEBLADE.get());
        Advancement nightfall = this.generateAdvancement(consumer, "nightfall", returningKnight, (Item)WeaponRegistry.NIGHTFALL.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.NIGHTFALL.get());
        Advancement dragonslayerSwordspear = this.generateAdvancement(consumer, "dragonslayer_swordspear", lordSoul, (Item)WeaponRegistry.DRAGONSLAYER_SWORDSPEAR.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.DRAGONSLAYER_SWORDSPEAR.get());
        Advancement leviathanAxe = this.generateAdvancement(consumer, "leviathan_axe", verglas, (Item)WeaponRegistry.LEVIATHAN_AXE.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.LEVIATHAN_AXE.get());
        Advancement whirligigSawblade = this.generateAdvancement(consumer, "whirligig_sawblade", lordSoul, (Item)WeaponRegistry.WHIRLIGIG_SAWBLADE.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.WHIRLIGIG_SAWBLADE.get());
        Advancement heapOfIron = this.generateAdvancement(consumer, "heap_of_iron", root, (Item)WeaponRegistry.GUTS_SWORD.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.GUTS_SWORD.get());
        Advancement wands = this.generateAdvancement(consumer, "lords_on_stick", chaosMonarch, (Item)WeaponRegistry.DRAGON_STAFF.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.DRAGON_STAFF.get(), (Item)WeaponRegistry.WITHERED_WABBAJACK.get());
        Advancement trickWeapon = this.generateAdvancement(consumer, "trickweapon", pistol, (Item)WeaponRegistry.HOLY_GREATSWORD.get(), FrameType.GOAL, true, true, false, ModTags.Items.TRICK_WEAPONS);
        Advancement hodirGlaive = this.generateAdvancement(consumer, "glaive_of_hodir", lordSoul, (Item)WeaponRegistry.GLAIVE_OF_HODIR.get(), FrameType.GOAL, true, true, false, (Item)WeaponRegistry.GLAIVE_OF_HODIR.get());
        Advancement excalibur = this.generateAdvancement(consumer, "excalibur", lordSoul, (Item)WeaponRegistry.EXCALIBUR.get(), FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WeaponRegistry.EXCALIBUR.get()}), KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217015_))});
        Advancement chaosOrb = this.generateAdvancement(consumer, "chaos_orb", decayingKing, (Item)ItemRegistry.CHAOS_ORB.get(), FrameType.GOAL, true, true, false, (Item)ItemRegistry.CHAOS_ORB.get());
        Advancement killDayNightBoss = this.generateAdvancement(consumer, "kill_day_night_boss", chaosOrb, (Item)ItemRegistry.LORD_SOUL_DAY_STALKER.get(), FrameType.CHALLENGE, true, true, false, ModTags.Items.DUO_BOSS_SOULS);
        Advancement dreamOn = this.generateAdvancement(consumer, "dream_on", lordSoul, Items.f_42479_, FrameType.CHALLENGE, true, true, false, new AbstractCriterionTriggerInstance[]{DistanceTrigger.TriggerInstance.m_186197_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36652_(MobEffectsPredicate.m_56552_().m_56553_((MobEffect)EffectRegistry.CALCULATED_FALL.get())), (DistancePredicate)DistancePredicate.m_148838_((MinMaxBounds.Doubles)MinMaxBounds.Doubles.m_154804_((double)50.0)), (LocationPredicate)LocationPredicate.m_187442_((MinMaxBounds.Doubles)MinMaxBounds.Doubles.f_154779_))});
        Advancement allWeapons = this.generateAdvancement(consumer, "all_weapons", allMoonlight, (Item)ItemRegistry.LORD_SOUL_PURPLE.get(), FrameType.CHALLENGE, true, true, false, (Item[])ALL_WEAPONS.stream().map(RegistryObject::get).toArray(Item[]::new));
    }

    public Advancement generateAdvancement(Consumer<Advancement> consumer, String advancementId, Advancement root, Item display, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden, TagKey<Item> tagCondition) {
        return this.generateAdvancement(consumer, advancementId, root, display, frame, showToast, announceToChat, hidden, new AbstractCriterionTriggerInstance[]{InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tagCondition).m_45077_()})});
    }

    public Advancement generateAdvancement(Consumer<Advancement> consumer, String advancementId, Advancement root, Item display, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden, Item ... itemCondition) {
        Advancement.Builder builder = this.generateAdvancementBase(root, display, advancementId, frame, showToast, announceToChat, hidden);
        for (Item item : itemCondition) {
            builder.m_138386_(item.toString(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
        }
        return builder.m_138389_(consumer, "soulsweapons:" + advancementId);
    }

    public Advancement generateAdvancement(Consumer<Advancement> consumer, String advancementId, Advancement root, Item display, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden, AbstractCriterionTriggerInstance ... conditions) {
        Advancement.Builder builder = this.generateAdvancementBase(root, display, advancementId, frame, showToast, announceToChat, hidden);
        for (int i = 0; i < conditions.length; ++i) {
            builder.m_138386_("condition_" + i, (CriterionTriggerInstance)conditions[i]);
        }
        return builder.m_138389_(consumer, "soulsweapons:" + advancementId);
    }

    public Advancement generateAdvancementAcceptEither(Consumer<Advancement> consumer, String advancementId, Advancement root, Item display, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden, Item ... itemCondition) {
        Advancement.Builder builder = this.generateAdvancementBase(root, display, advancementId, frame, showToast, announceToChat, hidden);
        ArrayList<String> criteriaNames = new ArrayList<String>();
        for (Item item : itemCondition) {
            String itemName = item.toString();
            builder.m_138386_(itemName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
            criteriaNames.add(itemName);
        }
        builder.m_143951_((String[][])new String[][]{criteriaNames.toArray(new String[0])});
        return builder.m_138389_(consumer, "soulsweapons:" + advancementId);
    }

    public Advancement.Builder generateAdvancementBase(Advancement root, Item display, String advancementId, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(root).m_138371_((ItemLike)display, (Component)Component.m_237115_((String)("advancements.soulsweapons." + advancementId + ".title")), (Component)Component.m_237115_((String)("advancements.soulsweapons." + advancementId + ".description")), null, frame, showToast, announceToChat, hidden);
    }
}

