/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.soulsweaponry.datagen.advancements.AdvancementsProvider;
import net.soulsweaponry.datagen.loot_tables.BossLootTables;
import net.soulsweaponry.datagen.loot_tables.ChungusBarterLootTables;
import net.soulsweaponry.datagen.recipe.WeaponRecipeProvider;
import net.soulsweaponry.datagen.tags.EntityTagsProvider;
import net.soulsweaponry.datagen.worldgen.ModWorldGenProvider;

@Mod.EventBusSubscriber(modid="soulsweapons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BossLootTables::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(ChungusBarterLootTables::new, LootContextParamSets.f_81417_))));
        generator.addProvider(event.includeServer(), (DataProvider)new WeaponRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new EntityTagsProvider(output, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(output, event.getLookupProvider(), event.getExistingFileHelper(), List.of(new AdvancementsProvider())));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(output, lookupProvider));
    }
}

