/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.client.model.entity.mobs.NightProwlerModel;
import net.soulsweaponry.client.registry.RenderLayerRegistry;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Matrix4f;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class NightProwlerRenderer
extends GeoEntityRenderer<NightProwler> {
    int[] rgbColorOne = new int[]{54, 122, 156};
    int[] rgbColorTwo = new int[]{147, 188, 210};
    int[] rgbColorThree = new int[]{221, 255, 254};
    int[] rgbColorFour = new int[]{235, 185, 232};
    double[] translation = new double[]{0.0, 3.0, 0.0};

    public NightProwlerRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new NightProwlerModel());
        this.f_114477_ = 1.0f;
    }

    protected float getDeathMaxRotation(NightProwler entityLivingBaseIn) {
        return 0.0f;
    }

    public void render(NightProwler entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((LivingEntity)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        if (this.shouldRenderPortal(entity)) {
            stack.m_85836_();
            stack.m_252880_(0.0f, this.getBottomYOffset(), 0.0f);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            VertexConsumer vertexConsumer = bufferIn.m_6299_(this.getLayer());
            float radius = NightProwlerRenderer.calculatePortalRadius(16.0f, entity.getOpenPortalTicks(), partialTicks);
            int segments = 32;
            this.renderCircle(matrix, vertexConsumer, radius, segments);
            stack.m_85849_();
        }
    }

    public static float calculatePortalRadius(float maxRadius, float ticks, float partialTicks) {
        float smoothTicks = ticks + partialTicks;
        if (smoothTicks < 0.0f) {
            return 0.0f;
        }
        if (smoothTicks <= 30.0f) {
            return maxRadius * (smoothTicks / 30.0f);
        }
        if (smoothTicks <= 190.0f) {
            return maxRadius;
        }
        if (smoothTicks <= 200.0f) {
            return maxRadius * (1.0f - (smoothTicks - 190.0f) / 10.0f);
        }
        return 0.0f;
    }

    private void renderCircle(Matrix4f matrix, VertexConsumer vertexConsumer, float radius, int segments) {
        int rings = 8;
        float epsilon = 0.01f;
        for (int ring = 0; ring < rings; ++ring) {
            float innerRadius = ring == 0 ? epsilon : radius * (float)ring / (float)rings;
            float outerRadius = radius * (float)(ring + 1) / (float)rings;
            for (int seg = 0; seg < segments; ++seg) {
                double angle1 = Math.PI * 2 * (double)seg / (double)segments;
                double angle2 = Math.PI * 2 * (double)(seg + 1) / (double)segments;
                float innerX1 = (float)((double)innerRadius * Math.cos(angle1));
                float innerZ1 = (float)((double)innerRadius * Math.sin(angle1));
                float innerX2 = (float)((double)innerRadius * Math.cos(angle2));
                float innerZ2 = (float)((double)innerRadius * Math.sin(angle2));
                float outerX1 = (float)((double)outerRadius * Math.cos(angle1));
                float outerZ1 = (float)((double)outerRadius * Math.sin(angle1));
                float outerX2 = (float)((double)outerRadius * Math.cos(angle2));
                float outerZ2 = (float)((double)outerRadius * Math.sin(angle2));
                vertexConsumer.m_252986_(matrix, innerX1, 0.0f, innerZ1).m_5752_();
                vertexConsumer.m_252986_(matrix, outerX1, 0.0f, outerZ1).m_5752_();
                vertexConsumer.m_252986_(matrix, outerX2, 0.0f, outerZ2).m_5752_();
                vertexConsumer.m_252986_(matrix, innerX2, 0.0f, innerZ2).m_5752_();
            }
        }
    }

    public boolean shouldRender(NightProwler entity, Frustum frustum, double x, double y, double z) {
        return this.shouldRenderPortal(entity) || super.m_5523_((Entity)entity, frustum, x, y, z);
    }

    protected float getBottomYOffset() {
        return 8.0f;
    }

    protected RenderType getLayer() {
        return RenderLayerRegistry.NIGHT_PROWLER_PORTAL;
    }

    private boolean shouldRenderPortal(NightProwler entity) {
        return entity.getAttackAnimation().equals((Object)NightProwler.Attacks.ECLIPSE) && entity.getParticleState() == 4;
    }
}

