/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.registry;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.soulsweaponry.client.model.entity.mobs.BigChungusModel;
import net.soulsweaponry.client.model.entity.projectile.ChungusHeadModel;
import net.soulsweaponry.client.model.entity.projectile.DragonslayerSwordspearModel;

public class EntityModelLayerModRegistry {
    private static final CubeDeformation HAT_DILATION = new CubeDeformation(0.5f);
    private static final CubeDeformation ARMOR_DILATION = new CubeDeformation(1.0f);
    public static final ModelLayerLocation BIG_CHUNGUS_LAYER = EntityModelLayerModRegistry.createMain("big_chungus");
    public static final ModelLayerLocation DRAGONSLAYER_SWORDSPEAR_LAYER = EntityModelLayerModRegistry.createMain("swordspear_entity");
    public static final ModelLayerLocation DARK_SORCERER_LAYER = EntityModelLayerModRegistry.createMain("dark_sorcerer");
    public static final ModelLayerLocation FORLORN_LAYER = EntityModelLayerModRegistry.createMain("forlorn");
    public static final ModelLayerLocation REMNANT_LAYER = EntityModelLayerModRegistry.createMain("remnant");
    public static final ModelLayerLocation SOUL_REAPER_GHOST_LAYER = EntityModelLayerModRegistry.createMain("soul_reaper_ghost");
    public static final ModelLayerLocation CHUNGUS_HEAD_LAYER = EntityModelLayerModRegistry.createMain("chungus_head");
    public static final ModelLayerLocation DARK_SORCERER_INNER_ARMOR = EntityModelLayerModRegistry.createInnerArmor("dark_sorcerer");
    public static final ModelLayerLocation FORLORN_INNER_ARMOR = EntityModelLayerModRegistry.createInnerArmor("forlorn");
    public static final ModelLayerLocation REMNANT_INNER_ARMOR = EntityModelLayerModRegistry.createInnerArmor("remnant");
    public static final ModelLayerLocation SOUL_REAPER_GHOST_INNER_ARMOR = EntityModelLayerModRegistry.createInnerArmor("soul_reaper_ghost");
    public static final ModelLayerLocation DARK_SORCERER_OUTER_ARMOR = EntityModelLayerModRegistry.createOuterArmor("dark_sorcerer");
    public static final ModelLayerLocation FORLORN_OUTER_ARMOR = EntityModelLayerModRegistry.createOuterArmor("forlorn");
    public static final ModelLayerLocation REMNANT_OUTER_ARMOR = EntityModelLayerModRegistry.createOuterArmor("remnant");
    public static final ModelLayerLocation SOUL_REAPER_GHOST_OUTER_ARMOR = EntityModelLayerModRegistry.createOuterArmor("soul_reaper_ghost");

    public static void initClient(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DRAGONSLAYER_SWORDSPEAR_LAYER, DragonslayerSwordspearModel::getTexturedModelData);
        event.registerLayerDefinition(BIG_CHUNGUS_LAYER, BigChungusModel::getTexturedModelData);
        event.registerLayerDefinition(CHUNGUS_HEAD_LAYER, ChungusHeadModel::getTexturedModelData);
        EntityModelLayerModRegistry.registerBiped(event, DARK_SORCERER_LAYER);
        EntityModelLayerModRegistry.registerBiped(event, FORLORN_LAYER);
        EntityModelLayerModRegistry.registerBiped(event, REMNANT_LAYER);
        EntityModelLayerModRegistry.registerBiped(event, SOUL_REAPER_GHOST_LAYER);
        EntityModelLayerModRegistry.registerBipedInnerArmor(event, DARK_SORCERER_INNER_ARMOR);
        EntityModelLayerModRegistry.registerBipedInnerArmor(event, FORLORN_INNER_ARMOR);
        EntityModelLayerModRegistry.registerBipedInnerArmor(event, REMNANT_INNER_ARMOR);
        EntityModelLayerModRegistry.registerBipedInnerArmor(event, SOUL_REAPER_GHOST_INNER_ARMOR);
        EntityModelLayerModRegistry.registerBipedOuterArmor(event, DARK_SORCERER_OUTER_ARMOR);
        EntityModelLayerModRegistry.registerBipedOuterArmor(event, FORLORN_OUTER_ARMOR);
        EntityModelLayerModRegistry.registerBipedOuterArmor(event, REMNANT_OUTER_ARMOR);
        EntityModelLayerModRegistry.registerBipedOuterArmor(event, SOUL_REAPER_GHOST_OUTER_ARMOR);
    }

    private static ModelLayerLocation createOuterArmor(String id) {
        return EntityModelLayerModRegistry.create(id, "outer_armor");
    }

    private static ModelLayerLocation createInnerArmor(String id) {
        return EntityModelLayerModRegistry.create(id, "inner_armor");
    }

    private static ModelLayerLocation createMain(String id) {
        return EntityModelLayerModRegistry.create(id, "main");
    }

    private static ModelLayerLocation create(String id, String layer) {
        return new ModelLayerLocation(new ResourceLocation("soulsweapons", id), layer);
    }

    private static void registerBiped(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layer) {
        event.registerLayerDefinition(layer, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f), (int)64, (int)64));
    }

    private static void registerBipedInnerArmor(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layer) {
        event.registerLayerDefinition(layer, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)HAT_DILATION, (float)0.0f), (int)64, (int)32));
    }

    private static void registerBipedOuterArmor(EntityRenderersEvent.RegisterLayerDefinitions event, ModelLayerLocation layer) {
        event.registerLayerDefinition(layer, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)ARMOR_DILATION, (float)0.0f), (int)64, (int)32));
    }
}

