/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.blocks.entity.CrimsonObsidianBlockEntity;
import net.soulsweaponry.fluid.PurifiedBloodCauldronBlock;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class CrimsonObsidian
extends BaseEntityBlock {
    public static final VoxelShape DRIP_COLLISION_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public CrimsonObsidian(BlockBehaviour.Properties settings) {
        super(settings.m_60977_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_186460_(pos, (Block)this, 20 + random.m_188503_(40));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) == 0) {
            this.addParticles(world, random, pos, state, 1);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrimsonObsidianBlockEntity(pos, state);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        CrimsonObsidianBlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = (CrimsonObsidianBlockEntity)world.m_7702_(pos)) != null && !entity.m_6095_().m_204039_(ModTags.Entities.SKELETONS) && entity.m_6469_(world.m_269111_().m_269047_(), 1.0f)) {
            blockEntity.increaseBloodCount();
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.f_46443_) {
            BlockPos blockPos = CrimsonObsidian.getCauldronPos((Level)world, pos, (AbstractCauldronBlock)BlockRegistry.PURIFIED_BLOOD_CAULDRON.get());
            if (blockPos != null) {
                CrimsonObsidianBlockEntity blockEntity = (CrimsonObsidianBlockEntity)world.m_7702_(pos);
                BlockState blockState = world.m_8055_(blockPos);
                if (blockEntity != null && blockEntity.getBloodCount() >= 5) {
                    PurifiedBloodCauldronBlock cauldron;
                    if (blockState.m_60713_(Blocks.f_50256_)) {
                        world.m_46597_(blockPos, (BlockState)((PurifiedBloodCauldronBlock)((Object)BlockRegistry.PURIFIED_BLOOD_CAULDRON.get())).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                        this.addParticles((Level)world, random, pos, state, 8);
                    } else if (blockState.m_60713_((Block)BlockRegistry.PURIFIED_BLOOD_CAULDRON.get()) && !(cauldron = (PurifiedBloodCauldronBlock)blockState.m_60734_()).m_142596_(blockState) && blockEntity.dripBlood()) {
                        cauldron.incrementFluidLevel((Level)world, blockPos, blockState);
                        this.addParticles((Level)world, random, pos, state, 8);
                    }
                }
            }
            world.m_186460_(pos, (Block)this, 20 + random.m_188503_(40));
        }
    }

    private void addParticles(Level world, RandomSource random, BlockPos pos, BlockState state, int amount) {
        Direction direction = Direction.DOWN;
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = world.m_8055_(blockPos);
        if (!state.m_60815_() || !blockState.m_60783_((BlockGetter)world, blockPos, direction.m_122424_())) {
            for (int i = 0; i < amount; ++i) {
                double f;
                double d = direction.m_122429_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.6;
                double e = direction.m_122430_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.6;
                double d2 = f = direction.m_122431_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.6;
                if (world.f_46443_) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123801_, (double)pos.m_123341_() + d, (double)pos.m_123342_() + e, (double)pos.m_123343_() + f, 0.0, 0.0, 0.0);
                    continue;
                }
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123801_, (double)pos.m_123341_() + d, (double)pos.m_123342_() + e, (double)pos.m_123343_() + f, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public static BlockPos getCauldronPos(Level world, BlockPos pos, AbstractCauldronBlock acceptableCauldron) {
        Predicate<BlockState> predicate = state -> {
            AbstractCauldronBlock cauldron;
            Block patt0$temp = state.m_60734_();
            return patt0$temp instanceof AbstractCauldronBlock && ((cauldron = (AbstractCauldronBlock)patt0$temp).equals(acceptableCauldron) || cauldron.equals(Blocks.f_50256_));
        };
        BiPredicate<BlockPos, BlockState> biPredicate = (posx, state) -> CrimsonObsidian.canDripThrough((BlockGetter)world, posx, state);
        return CrimsonObsidian.searchInDirection((LevelAccessor)world, pos, Direction.DOWN.m_122421_(), biPredicate, predicate, 11).orElse(null);
    }

    public static boolean canDripThrough(BlockGetter world, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(world, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelShape = state.m_60812_(world, pos);
        return !Shapes.m_83157_((VoxelShape)DRIP_COLLISION_SHAPE, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_);
    }

    public static Optional<BlockPos> searchInDirection(LevelAccessor world, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction direction2 = Direction.m_122390_((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 1; i < range; ++i) {
            mutable.m_122173_(direction2);
            BlockState blockState = world.m_8055_((BlockPos)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.m_7949_());
            }
            if (!world.m_151562_(mutable.m_123342_()) && continuePredicate.test((BlockPos)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

