/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class BlackstonePedestal
extends Block
implements IConfigDisable {
    public BlackstonePedestal(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.spawnBoss(world, pos, player, itemStack)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean spawnBoss(Level world, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_150930_((Item)ItemRegistry.SHARD_OF_UNCERTAINTY.get())) {
            ChaosMonarch entity = new ChaosMonarch((EntityType<? extends BossEntity>)((EntityType)EntityRegistry.CHAOS_MONARCH.get()), world);
            entity.setAttack(1);
            return this.spawnEntity(world, pos, player, (LivingEntity)entity, ConfigConstructor.chaos_monarch_disable_respawn);
        }
        if (itemStack.m_150930_((Item)ItemRegistry.DEMON_CHUNK.get()) || itemStack.m_150930_((Item)ItemRegistry.WITHERED_DEMON_HEART.get())) {
            AccursedLordBoss entity = new AccursedLordBoss((EntityType<? extends AccursedLordBoss>)((EntityType)EntityRegistry.ACCURSED_LORD_BOSS.get()), world);
            entity.setAttackAnimation(AccursedLordBoss.AccursedLordAnimations.SPAWN);
            return this.spawnEntity(world, pos, player, (LivingEntity)entity, ConfigConstructor.decaying_king_disable_respawn);
        }
        return false;
    }

    private boolean spawnEntity(Level world, BlockPos pos, Player player, LivingEntity boss, boolean disableSpawn) {
        if (disableSpawn) {
            this.notifyDisabledBossRespawning((LivingEntity)player);
            return false;
        }
        boss.m_20343_((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.1f), (double)pos.m_123343_());
        world.m_5594_(null, pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        world.m_7967_((Entity)boss);
        world.m_7471_(pos, false);
        return true;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return false;
    }
}

