/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModTags;

public class AltarBlock
extends Block
implements IConfigDisable {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public AltarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.f_46443_ && random.m_188503_(5) < 2) {
            double e = 0.5;
            double d = 0.375;
            double f = 0.375;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() + f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() - d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() - f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() - f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() - d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() + f + e, 0.0, 0.0, 0.0);
            this.particleCircle(world, pos, 3, 4.0f);
            this.particlePentagram(world, pos, (ParticleOptions)this.getParticleType(), 4.0f);
        }
    }

    private void particleCircle(Level world, BlockPos pos, int spaceBetweenEach, float radius) {
        for (int theta = 0; theta < 360; theta += spaceBetweenEach) {
            float x0 = (float)pos.m_123341_() + 0.5f;
            float z0 = (float)pos.m_123343_() + 0.5f;
            double x = (double)x0 + (double)radius * Math.cos((double)theta * Math.PI / 180.0);
            double z = (double)z0 + (double)radius * Math.sin((double)theta * Math.PI / 180.0);
            world.m_7106_((ParticleOptions)this.getParticleType(), x, (double)((float)pos.m_123342_() + 0.2f), z, 0.0, 0.0, 0.0);
        }
    }

    private void particlePentagram(Level world, BlockPos pos, ParticleOptions particle, float radius) {
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.2;
        double centerZ = (double)pos.m_123343_() + 0.5;
        double[][] points = new double[5][2];
        for (int i = 0; i < 5; ++i) {
            double angle = Math.toRadians(72 * i - 90);
            points[i][0] = centerX + (double)radius * Math.cos(angle);
            points[i][1] = centerZ + (double)radius * Math.sin(angle);
        }
        int[] order = new int[]{0, 2, 4, 1, 3, 0};
        for (int i = 0; i < order.length - 1; ++i) {
            double startX = points[order[i]][0];
            double startZ = points[order[i]][1];
            double endX = points[order[i + 1]][0];
            double endZ = points[order[i + 1]][1];
            this.drawParticleLine(world, particle, startX, centerY, startZ, endX, endZ, 20);
        }
    }

    private void drawParticleLine(Level world, ParticleOptions particle, double x1, double y, double z1, double x2, double z2, int steps) {
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double x = x1 + t * (x2 - x1);
            double z = z1 + t * (z2 - z1);
            world.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private SimpleParticleType getParticleType() {
        return (SimpleParticleType)ParticleRegistry.NIGHTFALL_PARTICLE.get();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.spawnBoss(world, pos, player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean spawnBoss(Level world, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_204117_(ModTags.Items.LOST_SOUL)) {
            ReturningKnight entity = new ReturningKnight((EntityType<? extends ReturningKnight>)((EntityType)EntityRegistry.RETURNING_KNIGHT.get()), world);
            entity.setSpawning(true);
            boolean bl = this.spawnEntity(world, pos, player, (LivingEntity)entity, ConfigConstructor.returning_knight_disable_respawn);
            if (bl && !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return bl;
        }
        if (itemStack.m_150930_((Item)WeaponRegistry.DRAUGR.get())) {
            DraugrBoss entity = new DraugrBoss((EntityType<? extends DraugrBoss>)((EntityType)EntityRegistry.DRAUGR_BOSS.get()), world);
            entity.setSpawning();
            return this.spawnEntity(world, pos, player, (LivingEntity)entity, ConfigConstructor.old_champions_remains_disable_respawn);
        }
        if (itemStack.m_150930_((Item)ItemRegistry.ESSENCE_OF_EVENTIDE.get())) {
            Moonknight entity = new Moonknight((EntityType<? extends Monster>)((EntityType)EntityRegistry.MOONKNIGHT.get()), world);
            entity.setSpawning(true);
            boolean bl = this.spawnEntity(world, pos, player, (LivingEntity)entity, ConfigConstructor.fallen_icon_disable_respawn);
            if (bl && !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return bl;
        }
        return false;
    }

    private boolean spawnEntity(Level world, BlockPos pos, Player player, LivingEntity boss, boolean disableSpawn) {
        if (disableSpawn) {
            this.notifyDisabledBossRespawning((LivingEntity)player);
            return false;
        }
        boss.m_20343_((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.1f), (double)pos.m_123343_());
        world.m_5594_(null, pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        world.m_7967_((Entity)boss);
        world.m_7471_(pos, false);
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return false;
    }
}

