/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.trickweapon;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.SoulsWeaponry;
import org.jetbrains.annotations.Nullable;

public class TrickWeaponUtil {
    public static Map<ResourceLocation, ResourceLocation> itemMappings = new HashMap<ResourceLocation, ResourceLocation>();
    public static final String MAPPED_TRICK_WEAPON = "mapped_trick_weapon";

    public static void loadMappings(ResourceManager manager) {
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            HashMap<ResourceLocation, ResourceLocation> newMappings = new HashMap<ResourceLocation, ResourceLocation>();
            List resources = manager.m_213829_(new ResourceLocation("soulsweapons", "trickweapons/item_mappings.json"));
            boolean shouldReplace = false;
            for (Resource resource : resources) {
                InputStream stream = resource.m_215507_();
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    Map rawJson = (Map)gson.fromJson((Reader)reader, type);
                    Object replaceValue = rawJson.get("replace");
                    if (replaceValue instanceof Boolean && ((Boolean)replaceValue).booleanValue()) {
                        shouldReplace = true;
                        newMappings.clear();
                    }
                    for (Map.Entry entry : rawJson.entrySet()) {
                        if ("replace".equals(entry.getKey())) continue;
                        String key = (String)entry.getKey();
                        String value = entry.getValue().toString();
                        ResourceLocation keyId = ResourceLocation.m_135820_((String)key);
                        ResourceLocation valueId = ResourceLocation.m_135820_((String)value);
                        if (keyId != null && valueId != null) {
                            newMappings.put(keyId, valueId);
                            continue;
                        }
                        SoulsWeaponry.LOGGER.warn("Invalid identifier in item mappings: {}", entry);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            if (shouldReplace) {
                itemMappings.clear();
            }
            itemMappings.putAll(newMappings);
        }
        catch (Exception e) {
            SoulsWeaponry.LOGGER.error("Failed to load trick weapon item mappings.", (Throwable)e);
        }
    }

    public static void loadMappings(MinecraftServer server) {
        TrickWeaponUtil.loadMappings(server.m_177941_());
    }

    @Nullable
    public static Item getMappedItem(Item heldItem) {
        ResourceLocation heldItemId = ForgeRegistries.ITEMS.getKey((Object)heldItem);
        ResourceLocation itemId = itemMappings.get(heldItemId);
        if (itemId != null) {
            return (Item)ForgeRegistries.ITEMS.getValue(itemId);
        }
        return null;
    }

    @Nullable
    public static Item getMappedItem(ItemStack heldStack) {
        if (heldStack.m_41782_() && heldStack.m_41783_().m_128441_(MAPPED_TRICK_WEAPON)) {
            return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)heldStack.m_41783_().m_128461_(MAPPED_TRICK_WEAPON)));
        }
        return TrickWeaponUtil.getMappedItem(heldStack.m_41720_());
    }

    @Nullable
    public static Component getMappedItemName(ItemStack heldItem) {
        Item mappedItem = TrickWeaponUtil.getMappedItem(heldItem);
        if (mappedItem != null) {
            return mappedItem.m_41466_();
        }
        return null;
    }

    @Nullable
    public static ItemStack getMappedStack(ItemStack heldStack) {
        Item item = TrickWeaponUtil.getMappedItem(heldStack);
        if (item == null) {
            return null;
        }
        ItemStack stack = item.m_7968_();
        stack.m_41764_(heldStack.m_41613_());
        if (heldStack.m_41782_()) {
            stack.m_41751_(heldStack.m_41783_().m_6426_());
        }
        stack.m_41784_().m_128359_(MAPPED_TRICK_WEAPON, ForgeRegistries.ITEMS.getKey((Object)heldStack.m_41720_()).toString());
        return stack;
    }
}

