/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.soulsweaponry.api.entitystats.EntityStats;

public class EntityStatsUtil
implements PreparableReloadListener {
    private static final String FOLDER = "entitystats";
    private static final ResourceLocation ID = new ResourceLocation("soulsweapons", "entity_attributes");
    private static final Gson GSON = new Gson();
    private static final Map<ResourceLocation, EntityStats> statsMap = new HashMap<ResourceLocation, EntityStats>();

    public static Optional<EntityStats> getStats(ResourceLocation entityId) {
        return Optional.ofNullable(statsMap.get(entityId));
    }

    public static ResourceLocation getEntityIdentifier(Entity entity) {
        return BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
    }

    public static Optional<EntityStats> getStats(Entity entity) {
        return EntityStatsUtil.getStats(EntityStatsUtil.getEntityIdentifier(entity));
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager manager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> loadFuture = CompletableFuture.supplyAsync(() -> {
            HashMap newStats = new HashMap();
            manager.m_214159_(FOLDER, id -> id.m_135815_().endsWith(".json")).forEach((resId, resource) -> {
                String path = resId.m_135815_();
                String fileName = path.substring(FOLDER.length() + 1);
                String entityName = fileName.substring(0, fileName.length() - 5);
                ResourceLocation entityId = new ResourceLocation(resId.m_135827_(), entityName);
                try (InputStream stream = ((Resource)manager.m_213713_(resId).get()).m_215507_();
                     InputStreamReader reader = new InputStreamReader(stream);){
                    EntityStats stats = (EntityStats)GSON.fromJson(JsonParser.parseReader((Reader)reader), EntityStats.class);
                    newStats.put(entityId, stats);
                }
                catch (JsonSyntaxException | IOException e) {
                    System.err.println("Error loading entitystats JSON '" + String.valueOf(resId) + "': " + e.getMessage());
                }
            });
            return newStats;
        }, prepareExecutor);
        return loadFuture.thenComposeAsync(loaded -> synchronizer.m_6769_((Object)ID).thenRunAsync(() -> {
            statsMap.clear();
            statsMap.putAll((Map<ResourceLocation, EntityStats>)loaded);
        }, applyExecutor), applyExecutor);
    }

    public static float calculateResistance(float resistance, float amountToReduce) {
        return Math.round((double)amountToReduce * Math.pow(2.0, (double)(-resistance) * 0.01));
    }
}

