/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.soulsweaponry.api.entitystats.EntityStats;
import net.soulsweaponry.api.entitystats.EntityStatsUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.registry.AttributeRegistry;

public class EntityPosture {
    public static final int BASE_POSTURE = (int)ConfigConstructor.base_posture_unit;

    public static int getMaxPostureLoss(LivingEntity entity) {
        AttributeInstance inst;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().f_46443_) {
                return PostureData.getMaxPosture(player);
            }
        }
        Optional<EntityStats> op = EntityStatsUtil.getStats((Entity)entity);
        int base = BASE_POSTURE;
        if (op.isPresent()) {
            EntityStats stats = op.get();
            if (stats.max_posture_loss != 0.0f) {
                return Math.round(stats.max_posture_loss);
            }
            if (stats.base_posture_unit > 0.0f) {
                base = Math.round(stats.base_posture_unit);
            }
        }
        double bonus = (inst = entity.m_21051_((Attribute)AttributeRegistry.BASE_POSTURE_INCREASE.get())) != null ? inst.m_22135_() : 0.0;
        EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
        float volume = dimensions.f_20378_ * dimensions.f_20377_ * dimensions.f_20377_;
        int value = (int)((double)(base += (int)bonus) * (1.0 + Math.log1p(volume) / 3.5));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PostureData.updateMaxPosture(player, value);
        }
        return value;
    }

    public static boolean isPostureDisabled(LivingEntity entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((Entity)entity);
        if (op.isPresent()) {
            EntityStats stats = op.get();
            return stats.max_posture_loss < 0.0f || ConfigConstructor.disable_posture_mechanic_for_all_mobs;
        }
        return ConfigConstructor.disable_posture_mechanic_for_all_mobs;
    }

    public static int getPostureLoss(LivingEntity entity, int amount) {
        float resistance = EntityPosture.getPostureResistance(entity);
        return Math.round(EntityStatsUtil.calculateResistance(resistance, amount));
    }

    public static float getPostureResistance(LivingEntity entity) {
        float base = EntityStatsUtil.getStats((Entity)entity).map(s -> Float.valueOf(s.posture_loss_buildup_resistance)).orElse(Float.valueOf(ConfigConstructor.base_posture_buildup_resistance_unless_overridden)).floatValue();
        AttributeInstance inst = entity.m_21051_((Attribute)AttributeRegistry.POSTURE_BUILDUP_RESISTANCE.get());
        float bonus = inst != null ? (float)inst.m_22135_() : 0.0f;
        return base + bonus;
    }
}

