/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.entitystats;

import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.soulsweaponry.api.entitystats.EntityStats;
import net.soulsweaponry.api.entitystats.EntityStatsUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.registry.AttributeRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.ModTags;

public class EntityBleed {
    public static int getBleedBuildup(LivingEntity entity, int amount) {
        float resistance = EntityBleed.getBleedBuildupResistance(entity);
        return Math.round(EntityStatsUtil.calculateResistance(resistance, amount));
    }

    public static void triggerBloodLoss(LivingEntity entity) {
        entity.m_6469_(CustomDamageSource.create(entity.m_9236_(), CustomDamageSource.BLEED), EntityBleed.getBleedDamage(entity, ConfigConstructor.bleed_base_damage + entity.m_21233_() * ConfigConstructor.bleed_percent_health_damage));
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.BLOOD_LOSS.get(), entity.m_5720_(), 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), entity.m_20208_(0.5), entity.m_20227_(0.5) + entity.m_217043_().m_188500_() * 2.0 - 1.0, entity.m_20262_(0.5), 30, 0.0, 0.0, 0.0, 0.0);
        }
        BleedData.setBleed(entity, 0);
        for (Entity entity1 : entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82400_(20.0))) {
            if (!(entity1 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity1;
            for (InteractionHand hand : InteractionHand.values()) {
                if (!livingEntity.m_21120_(hand).m_150930_((Item)WeaponRegistry.BLOODLUST.get())) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, (int)ConfigConstructor.bloodlust_bloodloss_in_vicinity_gives_strength_amp));
            }
        }
    }

    public static int getMaxBleed(LivingEntity entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((Entity)entity);
        if (op.isPresent()) {
            EntityStats stats = op.get();
            int max = Math.round(stats.max_bleed);
            if (max != 0) {
                return max;
            }
        }
        return (int)ConfigConstructor.max_bleed;
    }

    public static float getBleedDamage(LivingEntity entity, float amount) {
        float resistance = EntityBleed.getBleedDamageResistance(entity);
        return EntityStatsUtil.calculateResistance(resistance, amount);
    }

    public static float getBleedBuildupResistance(LivingEntity entity) {
        float base = EntityStatsUtil.getStats((Entity)entity).map(s -> Float.valueOf(s.bleed_buildup_resistance)).orElse(Float.valueOf(ConfigConstructor.base_bleed_buildup_resistance_unless_overridden)).floatValue();
        AttributeInstance inst = entity.m_21051_((Attribute)AttributeRegistry.BLEED_BUILDUP_RESISTANCE.get());
        float bonus = inst != null ? (float)inst.m_22135_() : 0.0f;
        return base + bonus;
    }

    public static float getBleedDamageResistance(LivingEntity entity) {
        float base = EntityStatsUtil.getStats((Entity)entity).map(s -> Float.valueOf(s.bleed_damage_resistance)).orElse(Float.valueOf(ConfigConstructor.base_bleed_damage_resistance_unless_overridden)).floatValue();
        AttributeInstance inst = entity.m_21051_((Attribute)AttributeRegistry.BLEED_DAMAGE_RESISTANCE.get());
        float bonus = inst != null ? (float)inst.m_22135_() : 0.0f;
        return base + bonus;
    }

    public static boolean isBleedDisabled(LivingEntity entity) {
        Optional<EntityStats> op = EntityStatsUtil.getStats((Entity)entity);
        return entity.m_6095_().m_204039_(EntityTypeTags.f_13120_) || entity.m_6095_().m_204039_(ModTags.Entities.SKELETONS) || ConfigConstructor.disable_bleed_mechanic_for_all_mobs || op.isPresent() && op.get().max_bleed < 0.0f;
    }
}

