/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2hostility.compat.jei.ITraitLootRecipe;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.loot.MobCapLootCondition;
import dev.xkmc.l2hostility.init.loot.MobHealthCondition;
import dev.xkmc.l2hostility.init.loot.PlayerHasItemCondition;
import dev.xkmc.l2hostility.init.loot.TraitLootCondition;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2library.util.code.GenericItemStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraitLootModifier
extends LootModifier
implements ITraitLootRecipe {
    public static final Codec<TraitLootModifier> CODEC = RecordCodecBuilder.create(i -> TraitLootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)LHTraits.TRAITS.get().getCodec().optionalFieldOf("trait").forGetter(e -> Optional.ofNullable(e.trait)), (App)Codec.DOUBLE.fieldOf("chance").forGetter(e -> e.chance), (App)Codec.DOUBLE.fieldOf("rankBonus").forGetter(e -> e.rankBonus), (App)ItemStack.f_41582_.fieldOf("result").forGetter(e -> e.result))).apply((Applicative)i, TraitLootModifier::new));
    @Nullable
    public final MobTrait trait;
    public final double chance;
    public final double rankBonus;
    public final ItemStack result;

    public TraitLootModifier(MobTrait trait, double chance, double rankBonus, ItemStack result, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.trait = trait;
        this.chance = chance;
        this.rankBonus = rankBonus;
        this.result = result;
    }

    private TraitLootModifier(LootItemCondition[] conditionsIn, Optional<MobTrait> trait, double chance, double rankBonus, ItemStack result) {
        super(conditionsIn);
        this.trait = trait.orElse(null);
        this.chance = chance;
        this.rankBonus = rankBonus;
        this.result = result;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        Object object = context.m_165124_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)object;
            if (le.m_6095_().m_204039_(LHTagGen.NO_DROP)) {
                return list;
            }
            if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)le)) {
                MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)le);
                if (this.trait == null || cap.hasTrait(this.trait)) {
                    double factor = cap.dropRate;
                    if (context.m_78936_(LootContextParams.f_81456_)) {
                        Player player = (Player)context.m_165124_(LootContextParams.f_81456_);
                        PlayerDifficulty pl = (PlayerDifficulty)PlayerDifficulty.HOLDER.get(player);
                        for (GenericItemStack<CurseCurioItem> stack : CurseCurioItem.getFromPlayer((LivingEntity)player)) {
                            factor *= ((CurseCurioItem)stack.item()).getLootFactor(stack.stack(), pl, cap);
                        }
                    }
                    int lv = this.trait == null ? 0 : cap.getTraitLevel(this.trait);
                    double rate = this.chance + (double)lv * this.rankBonus;
                    int count = 0;
                    int i = 0;
                    while ((double)i < (double)this.result.m_41613_() * factor) {
                        if (context.m_230907_().m_188500_() < rate) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count > 0) {
                        ItemStack ans = this.result.m_41777_();
                        if (((Boolean)LHConfig.COMMON.nidhoggurCapAtItemMaxStack.get()).booleanValue()) {
                            count = Math.min(count, ans.m_41741_());
                        }
                        ans.m_41764_(count);
                        list.add((Object)ans);
                    }
                }
            }
        }
        return list;
    }

    public Codec<TraitLootModifier> codec() {
        return CODEC;
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public List<ItemStack> getResults() {
        return List.of(this.result);
    }

    @Override
    public List<ItemStack> getCurioRequired() {
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        if (((Boolean)LHConfig.COMMON.disableHostilityLootCurioRequirement.get()).booleanValue()) {
            return ans;
        }
        for (LootItemCondition c : this.getConditions()) {
            if (!(c instanceof PlayerHasItemCondition)) continue;
            PlayerHasItemCondition item = (PlayerHasItemCondition)c;
            ans.add(item.item.m_7968_());
        }
        return ans;
    }

    @Override
    public List<ItemStack> getInputs() {
        LinkedHashSet<MobTrait> set = new LinkedHashSet<MobTrait>();
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        if (this.trait != null) {
            set.add(this.trait);
        }
        for (LootItemCondition c : this.getConditions()) {
            if (!(c instanceof TraitLootCondition)) continue;
            TraitLootCondition cl = (TraitLootCondition)c;
            set.add(cl.trait);
        }
        for (MobTrait e : set) {
            ans.add(e.m_5456_().m_7968_());
        }
        return ans;
    }

    @Override
    public void addTooltip(List<Component> list) {
        int max = this.trait == null ? 0 : this.trait.getConfig().max_rank;
        int min = 1;
        int minLevel = 0;
        ArrayList<TraitLootCondition> other = new ArrayList<TraitLootCondition>();
        ArrayList<PlayerHasItemCondition> itemReq = new ArrayList<PlayerHasItemCondition>();
        ArrayList<MobHealthCondition> health = new ArrayList<MobHealthCondition>();
        for (LootItemCondition c : this.getConditions()) {
            if (c instanceof TraitLootCondition) {
                TraitLootCondition cl = (TraitLootCondition)c;
                if (cl.trait == this.trait) {
                    max = Math.min(max, cl.maxLevel);
                    min = Math.max(min, cl.minLevel);
                    continue;
                }
                other.add(cl);
                continue;
            }
            if (c instanceof MobCapLootCondition) {
                MobCapLootCondition cl = (MobCapLootCondition)c;
                minLevel = cl.minLevel;
                continue;
            }
            if (c instanceof PlayerHasItemCondition) {
                PlayerHasItemCondition cl = (PlayerHasItemCondition)c;
                itemReq.add(cl);
                continue;
            }
            if (!(c instanceof MobHealthCondition)) continue;
            MobHealthCondition cl = (MobHealthCondition)c;
            health.add(cl);
        }
        if (minLevel > 0) {
            list.add((Component)LangData.LOOT_MIN_LEVEL.get(Component.m_237113_((String)("" + minLevel)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        for (MobHealthCondition e : health) {
            list.add((Component)LangData.LOOT_MIN_HEALTH.get(Component.m_237113_((String)("" + e.minHealth)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (this.trait != null) {
            for (int lv = min; lv <= max; ++lv) {
                list.add((Component)LangData.LOOT_CHANCE.get(Component.m_237113_((String)(Math.round((this.chance + this.rankBonus * (double)lv) * 100.0) + "%")).m_130940_(ChatFormatting.AQUA), this.trait.getDesc().m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)("" + lv)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)LangData.LOOT_NO_TRAIT.get(Component.m_237113_((String)(Math.round(this.chance * 100.0) + "%")).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
        }
        for (TraitLootCondition c : other) {
            int cmin = Math.max(c.minLevel, 1);
            int cmax = Math.min(c.maxLevel, c.trait.getMaxLevel());
            String str = cmax == cmin ? "" + cmin : (cmax >= c.trait.getMaxLevel() ? cmin + "+" : cmin + "-" + cmax);
            list.add((Component)LangData.LOOT_OTHER_TRAIT.get(c.trait.getDesc().m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)str).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.RED));
        }
        for (PlayerHasItemCondition e : itemReq) {
            MutableComponent name = e.item.m_41466_().m_6881_().m_130940_(ChatFormatting.LIGHT_PURPLE);
            list.add((Component)LangData.TOOLTIP_JEI_REQUIRED.get(name).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

