/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.init.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2library.util.code.GenericItemStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EnvyLootModifier
extends LootModifier {
    public static final Codec<EnvyLootModifier> CODEC = RecordCodecBuilder.create(i -> EnvyLootModifier.codecStart((RecordCodecBuilder.Instance)i).apply((Applicative)i, EnvyLootModifier::new));

    public EnvyLootModifier(LootItemCondition ... conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        Object object = context.m_165124_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)object;
            if (le.m_6095_().m_204039_(LHTagGen.NO_DROP)) {
                return list;
            }
            if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)le)) {
                MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)le);
                double factor = cap.dropRate;
                if (context.m_78936_(LootContextParams.f_81456_)) {
                    Player player = (Player)context.m_165124_(LootContextParams.f_81456_);
                    PlayerDifficulty pl = (PlayerDifficulty)PlayerDifficulty.HOLDER.get(player);
                    for (GenericItemStack<CurseCurioItem> stack : CurseCurioItem.getFromPlayer((LivingEntity)player)) {
                        factor *= ((CurseCurioItem)stack.item()).getLootFactor(stack.stack(), pl, cap);
                    }
                }
                for (Map.Entry<MobTrait, Integer> entry : cap.traits.entrySet()) {
                    double chance = factor * (double)entry.getValue().intValue() * (Double)LHConfig.COMMON.envyDropRate.get();
                    if (!cap.fullDrop && !(context.m_230907_().m_188500_() < chance)) continue;
                    list.add((Object)entry.getKey().m_5456_().m_7968_());
                }
            }
        }
        return list;
    }

    public Codec<EnvyLootModifier> codec() {
        return CODEC;
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }
}

