/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.init;

import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2hostility.compat.gateway.GatewayConfigGen;
import dev.xkmc.l2hostility.compat.gateway.GatewayToEternityCompat;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapSyncToClient;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobCapSyncToClient;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.config.TraitConfig;
import dev.xkmc.l2hostility.content.config.WeaponConfig;
import dev.xkmc.l2hostility.content.config.WorldDifficultyConfig;
import dev.xkmc.l2hostility.events.LHAttackListener;
import dev.xkmc.l2hostility.init.advancements.HostilityTriggers;
import dev.xkmc.l2hostility.init.data.AdvGen;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHConfigGen;
import dev.xkmc.l2hostility.init.data.LHDamageTypes;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.data.RecipeGen;
import dev.xkmc.l2hostility.init.data.SlotGen;
import dev.xkmc.l2hostility.init.entries.LHRegistrate;
import dev.xkmc.l2hostility.init.loot.TraitGLMProvider;
import dev.xkmc.l2hostility.init.network.LootDataToClient;
import dev.xkmc.l2hostility.init.network.TraitEffectToClient;
import dev.xkmc.l2hostility.init.registrate.LHBlocks;
import dev.xkmc.l2hostility.init.registrate.LHEffects;
import dev.xkmc.l2hostility.init.registrate.LHEnchantments;
import dev.xkmc.l2hostility.init.registrate.LHEntities;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.compat.patchouli.PatchouliHelper;
import dev.xkmc.l2library.serial.config.ConfigTypeEntry;
import dev.xkmc.l2library.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2serial.network.SerialPacketBase;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2hostility")
@Mod.EventBusSubscriber(modid="l2hostility", bus=Mod.EventBusSubscriber.Bus.MOD)
public class L2Hostility {
    public static final String MODID = "l2hostility";
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig(new ResourceLocation("l2hostility", "main"), 1, new Function[]{e -> e.create(MobCapSyncToClient.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(TraitEffectToClient.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(LootDataToClient.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(ChunkCapSyncToClient.class, NetworkDirection.PLAY_TO_CLIENT)});
    public static final Logger LOGGER = LogManager.getLogger();
    public static final LHRegistrate REGISTRATE = new LHRegistrate("l2hostility");
    public static final ConfigTypeEntry<WorldDifficultyConfig> DIFFICULTY = new ConfigTypeEntry(HANDLER, "difficulty", WorldDifficultyConfig.class);
    public static final ConfigTypeEntry<TraitConfig> TRAIT = new ConfigTypeEntry(HANDLER, "trait", TraitConfig.class);
    public static final ConfigTypeEntry<WeaponConfig> WEAPON = new ConfigTypeEntry(HANDLER, "weapon", WeaponConfig.class);
    public static final ConfigTypeEntry<EntityConfig> ENTITY = new ConfigTypeEntry(HANDLER, "entity", EntityConfig.class);

    public static void init() {
        LHBlocks.register();
        LHItems.register();
        LHTraits.register();
        LHEntities.register();
        LHMiscs.register();
        LHConfig.init();
        LHDamageTypes.register();
        LHEnchantments.register();
        LHEffects.register();
        TraitGLMProvider.register();
        MobTraitCap.register();
        ChunkDifficulty.register();
        PlayerDifficulty.register();
        HostilityTriggers.register();
    }

    public L2Hostility() {
        L2Hostility.init();
        new PatchouliHelper((L2Registrate)REGISTRATE, "hostility_guide").buildModel().buildShapelessRecipe(e -> e.m_126209_((ItemLike)Items.f_42517_).m_126209_((ItemLike)Items.f_42583_).m_126209_((ItemLike)Items.f_42500_), () -> Items.f_42517_).buildBook("L2Hostility Guide", "Find out the mechanics and mob traits to know what to prepare for", 1, LHBlocks.TAB.getKey());
        AttackEventHandler.register((int)4500, (AttackListener)new LHAttackListener());
        if (ModList.get().isLoaded("gateways")) {
            MinecraftForge.EVENT_BUS.register(GatewayToEternityCompat.class);
        }
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)LHMiscs.ADD_LEVEL.get());
        event.add(EntityType.f_20532_, (Attribute)LHMiscs.ADD_SCALE.get());
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, LHTagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(LHTagGen.ENCH_TAGS, LHTagGen::onEnchTagGen);
        REGISTRATE.addDataGenerator(TagGen.EFF_TAGS, LHTagGen::onEffTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, LHTagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, LHTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(LHTraits.TRAIT_TAGS, LHTagGen::onTraitTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, AdvGen::genAdvancements);
        boolean server = event.includeServer();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        gen.addProvider(server, (DataProvider)new TraitGLMProvider(gen));
        gen.addProvider(server, (DataProvider)new SlotGen(gen));
        new LHDamageTypes(output, pvd, helper).generate(server, gen);
        if (ModList.get().isLoaded("gateways")) {
            gen.addProvider(server, (DataProvider)new GatewayConfigGen(gen));
        }
        gen.addProvider(server, (DataProvider)new LHConfigGen(gen));
    }

    public static void toTrackingChunk(LevelChunk chunk, SerialPacketBase packet) {
        L2Hostility.HANDLER.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)packet);
    }
}

