/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2damagetracker.init.data.ArmorEffectConfig;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.loot.TraitLootModifier;
import dev.xkmc.l2hostility.init.network.LootDataToClient;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.mixin.ForgeInternalHandlerAccessor;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="l2hostility", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobEvents {
    @SubscribeEvent
    public static void onMobAttack(LivingAttackEvent event) {
        boolean bypassInvul = event.getSource().m_269533_(DamageTypeTags.f_268738_);
        boolean bypassMagic = event.getSource().m_269533_(DamageTypeTags.f_268437_);
        boolean magic = event.getSource().m_269533_(L2DamageTypes.MAGIC);
        if (magic && !bypassInvul && !bypassMagic && CurioCompat.hasItemInCurio(event.getEntity(), (Item)LHItems.RING_DIVINITY.get())) {
            event.setCanceled(true);
            return;
        }
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)event.getEntity())) {
            ((MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)event.getEntity())).traitEvent((k, v) -> k.onAttackedByOthers((int)v, event.getEntity(), event));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMobHurt(LivingHurtEvent event) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)event.getEntity())) {
            ((MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)event.getEntity())).traitEvent((k, v) -> k.onHurtByOthers((int)v, event.getEntity(), event));
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        for (ItemStack e2 : CurioCompat.getItems(event.getEntity(), e -> e.m_41720_() instanceof CurseCurioItem)) {
            Item item = e2.m_41720_();
            if (!(item instanceof CurseCurioItem)) continue;
            CurseCurioItem curse = (CurseCurioItem)item;
            curse.onDamage(e2, event.getEntity(), event);
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        Mob mob;
        LivingEntity credit;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (credit = (mob = (Mob)livingEntity).m_21232_()) != null && CurioCompat.hasItemInCurio(credit, (Item)LHItems.CURSE_LUST.get())) {
            for (EquipmentSlot e : EquipmentSlot.values()) {
                mob.m_21409_(e, 1.0f);
            }
        }
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)event.getEntity())) {
            ((MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)event.getEntity())).traitEvent((k, v) -> k.onDeath((int)v, event.getEntity(), event));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMobDrop(LivingDropsEvent event) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)event.getEntity())) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)event.getEntity());
            if (cap.noDrop) {
                event.setCanceled(true);
                return;
            }
            LivingEntity killer = event.getEntity().m_21232_();
            if (killer != null && CurioCompat.hasItemInCurio(killer, (Item)LHItems.NIDHOGGUR.get())) {
                double val = (Double)LHConfig.COMMON.nidhoggurDropFactor.get() * (double)cap.getLevel();
                int count = (int)val;
                if (event.getEntity().m_217043_().m_188500_() < val - (double)count) {
                    ++count;
                }
                ++count;
                for (ItemEntity stack : event.getDrops()) {
                    int ans = stack.m_32055_().m_41613_() * count;
                    if (((Boolean)LHConfig.COMMON.nidhoggurCapAtItemMaxStack.get()).booleanValue()) {
                        ans = Math.min(stack.m_32055_().m_41741_(), ans);
                    }
                    stack.m_32055_().m_41764_(ans);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)event.getEntity())) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)event.getEntity());
            if (cap.noDrop) {
                event.setCanceled(true);
                return;
            }
            int exp = event.getDroppedExperience();
            int level = cap.getLevel();
            exp = (int)((double)exp * (1.0 + (Double)LHConfig.COMMON.expDropFactor.get() * (double)level));
            event.setDroppedExperience(exp);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPotionTest(MobEffectEvent.Applicable event) {
        Set config;
        LivingEntity entity = event.getEntity();
        if (CurioCompat.hasItemInCurio(entity, (Item)LHItems.CURSE_WRATH.get()) && (config = ArmorEffectConfig.get().getImmunity(LHItems.CURSE_WRATH.getId().toString())).contains(event.getEffectInstance().m_19544_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ArrayList<TraitLootModifier> list = new ArrayList<TraitLootModifier>();
        for (IGlobalLootModifier e : ForgeInternalHandlerAccessor.callGetLootModifierManager().getAllLootMods()) {
            if (!(e instanceof TraitLootModifier)) continue;
            TraitLootModifier loot = (TraitLootModifier)e;
            list.add(loot);
        }
        LootDataToClient packet = new LootDataToClient(list);
        if (event.getPlayer() == null) {
            L2Hostility.HANDLER.toAllClient((SimplePacketBase)packet);
        } else {
            L2Hostility.HANDLER.toClientPlayer((SimplePacketBase)packet, event.getPlayer());
        }
    }
}

