/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.consumable.BookCopy;
import dev.xkmc.l2hostility.content.item.wand.IMobClickItem;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHEffects;
import dev.xkmc.l2hostility.init.registrate.LHEnchantments;
import dev.xkmc.mob_weapon_api.example.vanilla.VanillaMobManager;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="l2hostility", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MiscHandlers {
    public static void copyCap(LivingEntity self, LivingEntity sub) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)self) && MobTraitCap.HOLDER.isProper((ICapabilityProvider)sub)) {
            MobTraitCap selfCap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)self);
            MobTraitCap subCap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)sub);
            subCap.copyFrom(self, sub, selfCap);
        }
    }

    @SubscribeEvent
    public static void onTargetCardClick(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getItemStack().m_41720_() instanceof IMobClickItem && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            event.setCancellationResult(event.getItemStack().m_41647_(event.getEntity(), le, event.getHand()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity ie;
        Entity e = event.getEntity();
        if (e instanceof ItemEntity && (ie = (ItemEntity)e).m_32055_().getEnchantmentLevel((Enchantment)LHEnchantments.VANISH.get()) > 0) {
            event.setCanceled(true);
        }
        if (e instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)e;
            if (e.m_19880_().contains("mob_weapon_api_applied")) {
                ItemStack stack = mob.m_21205_();
                VanillaMobManager.attachGoal((PathfinderMob)mob, (ItemStack)stack);
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilCraft(AnvilUpdateEvent event) {
        ItemStack copy = event.getLeft();
        ItemStack book = event.getRight();
        if (copy.m_41720_() instanceof BookCopy && book.m_41720_() instanceof EnchantedBookItem) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)book);
            int cost = 0;
            for (Map.Entry e : map.entrySet()) {
                cost += BookCopy.cost((Enchantment)e.getKey(), (Integer)e.getValue());
            }
            ItemStack result = book.m_41777_();
            if (!((Boolean)LHConfig.COMMON.bookOfReprintSpread.get()).booleanValue()) {
                result.m_41764_(book.m_41613_() + copy.m_41613_());
            }
            event.setOutput(result);
            event.setMaterialCost(book.m_41613_());
            event.setCost(cost);
        }
    }

    @SubscribeEvent
    public static void onAnvilTake(AnvilRepairEvent event) {
        ItemStack copy = event.getLeft();
        ItemStack book = event.getRight();
        if (copy.m_41720_() instanceof BookCopy && book.m_41720_() instanceof EnchantedBookItem && ((Boolean)LHConfig.COMMON.bookOfReprintSpread.get()).booleanValue()) {
            for (int i = 0; i < copy.m_41613_(); ++i) {
                ItemStack result = book.m_41777_();
                result.m_41764_(1);
                event.getEntity().m_150109_().m_150079_(result);
            }
        }
    }

    public static boolean useOnSkip(UseOnContext ctx, ItemStack stack) {
        Player player = ctx.m_43723_();
        if (player == null) {
            return false;
        }
        if (!ctx.m_43723_().m_21023_((MobEffect)LHEffects.ANTIBUILD.get())) {
            return false;
        }
        return stack.m_41720_() instanceof BlockItem || stack.m_204117_(LHTagGen.ANTIBUILD_BAN);
    }

    public static boolean predicateSlotValid(SlotContext slotContext, ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41737_("sealedItem") == null) {
            return false;
        }
        CompoundTag ctag = stack.m_41784_().m_128469_("sealedItem");
        ItemStack content = ItemStack.m_41712_((CompoundTag)ctag);
        return CuriosApi.isStackValid((SlotContext)slotContext, (ItemStack)content);
    }
}

