/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.enchantments.HitTargetEnchantment;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.HostilityDamageState;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2library.util.code.GenericItemStack;
import java.util.Map;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LHAttackListener
implements AttackListener {
    private static boolean masterImmunity(AttackCache cache) {
        Mob mob;
        LivingAttackEvent event = cache.getLivingAttackEvent();
        if (event != null && event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        MobTraitCap attacker = null;
        MobTraitCap target = null;
        LivingEntity livingEntity = cache.getAttacker();
        if (livingEntity instanceof Mob && MobTraitCap.HOLDER.isProper((ICapabilityProvider)(mob = (Mob)livingEntity))) {
            attacker = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
        }
        if ((livingEntity = cache.getAttackTarget()) instanceof Mob && MobTraitCap.HOLDER.isProper((ICapabilityProvider)(mob = (Mob)livingEntity))) {
            target = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
        }
        Mob attackerMaster = null;
        Mob targetMaster = null;
        if (attacker != null && attacker.asMinion != null) {
            attackerMaster = attacker.asMinion.master;
            if (cache.getAttackTarget() == attackerMaster) {
                return true;
            }
        }
        if (target != null && target.asMinion != null) {
            targetMaster = target.asMinion.master;
            if (cache.getAttacker() == targetMaster) {
                return true;
            }
        }
        if (attackerMaster != null && attackerMaster == targetMaster) {
            return true;
        }
        return target != null && target.isMasterProtected();
    }

    public void onAttack(AttackCache cache, ItemStack weapon) {
        LivingAttackEvent event = cache.getLivingAttackEvent();
        assert (event != null);
        if (LHAttackListener.masterImmunity(cache)) {
            event.setCanceled(true);
        }
    }

    public void onHurt(AttackCache cache, ItemStack weapon) {
        MobTraitCap cap;
        LivingEntity target;
        LivingHurtEvent event = cache.getLivingHurtEvent();
        assert (event != null);
        DamageSource source = event.getSource();
        if (source.m_269533_(L2DamageTypes.NO_SCALE)) {
            return;
        }
        LivingEntity mob = cache.getAttacker();
        if (mob == (target = cache.getAttackTarget())) {
            return;
        }
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)target)) {
            cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)target);
            for (Map.Entry e : weapon.getAllEnchantments().entrySet()) {
                Object k2 = e.getKey();
                if (!(k2 instanceof HitTargetEnchantment)) continue;
                HitTargetEnchantment ench = (HitTargetEnchantment)k2;
                ench.hitMob(target, cap, (Integer)e.getValue(), cache);
            }
        }
        if (mob != null && MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob)) {
            cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            if (!mob.m_6095_().m_204039_(LHTagGen.NO_SCALING)) {
                int lv = cap.getLevel();
                double factor = (Boolean)LHConfig.COMMON.exponentialDamage.get() != false ? Math.pow(1.0 + (Double)LHConfig.COMMON.damageFactor.get(), lv) - 1.0 : (double)lv * (Double)LHConfig.COMMON.damageFactor.get();
                EntityConfig.Config config = cap.getConfigCache(mob);
                if (config != null) {
                    factor *= config.attackScale;
                }
                double old = factor;
                for (Map.Entry<MobTrait, Integer> ent : cap.traits.entrySet()) {
                    factor *= ent.getKey().modifyBonusDamage(source, old, ent.getValue());
                }
                cache.addHurtModifier(DamageModifier.multTotal((float)(1.0f + (float)factor)));
            }
            TraitEffectCache traitCache = new TraitEffectCache(target);
            cap.traitEvent((k, v) -> k.onHurtTarget((int)v, mob, cache, traitCache));
        }
        if (mob != null) {
            for (GenericItemStack<CurseCurioItem> e : CurseCurioItem.getFromPlayer(mob)) {
                ((CurseCurioItem)e.item()).onHurtTarget(e.stack(), mob, cache);
            }
        }
    }

    public void onDamage(AttackCache cache, ItemStack weapon) {
        LivingEntity mob = cache.getAttackTarget();
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob)) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            cap.traitEvent((k, v) -> k.onDamaged((int)v, mob, cache));
        }
        if (LHAttackListener.masterImmunity(cache)) {
            cache.addDealtModifier(DamageModifier.nonlinearFinal((int)10432, e -> 0.0f));
        }
    }

    public void onCreateSource(CreateSourceEvent event) {
        DamageTypeWrapper type;
        LivingEntity mob = event.getAttacker();
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob)) {
            ((MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob)).traitEvent((k, v) -> k.onCreateSource((int)v, event.getAttacker(), event));
        }
        if ((type = event.getResult()) == null) {
            return;
        }
        DamageTypeWrapper root = type.toRoot();
        if (root == L2DamageTypes.MOB_ATTACK || root == L2DamageTypes.PLAYER_ATTACK) {
            if (CurioCompat.hasItemInCurioOrSlot(mob, (Item)LHItems.IMAGINE_BREAKER.get())) {
                event.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
            }
            if (CurioCompat.hasItemInCurio(mob, (Item)LHItems.PLATINUM_STAR.get())) {
                event.enable((DamageState)HostilityDamageState.BYPASS_COOLDOWN);
            }
        }
    }
}

