/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2library.util.Proxy;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ClientGlowingHandler {
    private static int cacheTick;
    private static boolean cacheGlass;

    public static boolean isGlowing(Entity entity) {
        MobTraitCap cap;
        Mob mob;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity le = (LivingEntity)entity;
        if (le instanceof Mob && (mob = (Mob)le).m_19880_().contains("HostilityGlowing") && MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob) && ((cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob)).isSummoned() || cap.isMasterProtected())) {
            return true;
        }
        if (le.m_9236_().m_5776_()) {
            return ClientGlowingHandler.isGlowingImpl(le);
        }
        return false;
    }

    private static boolean playerHasGlass(Player player) {
        if (player.f_19797_ == cacheTick) {
            return cacheGlass;
        }
        cacheGlass = CurioCompat.hasItemInCurioOrSlot((LivingEntity)player, (Item)LHItems.DETECTOR_GLASSES.get());
        cacheTick = player.f_19797_;
        return cacheGlass;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isGlowingImpl(LivingEntity entity) {
        LocalPlayer player = Proxy.getClientPlayer();
        if (player != null && ClientGlowingHandler.playerHasGlass((Player)player)) {
            if (((Boolean)LHConfig.CLIENT.glassForLevelMobsOnly.get()).booleanValue() && !MobTraitCap.HOLDER.shouldHaveCap((ICapabilityProvider)entity)) {
                return false;
            }
            boolean glow = entity.m_20145_() || entity.m_20177_((Player)player);
            glow |= player.m_21023_(MobEffects.f_19610_);
            float hidden = (float)((Integer)LHConfig.CLIENT.glowingRangeHidden.get()).intValue() + entity.m_20205_() * 2.0f;
            float near = (float)((Integer)LHConfig.CLIENT.glowingRangeNear.get()).intValue() + entity.m_20205_() * 2.0f;
            double distSqr = entity.m_20280_((Entity)player);
            return distSqr <= (double)(near * near) || (glow |= player.m_21023_(MobEffects.f_216964_)) && distSqr <= (double)(hidden * hidden);
        }
        return false;
    }

    @Nullable
    public static Integer getColor(Entity entity) {
        Mob mob;
        if (entity instanceof Mob && MobTraitCap.HOLDER.isProper((ICapabilityProvider)(mob = (Mob)entity))) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            if (cap.isSummoned()) {
                return 0xFF0000;
            }
            if (cap.isMasterProtected()) {
                return 0xFFAA00;
            }
        }
        return null;
    }
}

