/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapSyncToClient;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficultyCap;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="l2hostility", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    private static final Set<ChunkDifficulty> PENDING = new LinkedHashSet<ChunkDifficulty>();

    @SubscribeEvent
    public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(new ResourceLocation("l2hostility", "difficulty"), (ICapabilityProvider)new ChunkDifficultyCap((LevelChunk)event.getObject()));
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)entity2)) {
                    ((MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)entity2)).syncToPlayer(entity2, player);
                }
            }
        }
    }

    private static boolean initMob(LivingEntity mob, MobSpawnType type) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob)) {
            Optional<ChunkDifficulty> opt;
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            if (!mob.m_9236_().m_5776_() && !cap.isInitialized() && (opt = ChunkDifficulty.at(mob.m_9236_(), mob.m_20183_())).isPresent()) {
                cap.init(mob.m_9236_(), mob, opt.get());
                if (type == MobSpawnType.NATURAL && cap.shouldDiscard(mob)) {
                    return true;
                }
                if (type == MobSpawnType.SPAWNER) {
                    cap.dropRate = (Double)LHConfig.COMMON.dropRateFromSpawner.get();
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (CapabilityEvents.initMob((LivingEntity)mob, event.getSpawnType())) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public static void livingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob.f_19797_ % 10 == 0) {
            if (Float.isNaN(mob.m_21223_())) {
                mob.m_21153_(0.0f);
            }
            if (Float.isNaN(mob.m_6103_())) {
                mob.m_7911_(0.0f);
            }
        }
        if (mob.m_6084_()) {
            mob.getCapability(MobTraitCap.CAPABILITY).ifPresent(e -> e.tick(mob));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        OwnableEntity own;
        LivingEntity livingEntity;
        LivingEntity mob = event.getEntity();
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        LivingEntity killer = event.getEntity().m_21232_();
        Player player = null;
        if (killer instanceof Player) {
            Player pl;
            player = pl = (Player)killer;
        } else if (killer instanceof OwnableEntity && (livingEntity = (own = (OwnableEntity)killer).m_269323_()) instanceof Player) {
            Player pl;
            player = pl = (Player)livingEntity;
        }
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)mob)) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            if (killer != null) {
                cap.onKilled(mob, player);
            }
            if (player != null) {
                PlayerDifficulty playerDiff = (PlayerDifficulty)PlayerDifficulty.HOLDER.get(player);
                playerDiff.addKillCredit(cap);
                LevelChunk chunk = mob.m_9236_().m_46745_(mob.m_20183_());
                LazyOptional opt = chunk.getCapability(ChunkDifficulty.CAPABILITY);
                if (opt.resolve().isPresent()) {
                    ((ChunkDifficulty)opt.resolve().get()).addKillHistory(player, mob, cap);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ChunkDifficulty e : PENDING) {
            L2Hostility.toTrackingChunk(e.chunk, new ChunkCapSyncToClient(e));
        }
        PENDING.clear();
    }

    @SubscribeEvent
    public static void onStartTrackingChunk(ChunkWatchEvent.Watch event) {
        Optional opt = event.getChunk().getCapability(ChunkDifficulty.CAPABILITY).resolve();
        if (opt.isEmpty()) {
            return;
        }
        L2Hostility.HANDLER.toClientPlayer((SimplePacketBase)new ChunkCapSyncToClient((ChunkDifficulty)opt.get()), event.getPlayer());
    }

    public static void markDirty(ChunkDifficulty chunk) {
        PENDING.add(chunk);
    }
}

