/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.legendary;

import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.item.traits.SealedItem;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RagnarokTrait
extends LegendaryTrait {
    private static boolean allowSeal(EntitySlotAccess access) {
        ItemStack stack = access.get();
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_150930_((Item)LHItems.SEAL.get())) {
            return false;
        }
        if (stack.m_204117_(LHTagGen.NO_SEAL)) {
            return false;
        }
        if (!((Boolean)LHConfig.COMMON.ragnarokSealBackpack.get()).booleanValue()) {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (rl == null) {
                return false;
            }
            if (rl.toString().contains("backpack")) {
                return false;
            }
        }
        if (!((Boolean)LHConfig.COMMON.ragnarokSealSlotAdder.get()).booleanValue()) {
            return !CurioCompat.isSlotAdder(access);
        }
        return true;
    }

    public RagnarokTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        GeneralEventHandler.schedule(() -> this.sealItems(level, target));
    }

    public void sealItems(int level, LivingEntity target) {
        ArrayList<EntitySlotAccess> list = new ArrayList<EntitySlotAccess>(CurioCompat.getItemAccess(target).stream().filter(RagnarokTrait::allowSeal).toList());
        int count = Math.min(level, list.size());
        int time = (Integer)LHConfig.COMMON.ragnarokTime.get() * level;
        for (int i = 0; i < count; ++i) {
            int index = target.m_217043_().m_188503_(list.size());
            EntitySlotAccess slot = (EntitySlotAccess)list.remove(index);
            slot.modify(e -> SealedItem.sealItem(e, time));
        }
    }

    @Override
    public void addDetail(List<Component> list) {
        list.add((Component)Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(i -> Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.AQUA)), this.mapLevel(i -> Component.m_237113_((String)("" + Math.round((float)((Integer)LHConfig.COMMON.ragnarokTime.get() * i) / 20.0f))).m_130940_(ChatFormatting.AQUA))}).m_130940_(ChatFormatting.GRAY));
    }
}

