/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.legendary;

import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.content.item.traits.EnchantmentDisabler;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class DispellTrait
extends LegendaryTrait {
    public DispellTrait(ChatFormatting style) {
        super(style);
    }

    @Override
    public void onCreateSource(int level, LivingEntity attacker, CreateSourceEvent event) {
        if (event.getResult() == L2DamageTypes.MOB_ATTACK) {
            event.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
        }
    }

    @Override
    public double modifyBonusDamage(DamageSource source, double factor, int lv) {
        if (source.m_19385_().equals("mob") && source.m_269533_(DamageTypeTags.f_268437_)) {
            return (Double)LHConfig.COMMON.dispellDamageFactor.get();
        }
        return 1.0;
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = target.m_6844_(slot);
            if (!stack.m_41793_() || stack.m_41784_().m_128441_("l2hostility_enchantment")) continue;
            list.add(stack);
        }
        if (list.isEmpty()) {
            return;
        }
        int time = (Integer)LHConfig.COMMON.dispellTime.get() * level;
        int count = Math.min(level, list.size());
        for (int i = 0; i < count; ++i) {
            int index = attacker.m_217043_().m_188503_(list.size());
            EnchantmentDisabler.disableEnchantment(attacker.m_9236_(), (ItemStack)list.remove(index), time);
        }
    }

    @Override
    public void onAttackedByOthers(int level, LivingEntity entity, LivingAttackEvent event) {
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !event.getSource().m_269533_(DamageTypeTags.f_268437_) && event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
            event.setCanceled(true);
        }
    }

    @Override
    public void addDetail(List<Component> list) {
        list.add((Component)Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(i -> Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.AQUA)), this.mapLevel(i -> Component.m_237113_((String)("" + (Integer)LHConfig.COMMON.dispellTime.get() * i / 20)).m_130940_(ChatFormatting.AQUA))}).m_130940_(ChatFormatting.GRAY));
    }
}

