/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.highlevel;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.traits.EffectBooster;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.tags.ITagManager;

public class DrainTrait
extends MobTrait {
    public DrainTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void postInit(LivingEntity mob, int lv) {
        MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
        ITagManager manager = LHTraits.TRAITS.get().tags();
        if (manager == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            MobTrait trait;
            Optional opt = manager.getTag(LHTraits.POTION).getRandomElement(mob.m_217043_());
            if (opt.isEmpty() || !(trait = (MobTrait)((Object)opt.get())).allow(mob) || cap.hasTrait(trait)) continue;
            cap.setTrait(trait, lv);
            return;
        }
    }

    @Override
    public void onHurtTarget(int level, LivingEntity attacker, AttackCache cache, TraitEffectCache traitCache) {
        super.onHurtTarget(level, attacker, cache, traitCache);
        LivingEntity target = cache.getAttackTarget();
        long neg = target.m_21220_().stream().filter(e -> e.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).count();
        cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (Double)LHConfig.COMMON.drainDamage.get() * (double)level * (double)neg))));
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        ArrayList<MobEffectInstance> pos = new ArrayList<MobEffectInstance>(target.m_21220_().stream().filter(e -> e.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL).toList());
        for (int i = 0; i < level; ++i) {
            if (pos.isEmpty()) continue;
            MobEffectInstance ins = pos.remove(attacker.m_217043_().m_188503_(pos.size()));
            target.m_21195_(ins.m_19544_());
        }
        double factor = 1.0 + (Double)LHConfig.COMMON.drainDuration.get() * (double)level;
        int maxTime = level * (Integer)LHConfig.COMMON.drainDurationMax.get();
        EffectBooster.boostTrait(target, factor, maxTime);
    }

    @Override
    public void addDetail(List<Component> list) {
        list.add((Component)Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(i -> Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.AQUA)), this.mapLevel(i -> Component.m_237113_((String)(Math.round((double)i.intValue() * (Double)LHConfig.COMMON.drainDamage.get() * 100.0) + "%")).m_130940_(ChatFormatting.AQUA)), this.mapLevel(i -> Component.m_237113_((String)(Math.round((double)i.intValue() * (Double)LHConfig.COMMON.drainDuration.get() * 100.0) + "%")).m_130940_(ChatFormatting.AQUA)), this.mapLevel(i -> Component.m_237113_((String)("" + Math.round((float)(i * (Integer)LHConfig.COMMON.drainDurationMax.get()) / 20.0f))).m_130940_(ChatFormatting.AQUA))}).m_130940_(ChatFormatting.GRAY));
    }
}

