/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.goals;

import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class EnderTrait
extends LegendaryTrait {
    public EnderTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void tick(LivingEntity mob, int level) {
        Mob m;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        int duration = (Integer)LHConfig.COMMON.teleportDuration.get();
        int r = (Integer)LHConfig.COMMON.teleportRange.get();
        if (mob.f_19797_ % duration == 0 && mob instanceof Mob && (m = (Mob)mob).m_5448_() != null) {
            EntityTeleportEvent.EnderEntity event;
            Vec3 old = mob.m_20182_();
            Vec3 target = m.m_5448_().m_20182_();
            if (target.m_82554_(old) > (double)r) {
                target = target.m_82546_(old).m_82541_().m_82490_((double)r).m_82549_(old);
            }
            if ((event = ForgeEventFactory.onEnderTeleport((LivingEntity)m, (double)target.f_82479_, (double)target.f_82480_, (double)target.f_82481_)).isCanceled()) {
                return;
            }
            mob.m_6021_(target.m_7096_(), target.m_7098_(), target.m_7094_());
            if (!mob.m_9236_().m_45786_((Entity)mob)) {
                mob.m_6021_(old.m_7096_(), old.m_7098_(), old.m_7094_());
                return;
            }
            mob.m_9236_().m_214171_(GameEvent.f_238175_, m.m_20182_(), GameEvent.Context.m_223717_((Entity)mob));
            if (!mob.m_20067_()) {
                mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
                mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onAttackedByOthers(int level, LivingEntity entity, LivingAttackEvent event) {
        if (!(event.getSource().m_269533_(DamageTypeTags.f_268738_) || event.getSource().m_269533_(DamageTypeTags.f_268437_) || event.getSource().m_269533_(L2DamageTypes.MAGIC) || !EnderTrait.teleport(entity) && !event.getSource().m_269533_(DamageTypeTags.f_268524_))) {
            event.setCanceled(true);
        }
    }

    private static boolean teleport(LivingEntity entity) {
        int r = (Integer)LHConfig.COMMON.teleportRange.get();
        if (!entity.m_9236_().m_5776_() && entity.m_6084_() && r > 0) {
            double d0 = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)r * 2.0;
            double d1 = entity.m_20186_() + (double)(entity.m_217043_().m_188503_(r * 2) - r);
            double d2 = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)r * 2.0;
            return EnderTrait.teleport(entity, d0, d1, d2);
        }
        return false;
    }

    private static boolean teleport(LivingEntity entity, double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos ipos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (ipos.m_123342_() > entity.m_9236_().m_141937_() && !entity.m_9236_().m_8055_((BlockPos)ipos).m_280555_()) {
            ipos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = entity.m_9236_().m_8055_((BlockPos)ipos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)entity, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = entity.m_20182_();
            boolean flag2 = entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                entity.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                if (!entity.m_20067_()) {
                    entity.m_9236_().m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                    entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }
}

