/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.common;

import dev.xkmc.l2hostility.content.capability.mob.CapStorageData;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.entity.BulletType;
import dev.xkmc.l2hostility.content.entity.HostilityBullet;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.UUID;
import java.util.function.IntSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class ShulkerTrait
extends MobTrait {
    private final IntSupplier interval;
    private final BulletType type;
    private final int offset;

    public ShulkerTrait(ChatFormatting format, IntSupplier interval, BulletType type, int offset) {
        super(format);
        this.interval = interval;
        this.type = type;
        this.offset = offset;
    }

    @Override
    public void onAttackedByOthers(int level, LivingEntity entity, LivingAttackEvent event) {
        this.type.onAttackedByOthers(level, entity, event);
    }

    @Override
    public double modifyBonusDamage(DamageSource source, double factor, int lv) {
        if (source.m_7640_() instanceof HostilityBullet && source.m_269533_(DamageTypeTags.f_268415_)) {
            return (Double)LHConfig.COMMON.grenadeDamageFactor.get();
        }
        return 1.0;
    }

    @Override
    public void tick(LivingEntity e, int level) {
        Mob mob;
        if (e.m_9236_().m_5776_()) {
            return;
        }
        if (e instanceof Mob && MobTraitCap.HOLDER.isProper((ICapabilityProvider)(mob = (Mob)e))) {
            ServerLevel sl;
            Level level2;
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)mob);
            Data data = cap.getOrCreateData(this.getRegistryName(), Data::new);
            if (data.uuid != null && (level2 = mob.m_9236_()) instanceof ServerLevel && (sl = (ServerLevel)level2).m_8791_(data.uuid) instanceof ShulkerBullet) {
                return;
            }
            ++data.tickCount;
            if (data.tickCount < this.interval.getAsInt()) {
                return;
            }
            if ((mob.f_19797_ + this.offset) % this.interval.getAsInt() != 0) {
                return;
            }
            if (mob.m_5448_() != null && mob.m_5448_().m_6084_()) {
                HostilityBullet bullet = new HostilityBullet(mob.m_9236_(), (LivingEntity)mob, (Entity)mob.m_5448_(), Direction.Axis.Y, this.type, level);
                data.tickCount = 0;
                if (this.type.limit()) {
                    data.uuid = bullet.m_20148_();
                }
                mob.m_9236_().m_7967_((Entity)bullet);
                mob.m_5496_(SoundEvents.f_12417_, 2.0f, (mob.m_217043_().m_188501_() - mob.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public void addDetail(List<Component> list) {
        list.add((Component)Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{Component.m_237113_((String)("" + (double)this.interval.getAsInt() / 20.0)).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
    }

    @SerialClass
    public static class Data
    extends CapStorageData {
        @SerialClass.SerialField
        public int tickCount;
        @SerialClass.SerialField
        public UUID uuid;
    }
}

