/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.base;

import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeTrait
extends MobTrait {
    private final AttributeEntry[] entries;

    public AttributeTrait(ChatFormatting style, AttributeEntry ... entries) {
        super(style);
        this.entries = entries;
    }

    public AttributeTrait(IntSupplier color, AttributeEntry ... entries) {
        super(color);
        this.entries = entries;
    }

    @Override
    public void initialize(LivingEntity le, int level) {
        for (AttributeEntry e : this.entries) {
            TraitManager.addAttribute(le, e.attribute.get(), e.name(), e.factor.getAsDouble() * (double)level, e.op());
        }
    }

    @Override
    public void addDetail(List<Component> list) {
        for (AttributeEntry e : this.entries) {
            double val = e.factor.getAsDouble();
            if (val == 0.0) continue;
            list.add((Component)this.mapLevel(i -> (e.op == AttributeModifier.Operation.ADDITION ? Component.m_237113_((String)("+" + Math.round(val * (double)i.intValue()))) : Component.m_237113_((String)("+" + Math.round(val * (double)i.intValue() * 100.0) + "%"))).m_130940_(ChatFormatting.AQUA)).m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)e.attribute.get().m_22087_()).m_130940_(ChatFormatting.BLUE)));
        }
    }

    public record AttributeEntry(String name, Supplier<Attribute> attribute, DoubleSupplier factor, AttributeModifier.Operation op) {
    }
}

