/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import dev.xkmc.l2hostility.content.logic.ItemPopulator;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.logic.PlayerFinder;
import dev.xkmc.l2hostility.content.logic.TraitGenerator;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.HashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class TraitManager {
    public static void addAttribute(LivingEntity le, Attribute attr, String name, double factor, AttributeModifier.Operation op) {
        AttributeInstance ins = le.m_21051_(attr);
        if (ins == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(MathHelper.getUUIDFromString((String)name), name, factor, op);
        if (ins.m_22109_(modifier)) {
            ins.m_22120_(modifier.m_22209_());
        }
        ins.m_22125_(modifier);
    }

    public static void scale(MobTraitCap cap, LivingEntity le, int lv) {
        if (!le.m_6095_().m_204039_(LHTagGen.NO_SCALING)) {
            double factor = (Boolean)LHConfig.COMMON.exponentialHealth.get() != false ? Math.pow(1.0 + (Double)LHConfig.COMMON.healthFactor.get(), lv) - 1.0 : (double)lv * (Double)LHConfig.COMMON.healthFactor.get();
            EntityConfig.Config config = cap.getConfigCache(le);
            if (config != null) {
                factor *= config.healthScale;
            }
            TraitManager.addAttribute(le, Attributes.f_22276_, "hostility_health", factor, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    public static int fill(MobTraitCap cap, LivingEntity le, HashMap<MobTrait, Integer> traits, MobDifficultyCollector ins) {
        int lv = cap.clampLevel(le, ins.getDifficulty(le.m_217043_()));
        int ans = 0;
        if (ins.apply_chance() < le.m_217043_().m_188500_()) {
            return ans;
        }
        if (!le.m_6095_().m_204039_(LHTagGen.NO_SCALING)) {
            TraitManager.scale(cap, le, lv);
            ans = lv;
        }
        if (le.m_6095_().m_204039_(LHTagGen.ARMOR_TARGET)) {
            ServerPlayer sp;
            Player player = PlayerFinder.getNearestPlayer(le.m_9236_(), le);
            ItemPopulator.populateArmors(le, lv, player instanceof ServerPlayer ? (sp = (ServerPlayer)player) : null);
        }
        if (ins.trait_chance(lv) >= le.m_217043_().m_188500_()) {
            if (!le.m_6095_().m_204039_(LHTagGen.NO_TRAIT)) {
                TraitGenerator.generateTraits(cap, le, lv, traits, ins);
            }
            ans = lv;
        }
        le.m_21153_(le.m_21233_());
        return ans;
    }

    public static int getMaxLevel() {
        return 5;
    }

    public static int getTraitCap(int maxRankKilled, DifficultyLevel diff) {
        return maxRankKilled + 1;
    }
}

