/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

public class TraitGenerator {
    private final LivingEntity entity;
    private final int mobLevel;
    private final int maxTrait;
    private final MobDifficultyCollector ins;
    private final HashMap<MobTrait, Integer> traits;
    private final RandomSource rand;
    private final List<MobTrait> traitPool;
    private final boolean free;
    private int level;
    private int weights;

    public static void generateTraits(MobTraitCap cap, LivingEntity le, int lv, HashMap<MobTrait, Integer> traits, MobDifficultyCollector ins) {
        new TraitGenerator(cap, le, lv, traits, ins).generate();
    }

    private TraitGenerator(MobTraitCap cap, LivingEntity entity, int mobLevel, HashMap<MobTrait, Integer> traits, MobDifficultyCollector ins) {
        this.entity = entity;
        this.mobLevel = mobLevel;
        this.ins = ins;
        this.traits = traits;
        this.rand = entity.m_217043_();
        this.level = mobLevel;
        this.free = ins.trait_cost < 0.01;
        EntityConfig.Config config = cap.getConfigCache(entity);
        int max = (Integer)LHConfig.COMMON.maxTraitCount.get();
        if (config != null && config.maxTraitCount > 0) {
            max = config.maxTraitCount;
        }
        this.maxTrait = this.free ? -1 : (int)((double)max / ins.trait_cost);
        this.traitPool = new ArrayList<MobTrait>(LHTraits.TRAITS.get().getValues().stream().filter(e -> (config == null || !config.blacklist().contains(e)) && e.allow(entity, mobLevel, ins.getMaxTraitLevel())).toList());
        if (config != null) {
            for (EntityConfig.TraitBase base : config.traits()) {
                if (base.condition() != null && !base.condition().match(entity, mobLevel, ins)) continue;
                this.genBase(base);
            }
        }
        this.weights = 0;
        for (MobTrait e2 : this.traitPool) {
            this.weights += e2.getConfig().weight;
        }
    }

    private int getRank(MobTrait e) {
        return this.traits.getOrDefault((Object)e, 0);
    }

    private void setRank(MobTrait e, int rank) {
        if (rank == 0) {
            this.traits.remove((Object)e);
        } else {
            this.traits.put(e, rank);
        }
    }

    private MobTrait pop() {
        int val = this.rand.m_188503_(this.weights);
        MobTrait e = this.traitPool.get(0);
        for (MobTrait x : this.traitPool) {
            if ((val -= x.getConfig().weight) > 0) continue;
            e = x;
            break;
        }
        this.weights -= e.getConfig().weight;
        this.traitPool.remove((Object)e);
        return e;
    }

    private void genBase(EntityConfig.TraitBase base) {
        MobTrait e = base.trait();
        if (e == null) {
            return;
        }
        int maxTrait = TraitManager.getMaxLevel() + 1;
        if (!e.allow(this.entity, this.mobLevel, maxTrait)) {
            return;
        }
        int max = e.getMaxLevel();
        int cost = e.getCost(this.ins.trait_cost);
        int old = Math.min(e.getMaxLevel(), Math.max(this.getRank(e), base.free()));
        int expected = Math.min(max, Math.max(old, base.min()));
        int rank = Math.min(expected, old + this.level / cost);
        this.setRank(e, Math.max(old, rank));
        if (rank > old) {
            this.level -= (rank - old) * cost;
        }
        if (base.cap()) {
            this.traitPool.remove((Object)e);
        }
    }

    private void generate() {
        while (!(this.level <= 0 || this.traitPool.isEmpty() || this.maxTrait > 0 && this.traits.size() >= this.maxTrait)) {
            int rank;
            MobTrait e = this.pop();
            int cost = e.getCost(this.ins.trait_cost);
            if (cost > this.level) continue;
            int max = Math.min(this.ins.getMaxTraitLevel(), e.getMaxLevel());
            int old = Math.min(e.getMaxLevel(), this.getRank(e));
            int n = rank = this.free ? max : Math.min(max, old + this.rand.m_188503_(this.level / cost) + 1);
            if (rank <= old) continue;
            this.setRank(e, rank);
            this.level -= (rank - old) * cost;
            if (this.ins.isFullChance() || !(this.rand.m_188500_() < this.ins.suppression())) continue;
            break;
        }
        for (Map.Entry<MobTrait, Integer> e : this.traits.entrySet()) {
            e.getKey().initialize(this.entity, e.getValue());
        }
    }
}

