/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.config.WeaponConfig;
import dev.xkmc.l2hostility.content.logic.PlayerFinder;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.mob_weapon_api.example.vanilla.VanillaMobManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ItemPopulator {
    static void populateArmors(LivingEntity le, int lv, @Nullable ServerPlayer sp) {
        if (ItemPopulator.isApothBoss(le)) {
            return;
        }
        RandomSource r = le.m_217043_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !le.m_6844_(slot).m_41619_() || (stack = WeaponConfig.getRandomArmor(slot, lv, r, sp)).m_41619_()) continue;
            le.m_8061_(slot, stack);
            if (!(le instanceof Mob)) continue;
            Mob mob = (Mob)le;
            mob.m_21409_(slot, ((Double)LHConfig.COMMON.equipmentDropRate.get()).floatValue());
        }
    }

    static void populateWeapons(LivingEntity le, MobTraitCap cap, RandomSource r, @Nullable ServerPlayer sp) {
        PathfinderMob e;
        if (ItemPopulator.isApothBoss(le) || ItemPopulator.isApothWeapon(le.m_21205_())) {
            return;
        }
        ItemPopulator.populateSimpleWeapons(le, cap, r, sp);
        ArrayList<WeaponConfig.ItemConfig> list = new ArrayList<WeaponConfig.ItemConfig>();
        for (Map.Entry<LinkedHashSet<EntityType<?>>, ArrayList<WeaponConfig.ItemConfig>> ent : ((WeaponConfig)L2Hostility.WEAPON.getMerged()).special_weapons.entrySet()) {
            if (!ent.getKey().contains(le.m_6095_())) continue;
            for (WeaponConfig.ItemConfig e2 : ent.getValue()) {
                boolean nonEmpty = false;
                for (ItemStack stack : e2.stack()) {
                    nonEmpty |= !stack.m_41619_();
                }
                if (!nonEmpty) continue;
                list.add(e2);
            }
        }
        if (list.isEmpty()) {
            return;
        }
        list.add(WeaponConfig.ItemConfig.EMPTY);
        ItemStack stack = WeaponConfig.getRandomWeapon(list, cap.getLevel(), le.m_217043_(), sp);
        if (stack.m_41619_()) {
            return;
        }
        le.m_8061_(EquipmentSlot.MAINHAND, stack);
        if (le instanceof PathfinderMob && VanillaMobManager.attachGoal((PathfinderMob)(e = (PathfinderMob)le), (ItemStack)stack)) {
            e.m_20049_("mob_weapon_api_applied");
        }
        if (le instanceof Mob) {
            Mob mob = (Mob)le;
            mob.m_21409_(EquipmentSlot.MAINHAND, ((Double)LHConfig.COMMON.equipmentDropRate.get()).floatValue());
        }
    }

    static void populateSimpleWeapons(LivingEntity le, MobTraitCap cap, RandomSource r, @Nullable ServerPlayer sp) {
        ItemStack stack;
        ItemStack stack2;
        double factor;
        if (le instanceof Drowned && le.m_21205_().m_41619_() && (factor = (double)cap.getLevel() * (Double)LHConfig.COMMON.drownedTridentChancePerLevel.get()) > le.m_217043_().m_188500_()) {
            le.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42713_));
            return;
        }
        if (le.m_6095_().m_204039_(LHTagGen.MELEE_WEAPON_TARGET) && le.m_21205_().m_41619_() && !(stack2 = WeaponConfig.getRandomMeleeWeapon(cap.getLevel(), r, sp)).m_41619_()) {
            le.m_8061_(EquipmentSlot.MAINHAND, stack2);
            if (le instanceof Mob) {
                Mob mob = (Mob)le;
                mob.m_21409_(EquipmentSlot.MAINHAND, ((Double)LHConfig.COMMON.equipmentDropRate.get()).floatValue());
                return;
            }
        }
        if (le.m_6095_().m_204039_(LHTagGen.RANGED_WEAPON_TARGET) && !(stack = WeaponConfig.getRandomRangedWeapon(cap.getLevel(), r, sp)).m_41619_()) {
            le.m_8061_(EquipmentSlot.MAINHAND, stack);
            if (le instanceof Mob) {
                Mob mob = (Mob)le;
                mob.m_21409_(EquipmentSlot.MAINHAND, ((Double)LHConfig.COMMON.equipmentDropRate.get()).floatValue());
            }
        }
    }

    static void generateItems(MobTraitCap cap, LivingEntity le, EntityConfig.ItemPool pool) {
        if (cap.getLevel() < pool.level()) {
            return;
        }
        if (le.m_217043_().m_188501_() > pool.chance()) {
            return;
        }
        EntitySlotAccess slot = CurioCompat.decode(pool.slot(), le);
        if (slot == null) {
            return;
        }
        ArrayList<EntityConfig.ItemEntry> list = pool.entries();
        int total = 0;
        for (EntityConfig.ItemEntry e : list) {
            total += e.weight();
        }
        if (total <= 0) {
            return;
        }
        total = le.m_217043_().m_188503_(total);
        for (EntityConfig.ItemEntry e : list) {
            if ((total -= e.weight()) > 0) continue;
            slot.set(e.stack().m_41777_());
            return;
        }
    }

    public static void fillEnch(int level, RandomSource source, ItemStack stack, EquipmentSlot slot) {
        if (ItemPopulator.isApothWeapon(stack)) {
            return;
        }
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        if (slot == EquipmentSlot.OFFHAND) {
            return;
        }
        ArrayList<WeaponConfig.EnchConfig> list = slot == EquipmentSlot.MAINHAND ? config.weapon_enchantments : config.armor_enchantments;
        Map map = stack.getAllEnchantments();
        for (WeaponConfig.EnchConfig e : list) {
            int elv;
            int n = elv = e.level() <= 0 ? 1 : e.level();
            if (elv > level) continue;
            for (Enchantment ench : e.enchantments()) {
                if ((double)e.chance() < source.m_188500_() || !stack.canApplyAtEnchantingTable(ench) || !ItemPopulator.isValid(map.keySet(), ench)) continue;
                int max = Math.min(level / elv, ench.m_6586_());
                map.put(ench, Math.max(max, map.getOrDefault(ench, 0)));
            }
        }
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
    }

    private static boolean isValid(Set<Enchantment> old, Enchantment ench) {
        for (Enchantment other : old) {
            if (ench != other) continue;
            return true;
        }
        for (Enchantment other : old) {
            if (ench.m_44695_(other)) continue;
            return false;
        }
        return true;
    }

    public static void postFill(MobTraitCap cap, LivingEntity le) {
        ServerPlayer player;
        EquipmentSlot[] equipmentSlotArray = PlayerFinder.getNearestPlayer(le.m_9236_(), le);
        ServerPlayer sp = equipmentSlotArray instanceof ServerPlayer ? (player = (ServerPlayer)equipmentSlotArray) : null;
        RandomSource r = le.m_217043_();
        ItemPopulator.populateWeapons(le, cap, r, sp);
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = le.m_6844_(e);
            if (!stack.m_41792_()) continue;
            if (!stack.m_41793_()) {
                float lvl = Mth.m_14036_((float)((float)cap.getLevel() * 0.02f), (float)0.0f, (float)1.0f) * (float)r.m_188503_(30) + (float)cap.getEnchantBonus();
                stack = EnchantmentHelper.m_220292_((RandomSource)r, (ItemStack)stack, (int)((int)lvl), (boolean)false);
            }
            if (((Boolean)LHConfig.COMMON.allowExtraEnchantments.get()).booleanValue()) {
                ItemPopulator.fillEnch(cap.getLevel(), le.m_217043_(), stack, e);
            }
            le.m_8061_(e, stack);
        }
        EntityConfig.Config config = cap.getConfigCache(le);
        if (config != null && !config.items.isEmpty()) {
            for (EntityConfig.ItemPool pool : config.items) {
                ItemPopulator.generateItems(cap, le, pool);
            }
        }
    }

    private static boolean isApothBoss(LivingEntity mob) {
        return mob.getPersistentData().m_128471_("apoth.boss");
    }

    private static boolean isApothWeapon(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("apoth_boss");
    }
}

