/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.wand;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.wand.BaseWand;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TraitAdderWand
extends BaseWand {
    private static final String TRAIT = "l2hostility_trait";

    public static ItemStack set(ItemStack ans, MobTrait trait) {
        ans.m_41784_().m_128359_(TRAIT, trait.getID());
        return ans;
    }

    public static MobTrait get(ItemStack stack) {
        if (stack.m_41784_().m_128425_(TRAIT, 8)) {
            String str = stack.m_41784_().m_128461_(TRAIT);
            ResourceLocation id = new ResourceLocation(str);
            MobTrait ans = (MobTrait)((Object)LHTraits.TRAITS.get().getValue(id));
            if (ans != null) {
                return ans;
            }
        }
        return (MobTrait)((Object)LHTraits.TANK.get());
    }

    private static List<MobTrait> values() {
        return new ArrayList<MobTrait>(LHTraits.TRAITS.get().getValues());
    }

    private static MobTrait next(MobTrait mod) {
        List<MobTrait> list = TraitAdderWand.values();
        int index = list.indexOf((Object)mod);
        if (index + 1 >= list.size()) {
            return list.get(0);
        }
        return list.get(index + 1);
    }

    private static MobTrait prev(MobTrait mod) {
        List<MobTrait> list = TraitAdderWand.values();
        int index = list.indexOf((Object)mod);
        if (index == 0) {
            return list.get(list.size() - 1);
        }
        return list.get(index - 1);
    }

    @Nullable
    public static Integer decrease(MobTrait k, @Nullable Integer old) {
        if (old == null || old == 0) {
            return k.getMaxLevel();
        }
        if (old == 1) {
            return null;
        }
        return old - 1;
    }

    @Nullable
    public static Integer increase(MobTrait k, @Nullable Integer old) {
        if (old == null) {
            return 1;
        }
        if (old.intValue() == k.getMaxLevel()) {
            return null;
        }
        return old + 1;
    }

    public TraitAdderWand(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void clickTarget(ItemStack stack, Player player, LivingEntity target) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)target)) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)target);
            MobTrait trait = TraitAdderWand.get(stack);
            Integer ans = player.m_6144_() ? cap.traits.compute(trait, TraitAdderWand::decrease) : cap.traits.compute(trait, TraitAdderWand::increase);
            int val = ans == null ? 0 : ans;
            trait.initialize(target, val);
            trait.postInit(target, val);
            cap.syncToClient(target);
            target.m_21153_(target.m_21233_());
            player.m_213846_((Component)LangData.MSG_SET_TRAIT.get(trait.getDesc(), target.m_5446_(), val));
        }
    }

    @Override
    public void clickNothing(ItemStack stack, Player player) {
        MobTrait old = TraitAdderWand.get(stack);
        MobTrait next = player.m_6144_() ? TraitAdderWand.prev(old) : TraitAdderWand.next(old);
        TraitAdderWand.set(stack, next);
        player.m_213846_((Component)LangData.MSG_SELECT_TRAIT.get(next.getDesc()));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.ITEM_WAND_ADDER.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        MobTrait trait = TraitAdderWand.get(stack);
        list.add((Component)LangData.MSG_SELECT_TRAIT.get(trait.getDesc().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
    }
}

