/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.TraitConfig;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TraitSymbol
extends Item {
    private static boolean allow(Player player, MobTrait trait, LivingEntity target) {
        OwnableEntity own;
        if (!((Boolean)LHConfig.COMMON.allowPlayerAllies.get()).booleanValue() && target.m_7307_((Entity)player)) {
            return false;
        }
        if (!((Boolean)LHConfig.COMMON.allowTraitOnOwnable.get()).booleanValue() && target instanceof OwnableEntity && (own = (OwnableEntity)target).m_269323_() instanceof Player) {
            return false;
        }
        return trait.allow(target);
    }

    public TraitSymbol(Item.Properties properties) {
        super(properties);
    }

    public MobTrait get() {
        MobTrait ans = (MobTrait)((Object)LHTraits.TRAITS.get().getValue(ForgeRegistries.ITEMS.getKey((Object)this)));
        if (ans == null) {
            L2Hostility.LOGGER.error("------------");
            L2Hostility.LOGGER.error("Trait " + ForgeRegistries.ITEMS.getKey((Object)this) + " is not registered. Why?");
            Set set = LHTraits.TRAITS.get().getKeys();
            L2Hostility.LOGGER.error("List of all ids registered: ");
            for (ResourceLocation e : set) {
                L2Hostility.LOGGER.error(e.toString());
            }
            L2Hostility.LOGGER.error("------------");
        }
        assert (ans != null);
        return ans;
    }

    protected String m_41467_() {
        return Util.m_137492_((String)LHTraits.TRAITS.key().m_135782_().m_135815_(), (ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)this));
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (MobTraitCap.HOLDER.isProper((ICapabilityProvider)target)) {
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)target);
            MobTrait trait = this.get();
            if (!TraitSymbol.allow(player, trait, target)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.m_240418_((Component)LangData.MSG_ERR_DISALLOW.get(new Object[0]).m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (cap.getTraitLevel(trait) >= trait.getMaxLevel()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.m_240418_((Component)LangData.MSG_ERR_MAX.get(new Object[0]).m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (player.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            int val = cap.traits.compute(trait, (k, v) -> (v == null ? 0 : v) + 1);
            trait.initialize(target, val);
            trait.postInit(target, val);
            cap.syncToClient(target);
            target.m_21153_(target.m_21233_());
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_240418_((Component)LangData.MSG_SET_TRAIT.get(trait.getDesc(), target.m_5446_(), val), true);
                CriteriaTriggers.f_10592_.m_23682_(sp, stack);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)this.get().getFullDesc(null));
        if (this.get().isBanned()) {
            list.add((Component)LangData.TOOLTIP_BANNED.get(new Object[0]).m_130940_(ChatFormatting.RED));
            return;
        }
        if (this.get() instanceof LegendaryTrait) {
            list.add((Component)LangData.TOOLTIP_LEGENDARY.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        if (Screen.m_96638_()) {
            TraitConfig config = this.get().getConfig();
            list.add((Component)LangData.TOOLTIP_MIN_LEVEL.get(Component.m_237113_((String)("" + config.min_level)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            list.add((Component)LangData.TOOLTIP_LEVEL_COST.get(Component.m_237113_((String)("" + config.cost)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            list.add((Component)LangData.TOOLTIP_WEIGHT.get(Component.m_237113_((String)("" + config.weight)).m_130940_(ChatFormatting.DARK_AQUA)).m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            this.get().addDetail(list);
            list.add((Component)LangData.SHIFT.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }
}

