/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHEnchantments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentDisabler {
    private static final String ENCH = "Enchantments";
    private static final String ROOT = "l2hostility_enchantment";
    private static final String OLD = "originalEnchantments";
    private static final String TIME = "startTime";

    public static void disableEnchantment(Level level, ItemStack stack, int duration) {
        CompoundTag root = stack.m_41784_();
        if (!root.m_128425_(ENCH, 9)) {
            return;
        }
        double durability = stack.m_41776_() == 0 ? 0.0 : 1.0 * (double)stack.m_41773_() / (double)stack.m_41776_();
        CompoundTag tag = stack.m_41698_(ROOT);
        ListTag list = root.m_128437_(ENCH, 10);
        ListTag cache = new ListTag();
        list.removeIf(e -> {
            if (EnchantmentDisabler.noDispell(e)) {
                return false;
            }
            cache.add(e);
            return true;
        });
        tag.m_128365_(OLD, (Tag)cache);
        tag.m_128356_(TIME, level.m_46467_() + (long)duration);
        if (stack.m_41763_()) {
            stack.m_41721_(Mth.m_14045_((int)((int)Math.floor(durability * (double)stack.m_41776_())), (int)0, (int)(stack.m_41776_() - 1)));
        }
    }

    private static boolean noDispell(Tag e) {
        if (!(e instanceof CompoundTag)) {
            return false;
        }
        CompoundTag c = (CompoundTag)e;
        ResourceLocation id = new ResourceLocation(c.m_128461_("id"));
        return ForgeRegistries.ENCHANTMENTS.tags().getTag(LHTagGen.NO_DISPELL).contains((Object)((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id)));
    }

    public static void tickStack(Level level, Entity user, ItemStack stack) {
        if (level.m_5776_()) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!player.m_150110_().f_35937_ && stack.m_41793_() && stack.getEnchantmentLevel((Enchantment)LHEnchantments.VANISH.get()) > 0) {
                stack.m_41764_(0);
                return;
            }
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_(ROOT, 10)) {
            return;
        }
        CompoundTag root = stack.m_41784_();
        CompoundTag tag = stack.m_41698_(ROOT);
        long time = tag.m_128454_(TIME);
        if (level.m_46467_() >= time) {
            stack.m_41783_().m_128473_(ROOT);
            ListTag list = root.m_128437_(ENCH, 10);
            ListTag cache = tag.m_128437_(OLD, 10);
            cache.addAll((Collection)list);
            stack.m_41783_().m_128365_(ENCH, (Tag)cache);
        }
    }

    public static void modifyTooltip(ItemStack stack, List<Component> tooltip, Level level) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_(ROOT, 10)) {
            return;
        }
        CompoundTag tag = stack.m_41698_(ROOT);
        long time = Math.max(0L, tag.m_128454_(TIME) - level.m_46467_());
        ListTag list = tag.m_128437_(OLD, 10);
        tooltip.add((Component)LangData.TOOLTIP_DISABLE.get(Component.m_237113_((String)("" + list.size())).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)("" + time / 20L)).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.RED));
        ArrayList disabled = new ArrayList();
        ItemStack.m_41709_(disabled, (ListTag)list);
        for (Component e : disabled) {
            tooltip.add((Component)e.m_6881_().m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

