/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.spawner;

import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerBlock;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerData;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@SerialClass
public abstract class TraitSpawnerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    @SerialClass.SerialField
    public final TraitSpawnerData data = new TraitSpawnerData();
    @Nullable
    protected CustomBossEvent event;

    public TraitSpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.m_58900_().m_61143_(TraitSpawnerBlock.STATE) == TraitSpawnerBlock.State.ACTIVATED) {
            this.data.init(this.f_58857_);
            TraitSpawnerBlock.State next = this.data.tick();
            if (next == TraitSpawnerBlock.State.FAILED) {
                this.stop();
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(TraitSpawnerBlock.STATE, (Comparable)((Object)TraitSpawnerBlock.State.FAILED)));
                return;
            }
            if (next == TraitSpawnerBlock.State.CLEAR) {
                this.clearStage();
                this.stop();
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(TraitSpawnerBlock.STATE, (Comparable)((Object)TraitSpawnerBlock.State.CLEAR)));
                return;
            }
            if (this.event == null) {
                this.event = this.createBossEvent();
            }
            int max = this.data.getMax();
            int alive = this.data.getAlive();
            this.event.m_136278_(max);
            this.event.m_136264_(alive);
            this.event.m_6456_((Component)LangData.BOSS_EVENT.get(max - alive, max).m_130940_(ChatFormatting.GOLD));
            HashSet<ServerPlayer> set = new HashSet<ServerPlayer>();
            for (ServerPlayer e : this.event.m_8324_()) {
                if (!(e.m_20238_(Vec3.m_82512_((Vec3i)this.m_58899_())) > 1024.0)) continue;
                set.add(e);
            }
            for (ServerPlayer e : set) {
                this.event.m_6539_(e);
            }
        }
    }

    public void activate() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.data.stop();
        if (this.event != null) {
            this.event.m_7706_();
        }
        this.event = this.createBossEvent();
        this.generate(this.data);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(TraitSpawnerBlock.STATE, (Comparable)((Object)TraitSpawnerBlock.State.ACTIVATED)));
    }

    public void m_7651_() {
        if (this.event != null) {
            this.event.m_7706_();
        }
        super.m_7651_();
    }

    public void stop() {
        if (this.event != null) {
            this.event.m_7706_();
            this.event = null;
        }
        this.data.stop();
    }

    public void deactivate() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.stop();
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(TraitSpawnerBlock.STATE, (Comparable)((Object)TraitSpawnerBlock.State.IDLE)));
    }

    protected abstract void generate(TraitSpawnerData var1);

    protected abstract void clearStage();

    protected abstract CustomBossEvent createBossEvent();

    public void track(Player player) {
        if (this.event != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.event.m_6543_(sp);
        }
    }
}

