/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.spawner;

import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerBlockEntity;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerData;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

@SerialClass
public class BurstSpawnerBlockEntity
extends TraitSpawnerBlockEntity {
    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel level, MobCategory category, BlockPos pos) {
        StructureManager structure = level.m_215010_();
        ChunkGenerator chunkGen = level.m_7726_().m_8481_();
        Holder biome = level.m_204166_(pos);
        return ForgeEventFactory.getPotentialSpawns((LevelAccessor)level, (MobCategory)category, (BlockPos)pos, (WeightedRandomList)chunkGen.m_223133_(biome, structure, category, pos));
    }

    public static int getSpawnGroup() {
        return (Integer)LHConfig.COMMON.hostilitySpawnCount.get();
    }

    public static double getBonusFactor() {
        return ((Integer)LHConfig.COMMON.hostilitySpawnLevelFactor.get()).intValue();
    }

    public static int getMaxTrials() {
        return 4;
    }

    public BurstSpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void generate(TraitSpawnerData data) {
        BurstSpawnerBlockEntity other;
        BlockEntity blockEntity;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Optional<ChunkDifficulty> cdcap = ChunkDifficulty.at(this.f_58857_, this.m_58899_());
        if (cdcap.isEmpty()) {
            return;
        }
        SectionDifficulty sec = cdcap.get().getSection(this.m_58899_().m_123342_());
        if (sec.activePos != null && this.f_58857_.m_46749_(sec.activePos) && (blockEntity = this.f_58857_.m_7702_(sec.activePos)) instanceof BurstSpawnerBlockEntity && (other = (BurstSpawnerBlockEntity)blockEntity) != this) {
            other.stop();
        }
        sec.activePos = this.m_58899_();
        int count = 0;
        for (int i = 0; i < BurstSpawnerBlockEntity.getSpawnGroup() * BurstSpawnerBlockEntity.getMaxTrials(); ++i) {
            LivingEntity le;
            Entity entity;
            int x = this.f_58857_.m_213780_().m_188503_(16);
            int y = this.f_58857_.m_213780_().m_188503_(16);
            int z = this.f_58857_.m_213780_().m_188503_(16);
            BlockPos pos = new BlockPos(this.m_58899_().m_123341_() & 0xFFFFFFF8 | x, this.m_58899_().m_123342_() & 0xFFFFFFF8 | y, this.m_58899_().m_123343_() & 0xFFFFFFF8 | z);
            Optional e = BurstSpawnerBlockEntity.mobsAt(sl, MobCategory.MONSTER, pos).m_216829_(this.f_58857_.m_213780_());
            if (!e.isPresent() || ((MobSpawnSettings.SpawnerData)e.get()).f_48404_.m_204039_(LHTagGen.HOSTILITY_SPAWNER_BLACKLIST) || (entity = ((MobSpawnSettings.SpawnerData)e.get()).f_48404_.m_20615_((Level)sl)) == null || entity instanceof Creeper) continue;
            entity.m_146884_(Vec3.m_82512_((Vec3i)this.m_58899_()));
            if (!(entity instanceof LivingEntity) || !MobTraitCap.HOLDER.isProper((ICapabilityProvider)(le = (LivingEntity)entity))) continue;
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)le);
            cap.summoned = true;
            cap.noDrop = true;
            cap.pos = this.m_58899_();
            cap.init(this.f_58857_, le, (a, b) -> {
                ((ChunkDifficulty)cdcap.get()).modifyInstance(a, b);
                b.acceptBonusFactor(BurstSpawnerBlockEntity.getBonusFactor());
                b.setFullChance();
            });
            entity.m_146884_(Vec3.m_82512_((Vec3i)this.m_58899_().m_7494_()));
            data.add(le);
            this.f_58857_.m_7967_(entity);
            if (++count >= BurstSpawnerBlockEntity.getSpawnGroup()) break;
        }
    }

    @Override
    protected void clearStage() {
        assert (this.f_58857_ != null);
        Optional<ChunkDifficulty> cdcap = ChunkDifficulty.at(this.f_58857_, this.m_58899_());
        if (cdcap.isPresent()) {
            SectionDifficulty section = cdcap.get().getSection(this.m_58899_().m_123342_());
            section.setClear(cdcap.get(), this.m_58899_());
            section.activePos = null;
        }
    }

    @Override
    protected CustomBossEvent createBossEvent() {
        CustomBossEvent ans = new CustomBossEvent(new ResourceLocation("l2hostility", "hostility_spawner"), (Component)LangData.BOSS_EVENT.get(0, BurstSpawnerBlockEntity.getSpawnGroup()).m_130940_(ChatFormatting.GOLD));
        ans.m_6451_(BossEvent.BossBarColor.PURPLE);
        ans.m_5648_(BossEvent.BossBarOverlay.NOTCHED_10);
        return ans;
    }
}

