/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.curio.misc;

import dev.xkmc.l2complements.content.item.curios.CurioItem;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.item.traits.SealedItem;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class PocketOfRestoration
extends CurioItem
implements ICurioItem {
    public static final String ROOT = "UnsealRoot";
    public static final String KEY = "SealedSlotKey";
    public static final String START = "UnsealStartTime";

    public static void setData(ItemStack stack, ItemStack sealed, String id, long time) {
        Tag data = sealed.m_41784_().m_128423_("sealedItem");
        if (data == null) {
            return;
        }
        CompoundTag tag = stack.m_41698_(ROOT);
        tag.m_128405_("sealTime", sealed.m_41784_().m_128451_("sealTime"));
        tag.m_128365_("sealedItem", data);
        tag.m_128359_(KEY, id);
        tag.m_128356_(START, time);
    }

    public PocketOfRestoration(Item.Properties properties, int durability) {
        super(properties, durability);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity le = slotContext.entity();
        if (le.m_9236_().f_46443_) {
            return;
        }
        if (!slotContext.entity().m_6084_()) {
            return;
        }
        List<EntitySlotAccess> list = CurioCompat.getItemAccess(le);
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(ROOT)) {
            CompoundTag tag = stack.m_41698_(ROOT);
            long time = tag.m_128454_(START);
            int dur = tag.m_128451_("sealTime");
            if (le.m_9236_().m_46467_() >= time + (long)dur) {
                Player player;
                ItemStack result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("sealedItem"));
                EntitySlotAccess slot = CurioCompat.decode(tag.m_128461_(KEY), le);
                if (slot != null && slot.get().m_41619_()) {
                    slot.set(result);
                    stack.m_41783_().m_128473_(ROOT);
                } else if (le instanceof Player && (player = (Player)le).m_36356_(result)) {
                    stack.m_41783_().m_128473_(ROOT);
                }
            }
            return;
        }
        if (stack.m_41773_() + 1 >= stack.m_41776_()) {
            return;
        }
        for (EntitySlotAccess e : list) {
            if (!(e.get().m_41720_() instanceof SealedItem)) continue;
            ItemStack sealed = e.get();
            e.set(ItemStack.f_41583_);
            String id = e.getID();
            long time = le.m_9236_().m_46467_();
            stack.m_41622_(1, le, x -> {});
            PocketOfRestoration.setData(stack, sealed, id, time);
            return;
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.POCKET_OF_RESTORATION.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(ROOT)) {
            list.add((Component)LangData.TOOLTIP_SEAL_DATA.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
            list.add(ItemStack.m_41712_((CompoundTag)stack.m_41698_(ROOT).m_128469_("sealedItem")).m_41786_());
        }
    }
}

