/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.curio.curse;

import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.init.data.ArmorEffectConfig;
import dev.xkmc.l2damagetracker.init.data.L2DTLangData;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CurseOfWrath
extends CurseCurioItem {
    public CurseOfWrath(Item.Properties props) {
        super(props);
    }

    @Override
    public int getExtraLevel() {
        return (Integer)LHConfig.COMMON.wrathExtraLevel.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        String rate = LangData.perc((Double)LHConfig.COMMON.wrathDamageBonus.get());
        list.add((Component)LangData.ITEM_CHARM_WRATH.get(rate).m_130940_(ChatFormatting.GOLD));
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this);
        assert (id != null);
        this.addTooltip(list, ArmorEffectConfig.get().getImmunity(id.toString()));
    }

    @Override
    public void onHurtTarget(ItemStack stack, LivingEntity user, AttackCache cache) {
        int level = DifficultyLevel.ofAny(cache.getAttackTarget()) - DifficultyLevel.ofAny(user);
        if (level > 0) {
            double rate = (Double)LHConfig.COMMON.wrathDamageBonus.get();
            cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (double)level * rate))));
        }
    }

    private void addTooltip(List<Component> list, Set<MobEffect> set) {
        TreeMap<ResourceLocation, MobEffect> map = new TreeMap<ResourceLocation, MobEffect>();
        for (MobEffect e : set) {
            map.put(ForgeRegistries.MOB_EFFECTS.getKey((Object)e), e);
        }
        MutableComponent comp = L2DTLangData.ARMOR_IMMUNE.get(new Object[0]);
        boolean comma = false;
        for (MobEffect e : map.values()) {
            if (comma) {
                comp = comp.m_130946_(", ");
            }
            comp = comp.m_7220_((Component)Component.m_237115_((String)e.m_19481_()).m_130940_(e.m_19483_().m_19497_()));
            comma = true;
        }
        list.add((Component)comp.m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

