/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.curio.curse;

import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class CurseOfPride
extends CurseCurioItem {
    private static final String NAME = "l2hostility:pride";
    private static final UUID ID = MathHelper.getUUIDFromString((String)"l2hostility:pride");

    public CurseOfPride(Item.Properties props) {
        super(props);
    }

    @Override
    public void onHurtTarget(ItemStack stack, LivingEntity user, AttackCache cache) {
        int level = DifficultyLevel.ofAny(user);
        double rate = (Double)LHConfig.COMMON.prideDamageBonus.get();
        cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (double)level * rate))));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        String protect = LangData.perc((Double)LHConfig.COMMON.prideHealthBonus.get());
        String damage = LangData.perc((Double)LHConfig.COMMON.prideDamageBonus.get());
        String trait = LangData.perc(1.0 / (Double)LHConfig.COMMON.prideTraitFactor.get() - 1.0);
        list.add((Component)LangData.ITEM_CHARM_PRIDE.get(protect, damage).m_130940_(ChatFormatting.GOLD));
        list.add((Component)LangData.ITEM_CHARM_TRAIT_CHEAP.get(trait).m_130940_(ChatFormatting.RED));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity wearer = slotContext.entity();
        if (wearer == null) {
            return;
        }
        int level = DifficultyLevel.ofAny(wearer);
        stack.m_41784_().m_128405_(NAME, level);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nullable LivingEntity wearer, UUID uuid) {
        int level;
        Multimap<Attribute, AttributeModifier> ans = super.getAttributeModifiers(wearer, uuid);
        int n = level = wearer == null ? 0 : DifficultyLevel.ofAny(wearer);
        if (level > 0) {
            double rate = (Double)LHConfig.COMMON.prideHealthBonus.get() * (double)level;
            ans.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, NAME, rate, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return ans;
    }
}

